/**
 * @returns Boolean check, wether the key event has a matching key code.
 *
 * @param keyEvent key event
 */
function keyMatching(keyEvent)
{
  if (keyEvent.keyCode == 13)
  {
    return true;
  }

  return false;
}


/**
 * Toggles the submitted element, if it is a toggleable accordion panel.
 * @param element accordion toggle element
 * @param event optional key event
 */
function toggleAccordion(element, event)
{
  if (event && !keyMatching(event))
  {
    return;
  }

  if (element && element.classList.contains("accordionToggle"))
  {
    element.classList.toggle("active");
    element.firstElementChild.classList.toggle("active");
    element.nextElementSibling.classList.toggle("show");
    element.nextElementSibling.classList.toggle("hide");
  }

  // remove focus, if mouse was used
  if (!event)
  {
	element.blur();
  }
}


/**
 * Collapses all opened toggleable panels.
 *
 * @param event optional key event
 */
function collapseAllToggleDivs(event)
{
  if (event && !keyMatching(event))
  {
    return;
  }

  var accList = document.getElementsByClassName("accordionToggle");

  // iterate over all accordion panels
  for (cnt = 0; cnt < accList.length; cnt++)
  {
    accList[cnt].className = accList[cnt].className.replace("active", "").trim();
    accList[cnt].firstElementChild.className = accList[cnt].firstElementChild.className.replace("active", "").trim();
    accList[cnt].nextElementSibling.className = accList[cnt].nextElementSibling.className.replace("show", "hide").trim();
  }

  // remove focus, if mouse was used
  if (!event && document.activeElement)
  {
    document.activeElement.blur();
  }
}


/**
 * Expands all closed toggleable panels.
 *
 * @param event optional key event
 */
function expandAllToggleDivs(event)
{
  if (event && !keyMatching(event))
  {
    return;
  }

  var accList = document.getElementsByClassName("accordionToggle");

  // iterate over all accordion panels
  for (cnt = 0; cnt < accList.length; cnt++)
  {
    if (accList[cnt].className.indexOf("active") < 0)
    {
      accList[cnt].className += " active";
    }

    if (accList[cnt].firstElementChild.className.indexOf("active") < 0)
    {
      accList[cnt].firstElementChild.className += " active";
    }

	accList[cnt].nextElementSibling.className = accList[cnt].nextElementSibling.className.replace("hide", "show").trim();
  }

  // remove focus, if mouse was used
  if (!event && document.activeElement)
  {
    document.activeElement.blur();
  }
}


/**
 * Looks for the submitted anchor and opens all currently closed toggleable parent panels, if they are closed.
 * After opening all panels, jump to the submitted anchor.
 *
 * @param id anchor id
 * @param event optional key event
 */
function moveTo(anchorId, event)
{
  if (event && !keyMatching(event))
  {
    return;
  }

  // get the element that uses the submitted anchor id
  var elem = document.getElementById(anchorId);

  if (elem)
  {
    var anchorElem = elem;

    while (elem)
    {
      // if the classname denotes a panel, that is NOT shown at the moment
      if (elem.className && (elem.className.indexOf("accordionContent") >= 0) && (elem.className.indexOf("hide") >= 0))
      {
    	// get the corresponding accordion toggle
  	    var acc = document.getElementById(elem.id.substr(1));
    	if (acc)
    	{
      	  // show the panel
	      acc.classList.toggle("active");
	      acc.firstElementChild.classList.toggle("active");
	      acc.nextElementSibling.classList.toggle("show");
	      acc.nextElementSibling.classList.toggle("hide");
    	}
      }

      // go to the parent node, until the root is reached
      elem = elem.parentNode;
    }

    // jump to the submitted anchor id
    location.href = "#" + anchorId;
    anchorElem.scrollIntoView(true);
  }
}
