<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:output method="html" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" cdata-section-elements="pre listing" indent="yes" />
  <xsl:template match="/">
    <html>
      <head>
        <title>businesscard.html</title>
        <style type="text/css" media="all">
          body { padding: 5px 20px 20px 20px; background: #ffffff; color: #000000; font-family: Verdana, sans-serif; font-size: 9px; } td { font-family: Verdana, sans-serif; font-size: 9px; } td.left { font-weight: bold; color:
          #808080; text-align: right; white-space: nowrap; } td.spacer { background-color: #ffffff; } h1 { font-weight: bold; font-size: 16px; } div.businesscard_section { background-color:
          #ffffff; width: 550px; border-width: 1px; border-style: solid; border-color: #808080; } div.sub { font-size: 8px; }
        </style>

      </head>
      <body>

        <h1>Business card</h1>
        <div class="businesscard_section">
          <table summary="">
            <tr>
              <td class="left">User ID</td>
              <td>
                <xsl:value-of select="Visitenkarte/Nutzer_ID" />
              </td>
            </tr>
            <tr>
              <td class="left">Address</td>
              <td>
                <xsl:value-of select="Visitenkarte/Anrede" />
              </td>
            </tr>
            <tr>
              <td class="left">Title</td>
              <td>
                <xsl:value-of select="Visitenkarte/Titel" />
              </td>
            </tr>
            <tr>
              <td class="left">Name/Company name</td>
              <td>
                <xsl:value-of select="Visitenkarte/Name" />
              </td>
            </tr>            
            <tr>
              <td class="left">Christian name</td>
              <td>
                <xsl:value-of select="Visitenkarte/Vorname" />
              </td>
            </tr>
            <tr>
              <td class="left">Organisation</td>
              <td>
                <xsl:value-of select="Visitenkarte/Organisation" />
              </td>
            </tr>
            <tr>
              <td class="left">Organisational unit</td>
              <td>
                <xsl:value-of select="Visitenkarte/Organisationszusatz" />
              </td>
            </tr>
            <tr>
              <td class="left">Street</td>
              <td>
                <xsl:value-of select="Visitenkarte/Strasse" />
              </td>
            </tr>
            <tr>
              <td class="left">House number</td>
              <td>
                <xsl:value-of select="Visitenkarte/Hausnummer" />
              </td>
            </tr>            
            <tr>
              <td class="left">Postcode</td>
              <td>
                <xsl:value-of select="Visitenkarte/Postleitzahl" />
              </td>
            </tr>
            <tr>
              <td class="left">City</td>
              <td>
                <xsl:value-of select="Visitenkarte/Ort" />
              </td>
            </tr>
            <tr>
              <td class="left">Federal state</td>
              <td>
                <xsl:value-of select="Visitenkarte/Bundesland" />
              </td>
            </tr>             
            <tr>
              <td class="left">Country</td>
              <td>
                <xsl:value-of select="Visitenkarte/Land" />
              </td>
            </tr>
          </table>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="@version" />
  <xsl:template match="Visitenkarte" />
</xsl:stylesheet>
