<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:attribute-set name="h1">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">16pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-top">5pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">20pt</xsl:attribute>
		<xsl:attribute name="keep-with-next">always</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h2">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">13pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-top">15pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">10pt</xsl:attribute>
		<xsl:attribute name="keep-with-next">always</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h3">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">10pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">10pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table-signer-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">3</xsl:attribute>
		<xsl:attribute name="margin-bottom">3</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
		<xsl:attribute name="margin-right">1</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>	
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="seriennummer-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="pruefergebnis-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
		<xsl:attribute name="margin-top">3</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="block-style-head">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="margin-top">3</xsl:attribute>
		<xsl:attribute name="margin-bottom">3</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
		<xsl:attribute name="margin-right">1</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="block-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">1</xsl:attribute>
		<xsl:attribute name="margin-bottom">1</xsl:attribute>
		<xsl:attribute name="margin-left">0</xsl:attribute>
		<xsl:attribute name="margin-right">0</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="block-style-signer">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">0</xsl:attribute>
		<xsl:attribute name="margin-bottom">0</xsl:attribute>
		<xsl:attribute name="margin-left">0</xsl:attribute>
		<xsl:attribute name="margin-right">0</xsl:attribute>
	</xsl:attribute-set>



	<xsl:template match="Eingangsbestaetigung">
		<fo:root xml:lang="de" xmlns:fo="http://www.w3.org/1999/XSL/Format">

			<fo:layout-master-set>
				<fo:simple-page-master
					master-name="A4-portrait" page-height="297mm" page-width="210mm"
					margin-left="20mm" margin-right="10mm" margin-top="20mm"
					margin-bottom="20mm">
					<fo:region-body />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:declarations>
				<x:xmpmeta xmlns:x="adobe:ns:meta/">
					<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
						<rdf:Description rdf:about="" xmlns:dc="http://purl.org/dc/elements/1.1/">
							<dc:title>Eingangsbest&#228;tigung</dc:title>
							<dc:creator>Governikus GmbH &#38; Co. KG</dc:creator>
							<dc:description>Eingangsbest&#228;tigung</dc:description>
						</rdf:Description>

          			</rdf:RDF>
        		</x:xmpmeta>
			</fo:declarations>

			<fo:page-sequence master-reference="A4-portrait">
				<fo:flow flow-name="xsl-region-body">
					<fo:block xsl:use-attribute-sets="h1">Eingangsbest&#228;tigung</fo:block>

					<fo:block xsl:use-attribute-sets="h3" linefeed-treatment="preserve">Die Nachricht mit den unten aufgef&#252;hrten Dokumenten ist beim Empf&#228;nger eingegangen.</fo:block>

					<fo:table table-layout="fixed" width="180mm">
						<fo:table-column column-width="50mm" />
						<fo:table-column column-width="130mm" />
						<fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>            						
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Zeitpunkt des Eingangs:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of select="Eingangszeitpunkt" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Nachrichtenkennzeichen:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of select="Nachrichtenkennzeichen" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block xsl:use-attribute-sets="block-style-head">&#160;</fo:block>
					
					<fo:block xsl:use-attribute-sets="h3">Empf&#228;nger</fo:block>

					<fo:table table-layout="fixed" width="180mm">
						<fo:table-column column-width="50mm" />
						<fo:table-column column-width="130mm" />
						<fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Name:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
									  <xsl:value-of select="Empfaenger/Vorname" />
									  <xsl:if test="Empfaenger/Vorname!=''">&#160;</xsl:if>
									  <xsl:value-of select="Empfaenger/Name" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
              <fo:table-row>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style">Nutzer-ID des Empf&#228;ngers:</fo:block>
                </fo:table-cell>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style">
                    <xsl:value-of select="Empfaenger/Nutzer_ID" />
                  </fo:block>
                </fo:table-cell>
              </fo:table-row>
              <fo:table-row>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style">Aktenzeichen des Empf&#228;ngers:</fo:block>
                </fo:table-cell>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style">
                    <xsl:value-of select="Nachricht/EmpfaengerAktenzeichen" />
                  </fo:block>
                </fo:table-cell>
              </fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block xsl:use-attribute-sets="block-style-head">&#160;</fo:block>
					
					<fo:block xsl:use-attribute-sets="h3">Absender</fo:block>					

					<fo:table table-layout="fixed" width="180mm">
						<fo:table-column column-width="50mm" />
						<fo:table-column column-width="130mm" />
						<fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
						<fo:table-body>
						  <fo:table-row>
						  	<fo:table-cell>
						  		<fo:block xsl:use-attribute-sets="block-style">Name:</fo:block>
						  	</fo:table-cell>
						  	<fo:table-cell>
						  		<fo:block xsl:use-attribute-sets="block-style">
						  			<xsl:value-of select="Absender/Vorname" />
						  			<xsl:if test="Absender/Vorname!=''">&#160;</xsl:if>
						  			<xsl:value-of select="Absender/Name" />
						  		</fo:block>
						  	</fo:table-cell>
						  </fo:table-row>
						  <fo:table-row>
						    <fo:table-cell number-columns-spanned="2">
						    	<fo:block xsl:use-attribute-sets="block-style">
						    		<xsl:value-of select="Uebermittlungsweg" />
						    	</fo:block>
						    </fo:table-cell>
						  </fo:table-row>
						  <fo:table-row>
						    <fo:table-cell>
						    	<fo:block xsl:use-attribute-sets="block-style">Nutzer-ID des Absenders:</fo:block>
						    </fo:table-cell>
						    <fo:table-cell>
						    	<fo:block xsl:use-attribute-sets="block-style">
						    		<xsl:value-of select="Absender/Nutzer_ID" />
						    	</fo:block>
						    </fo:table-cell>
						  </fo:table-row>
						  <fo:table-row>
						    <fo:table-cell>
						      <fo:block xsl:use-attribute-sets="block-style">Aktenzeichen des Absenders:</fo:block>
						    </fo:table-cell>
						    <fo:table-cell>
						      <fo:block xsl:use-attribute-sets="block-style">
						        <xsl:value-of select="Nachricht/AbsenderAktenzeichen" />
						      </fo:block>
						    </fo:table-cell>
						  </fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block xsl:use-attribute-sets="block-style-head">&#160;</fo:block>          			

					<fo:block xsl:use-attribute-sets="h2" text-decoration="underline">Angaben zu den Dokumenten:</fo:block>
					<fo:block end-indent="-0.5mm">
					<fo:table table-layout="fixed" width="180mm" border-style="solid" border-width="0.5pt" border-color="black">
						<fo:table-column column-width="150mm"/>
						<fo:table-column column-width="30mm"/>
						<fo:table-header>
							<xsl:call-template name="table-dokument-head" />
						</fo:table-header>

						<fo:table-body end-indent="-0.5mm">
							<xsl:if test="count(Dokument) > 0">
		    					<xsl:apply-templates select="Dokument" />
		    				</xsl:if>
							<xsl:if test="count(Dokument) = 0">
							<fo:table-row>
								<fo:table-cell xsl:use-attribute-sets="cell-style">
									<fo:block xsl:use-attribute-sets="table-signer-style">&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cell-style">
									<fo:block xsl:use-attribute-sets="table-signer-style">&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
		    				</xsl:if>
						</fo:table-body>
					</fo:table>
           </fo:block> 
				</fo:flow>
			</fo:page-sequence>

		</fo:root>
	</xsl:template>

	<xsl:template match="Dokument">
    <fo:table-row>
      <fo:table-cell xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="table-signer-style" linefeed-treatment="preserve">
          <xsl:value-of select="DateiName" />
        </fo:block>
      </fo:table-cell>

      <fo:table-cell xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="table-signer-style">
          <xsl:value-of select="Format" />
        </fo:block>
      </fo:table-cell>
	 </fo:table-row>
	</xsl:template>


  <xsl:template name="table-dokument-head">
    <fo:table-row>
      <fo:table-cell background-color="#E5E4E2" border-width="0.5pt" border-color="black" border-start-style="solid" border-end-style="solid" border-before-style="solid" border-after-style="solid" >
        <fo:block linefeed-treatment="preserve"
          xsl:use-attribute-sets="block-style-head">Dateiname
        </fo:block>
      </fo:table-cell>
      <fo:table-cell background-color="#E5E4E2" border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="solid">
        <fo:block xsl:use-attribute-sets="block-style-head">Format</fo:block>
      </fo:table-cell>
    </fo:table-row>
	</xsl:template>

</xsl:stylesheet>