<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" cdata-section-elements="pre listing" indent="yes" />

  <xsl:template match="Eingangsbestaetigung">
    <html>
      <head>
        <title>Eingangsbestätigung</title>
        <style type="text/css" media="all">
          body { padding: 5px 20px 20px 20px; background: #ffffff; color: #000000; font-family: Verdana, sans-serif; font-size: 12px; width: 620px;}
          h1 { font-family: Verdana, sans-serif; text-align: center; font-weight: bold; font-size: 16px;}
          h2 { font-family: Verdana, sans-serif; text-decoration: none; font-weight: bold; font-size: 14px;}
          h3 { font-family: Verdana, sans-serif; text-decoration: none; font-weight: bold; font-size: 12px;}
          p { font-family: Verdana, sans-serif; text-decoration: none; font-style: normal; font-weight: normal; font-size: 12px; }
          th { font-family: Verdana, sans-serif; font-size: 12px; font-weight: bold; background-color:E5E4E2; }
          td { font-family: Verdana, sans-serif; font-size: 12px;}
          td.left { font-family: Verdana, sans-serif; font-size: 12px; font-weight: bold; color: #000000; vertical-align: top; text-align: left; white-space: nowrap;}
          div.content { padding: 5px 5px 5px 5px; background-color: #ffffff; border-width: 1px; border-style: solid; border-color: #808080; }
        </style>
      </head>
      <body>
        <h1>Eingangsbestätigung vom <xsl:value-of select="Erstellungszeitpunkt" /></h1>        
        <div class="content">
        <h2>Angaben zur Nachricht:</h2>
        <br/>
        <xsl:if test="Uebermittlungsweg!=''"><h3><xsl:value-of select="Uebermittlungsweg" /></h3><br/></xsl:if>        
        <table table-layout="fixed" width="600px">
          <tr>
            <td class="left" width="200px">Eingang auf dem Server:</td>
            <td width="400px"><xsl:value-of select="Eingangszeitpunkt" /></td>
          </tr>
          <tr>
            <td class="left" width="200px">Abholzeitpunkt:</td>
            <td width="400px"><xsl:value-of select="Abholzeitpunkt" /></td>
          </tr>
        </table>
        <br/>
        <table table-layout="fixed" width="600px">
          <tr>
            <td class="left" width="200px">Empfänger:</td>
            <td width="400px"><xsl:value-of select="Empfaenger/Vorname" /><xsl:if test="Empfaenger/Vorname!=''">&#160;</xsl:if><xsl:value-of select="Empfaenger/Name" /></td>
          </tr>
          <tr>
            <td class="left" width="200px">Nutzer-ID des Empfängers:</td>
            <td width="400px"><xsl:value-of select="Empfaenger/Nutzer_ID" /></td>
          </tr>
        </table>
        <br/>
        <table table-layout="fixed" width="600px">
          <tr>
            <td class="left" width="200px">Nachrichtenkennzeichen:</td>
            <td width="400px"><xsl:value-of select="Nachrichtenkennzeichen" /></td>
          </tr>
          <tr>
            <td class="left" width="200px">OSCI-Manager:</td>
            <td width="400px"><xsl:value-of select="OsciManager" /></td>
          </tr>          
          <tr>
            <td class="left" width="200px">Nachrichtentyp:</td>
            <td width="400px"><xsl:value-of select="Nachricht/Nachrichtentyp" /></td>
          </tr>
          <tr>
            <td class="left" width="200px">Betreff:</td>
            <td width="400px"><xsl:value-of select="Nachricht/Betreff" /></td>
          </tr>                    
        </table>        
        </div>
        <br/>
        <div class="content">
        <h2>Angaben zu den Dokumenten:</h2>
        <br/>
        <table table-layout="fixed" width="600px" style="border:1px solid black;border-collapse:collapse;">
          <tr>
            <th style="border:1px solid black;" width="450px">Dateiname</th>
            <th style="border:1px solid black;" width="150px">Format</th>
          </tr>
          <xsl:if test="count(Dokument) > 0">
            <xsl:apply-templates select="Dokument" />
          </xsl:if>
          <xsl:if test="count(Dokument) = 0">
              <tr>
                <td style="border:1px solid black; padding-left:5px">&#160;</td>
                <td style="border:1px solid black; padding-left:5px">&#160;</td>
              </tr>
           </xsl:if>          
        </table>
        </div>
      </body>
    </html>
  </xsl:template>
  
  <xsl:template match="Dokument">
    <tr>        
      <td style="border:1px solid black; padding-left:5px"><xsl:value-of select="DateiName" /></td>
      <td style="border:1px solid black; padding-left:5px"><xsl:value-of select="Format" /></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="@version" />
  <xsl:template match="root" />
</xsl:stylesheet>
