<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:attribute-set name="h1">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">16pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-top">5pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">20pt</xsl:attribute>
		<xsl:attribute name="keep-with-next">always</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h2">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">13pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="margin-top">15pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">10pt</xsl:attribute>
		<xsl:attribute name="keep-with-next">always</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="h3">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">10pt</xsl:attribute>
		<xsl:attribute name="margin-bottom">10pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table-signer-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">3</xsl:attribute>
		<xsl:attribute name="margin-bottom">3</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
		<xsl:attribute name="margin-right">1</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>	
		<xsl:attribute name="border-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="border-color">black</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="seriennummer-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="pruefergebnis-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
		<xsl:attribute name="margin-top">3</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="block-style-head">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="margin-top">3</xsl:attribute>
		<xsl:attribute name="margin-bottom">3</xsl:attribute>
		<xsl:attribute name="margin-left">3</xsl:attribute>
		<xsl:attribute name="margin-right">1</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="block-style">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">1</xsl:attribute>
		<xsl:attribute name="margin-bottom">1</xsl:attribute>
		<xsl:attribute name="margin-left">0</xsl:attribute>
		<xsl:attribute name="margin-right">0</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="block-style-signer">
		<xsl:attribute name="font-family">DroidSans</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="margin-top">0</xsl:attribute>
		<xsl:attribute name="margin-bottom">0</xsl:attribute>
		<xsl:attribute name="margin-left">0</xsl:attribute>
		<xsl:attribute name="margin-right">0</xsl:attribute>
	</xsl:attribute-set>	



	<xsl:template match="Pruefvermerk">
		<fo:root xml:lang="de" xmlns:fo="http://www.w3.org/1999/XSL/Format">

			<fo:layout-master-set>
				<fo:simple-page-master
					master-name="A4-portrait" page-height="297mm" page-width="210mm"
					margin-left="20mm" margin-right="10mm" margin-top="20mm"
					margin-bottom="20mm">
					<fo:region-body />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:declarations>
				<x:xmpmeta xmlns:x="adobe:ns:meta/">
					<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
						<rdf:Description rdf:about="" xmlns:dc="http://purl.org/dc/elements/1.1/">
						  <dc:title>Pr&#252;fvermerk</dc:title>
						  <dc:creator>Governikus GmbH &#38; Co. KG</dc:creator>
						  <dc:description>Pr&#252;fvermerk</dc:description>
					 </rdf:Description>

					</rdf:RDF>
				</x:xmpmeta>
			</fo:declarations>

			<fo:page-sequence master-reference="A4-portrait">
				<fo:flow flow-name="xsl-region-body">
					<fo:block xsl:use-attribute-sets="h1">
						Pr&#252;fvermerk
					</fo:block>

					<fo:block xsl:use-attribute-sets="block-style">Die unten
						aufgef&#252;hrten
						Dokumente sind elektronisch
						eingegangen. Die
						technische Pr&#252;fung der
						elektronischen Dokumente am
						<xsl:value-of select="Erstellungszeitpunkt" />
						hat folgendes
						Ergebnis erbracht:
					</fo:block>

					<fo:block xsl:use-attribute-sets="h2" text-decoration="underline">Angaben zur Nachricht:
					</fo:block>

					<fo:block xsl:use-attribute-sets="h3" linefeed-treatment="preserve">
						<xsl:value-of select="Uebermittlungsweg" />
					</fo:block>

					<fo:table table-layout="fixed" width="180mm">
						<fo:table-column column-width="50mm" />
						<fo:table-column column-width="130mm" />
						<fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Eingangszeitpunkt:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of select="Eingangszeitpunkt" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										Absender:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of select="Absender/Vorname" />
										<xsl:if test="Absender/Vorname!=''">&#160;</xsl:if>
										<xsl:value-of select="Absender/Name" />
									</fo:block>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:if test="Absender/Berufstraegereigenschaft!=''" />
										<xsl:value-of select="Absender/Berufstraegereigenschaft" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Nutzer-ID des Absenders:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of select="Absender/Nutzer_ID" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Aktenzeichen des Absenders:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of
											select="Nachricht/AbsenderAktenzeichen" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>

					<fo:block xsl:use-attribute-sets="block-style-head">&#160;</fo:block>

					<fo:table table-layout="fixed" width="180mm">
						<fo:table-column column-width="50mm" />
						<fo:table-column column-width="130mm" />
						<fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Empf&#228;nger:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
									  <xsl:value-of select="Empfaenger/Vorname" />
									  <xsl:if test="Empfaenger/Vorname!=''">&#160;</xsl:if>
									  <xsl:value-of select="Empfaenger/Name" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Aktenzeichen des Empf&#228;ngers:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of
											select="Nachricht/EmpfaengerAktenzeichen" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block xsl:use-attribute-sets="block-style-head">&#160;</fo:block>

					<fo:table table-layout="fixed" width="180mm">
						<fo:table-column column-width="50mm" />
						<fo:table-column column-width="130mm" />
						<fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">Nachrichtenkennzeichen:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="block-style">
										<xsl:value-of select="Nachrichtenkennzeichen" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>

					<fo:block xsl:use-attribute-sets="h2" text-decoration="underline">Angaben zu den Dokumenten:</fo:block>
					<fo:block end-indent="-0.5mm">
					<fo:table table-layout="fixed" width="180mm" border-style="solid" border-width="0.5pt" border-color="black">
						<fo:table-column column-width="8mm"/>
						<fo:table-column column-width="172mm"/>
						<fo:table-body>
            			
            			<fo:table-row  height="85mm">
            			<fo:table-cell display-align="after" border-style="solid" border-width="0.5pt" border-color="black" padding-bottom="3">
            				<fo:block-container reference-orientation="90" display-align="before">
            					<fo:block>
									<xsl:apply-templates select="ContainerSignatur" />
								</fo:block>
							</fo:block-container>
						</fo:table-cell>

						<fo:table-cell padding-top="3" >
            				<fo:table table-layout="fixed" width="172mm" border-style="solid" border-width="1pt" border-color="black">
	              				<fo:table-column column-width="4mm"/>
    	          				<fo:table-column column-width="43mm"/>
        	      				<fo:table-column column-width="12mm"/>
            	  				<fo:table-column column-width="113mm"/>
					
								<fo:table-header>
									<xsl:call-template name="table-dokument-head" />
								</fo:table-header>

				              	<fo:table-body end-indent="-0.5mm">
				              		<xsl:if test="count(Dokument) > 0">
		    							<xsl:apply-templates select="Dokument" />
		    						</xsl:if>
			        	      		<xsl:if test="count(Dokument) = 0">
										<fo:table-row>
      										<fo:table-cell number-columns-spanned="4"
        										xsl:use-attribute-sets="table-signer-style">
        										<fo:block xsl:use-attribute-sets="block-style-head">&#160;</fo:block>
	      									</fo:table-cell>
										</fo:table-row>
			    					</xsl:if>
								</fo:table-body>
          					</fo:table>
          					<xsl:if test="nurImVHN !=''">
          					   <fo:block xsl:use-attribute-sets="table-signer-style" linefeed-treatment="preserve">
                        			ACHTUNG! Im Herkunftsnachweis sind Hashwerte enthalten, zu denen keine Dokumente in der Nachricht beigefügt sind.
          					   </fo:block>
          					</xsl:if>
          				</fo:table-cell>
          				</fo:table-row>
					</fo:table-body>
				</fo:table>
				</fo:block>

				</fo:flow>
			</fo:page-sequence>

		</fo:root>
	</xsl:template>

  <xsl:template match="ContainerSignatur">
  	<fo:block xsl:use-attribute-sets="table-signer-style" white-space="nowrap" >
    	Die gesamte Nachricht ist mit einer Containersignatur versehen.
    </fo:block>
  </xsl:template>

	<xsl:template match="Dokument">
	
    <fo:table-row>
    			
      <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="table-signer-style" linefeed-treatment="preserve">
          <xsl:value-of select="DateiName" />
        </fo:block>
      </fo:table-cell>

      <fo:table-cell xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="table-signer-style">
          <xsl:value-of select="Format" />
        </fo:block>
      </fo:table-cell>

      <fo:table-cell>
        <fo:block xsl:use-attribute-sets="block-style-signer"
          padding-top="0pt" padding-bottom="0pt" padding-left="0pt" padding-right="0pt">
          
            <xsl:if test="Signatur/Pruefergebnis/Gueltigkeitspruefung ='keine_inhaltsdatei'">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="113mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>                
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="table-signer-style">Keine Prüfung möglich, da die Signaturdatei keiner Inhaltsdatei zugeordnet werden konnte.</fo:block>
                  </fo:table-cell>             
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
            <xsl:if test="Signatur/Pruefergebnis/Gueltigkeitspruefung ='nicht_lesbar'">
              <fo:table table-layout="fixed" width="120mm">
                <fo:table-column column-width="120mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block xsl:use-attribute-sets="table-signer-style" linefeed-treatment="preserve">Keine Prüfung möglich, da die Datei nicht lesbar ist.</fo:block>
                  </fo:table-cell>
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
            <xsl:if test="Signatur/Pruefergebnis/Gueltigkeitspruefung ='pruefung_unbestimmt'">
              <fo:table table-layout="fixed" width="120mm">
                <fo:table-column column-width="120mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block xsl:use-attribute-sets="table-signer-style" linefeed-treatment="preserve">Es konnte nicht geprüft werden, ob eine qualifizierte Signatur nach ERVB vorliegt.</fo:block>
                  </fo:table-cell>
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
            <xsl:if test="Signatur/Pruefergebnis/AenderungNachSignaturanbringung ='true'">
              <fo:table table-layout="fixed" width="120mm">
                <fo:table-column column-width="120mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block xsl:use-attribute-sets="table-signer-style" linefeed-treatment="preserve">Die letzte Version des Dokumentes wurde nicht signiert</fo:block>
                  </fo:table-cell>
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
                
            <xsl:if test="count(Signatur) > 0">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="20mm"/>
                <fo:table-column column-width="30mm"/>
                <fo:table-column column-width="25mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="20mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>
                  <xsl:apply-templates select="Signatur" />
                </fo:table-body>
              </fo:table>
            </xsl:if>
            <xsl:if test="count(Signatur) = 0">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="113mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>                
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block xsl:use-attribute-sets="table-signer-style">
                        nein
                     </fo:block>
                  </fo:table-cell>             
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
          </fo:block>
      </fo:table-cell>

	 </fo:table-row>
	 
	 
	 <xsl:if test="count(inneresDokument) > 0">
		<xsl:apply-templates select="inneresDokument" /> 	
	 </xsl:if>

	</xsl:template>


	<xsl:template match="inneresDokument">
    <fo:table-row>
    
      <fo:table-cell xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="table-signer-style">
          &#160;
        </fo:block>
      </fo:table-cell>
          
      <fo:table-cell xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="table-signer-style">
          <xsl:value-of select="DateiName" />
        </fo:block>
      </fo:table-cell>

      <fo:table-cell xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="table-signer-style">
          <xsl:value-of select="Format" />
        </fo:block>
      </fo:table-cell>
      
      <fo:table-cell xsl:use-attribute-sets="cell-style">
        <fo:block xsl:use-attribute-sets="block-style-signer"
          padding-top="0pt" padding-bottom="0pt" padding-left="0pt" padding-right="0pt">

            <xsl:if test="Signatur/Pruefergebnis/Gueltigkeitspruefung ='keine_inhaltsdatei'">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="113mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="table-signer-style">Keine Prüfung möglich, da die Signaturdatei keiner Inhaltsdatei zugeordnet werden konnte.</fo:block>
                  </fo:table-cell>
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
            <xsl:if test="Signatur/Pruefergebnis/Gueltigkeitspruefung ='nicht_lesbar'">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="113mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="table-signer-style">Keine Prüfung möglich, da die Datei nicht lesbar ist.</fo:block>
                  </fo:table-cell>
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
            <xsl:if test="Signatur/Pruefergebnis/Gueltigkeitspruefung ='pruefung_unbestimmt'">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="113mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>                
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="table-signer-style">Es konnte nicht geprüft werden, ob eine qualifizierte Signatur nach ERVB vorliegt.</fo:block>
                  </fo:table-cell>             
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
            <xsl:if test="Signatur/Pruefergebnis/AenderungNachSignaturanbringung ='true'">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="113mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>                
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="table-signer-style">Die letzte Version des Dokumentes wurde nicht signiert</fo:block>
                  </fo:table-cell>             
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>                                         

            <xsl:if test="count(Signatur) > 0">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="20mm"/>
                <fo:table-column column-width="30mm"/>
                <fo:table-column column-width="25mm"/>
                <fo:table-column column-width="18mm"/>
                <fo:table-column column-width="20mm"/>
                <fo:table-body>
                  <xsl:apply-templates select="Signatur" />
                </fo:table-body>
              </fo:table>
            </xsl:if>
            <xsl:if test="count(Signatur) = 0">
              <fo:table table-layout="fixed" width="113mm">
                <fo:table-column column-width="103mm"/>
                <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
                <fo:table-body>                
                 <fo:table-row>
                  <fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
                     <fo:block xsl:use-attribute-sets="table-signer-style">
                        nein
                     </fo:block>
                  </fo:table-cell>             
                </fo:table-row>
               </fo:table-body>
               </fo:table>
            </xsl:if>
          </fo:block>
      </fo:table-cell>
			      
	 </fo:table-row>      
</xsl:template>

  <xsl:template name="table-dokument-head">
    <fo:table-row>
      <fo:table-cell background-color="#E5E4E2" border-width="0.5pt" border-color="black" border-start-style="solid" border-end-style="solid" border-before-style="solid" border-after-style="solid" number-columns-spanned="2" >
        <fo:block linefeed-treatment="preserve"
          xsl:use-attribute-sets="block-style-head">Dateiname
        </fo:block>
      </fo:table-cell>
      <fo:table-cell background-color="#E5E4E2" border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="solid">
        <fo:block xsl:use-attribute-sets="block-style-head">Format</fo:block>
      </fo:table-cell>
      <fo:table-cell background-color="#E5E4E2" border-width="0.5pt" border-color="black" border-start-style="solid" border-end-style="none" border-before-style="solid" border-after-style="solid">
        <fo:block xsl:use-attribute-sets="block-style-head">Informationen zu(r) qualifizierten elektronischen Signatur(en)
        </fo:block>
        <fo:block padding-top="2pt" padding-bottom="0pt"
          padding-left="0pt" padding-right="0pt">
          <fo:table table-layout="fixed" width="113mm">
            <fo:table-column column-width="20mm" />
            <fo:table-column column-width="30mm" />
            <fo:table-column column-width="25mm" />
            <fo:table-column column-width="18mm" />
            <fo:table-column column-width="20mm" />
            <fo:table-header>
              <xsl:call-template name="table-signer-head" />
            </fo:table-header>
            <fo:table-body><fo:table-row><fo:table-cell><fo:block /></fo:table-cell><fo:table-cell><fo:block /></fo:table-cell><fo:table-cell><fo:block /></fo:table-cell><fo:table-cell><fo:block /></fo:table-cell><fo:table-cell><fo:block /></fo:table-cell></fo:table-row></fo:table-body>
          </fo:table>
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
	</xsl:template>

	<xsl:template name="table-signer-head">
		<fo:table-row>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="none">
				<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="block-style-head">Qualifiziert &#xA;signiert nach ERVB?</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="none">
				<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="block-style-head">durch</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="none">
				<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="block-style-head">Berufsbezogenes Attribut</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="none">
				<fo:block xsl:use-attribute-sets="block-style-head">am</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="none">
				<fo:block xsl:use-attribute-sets="block-style-head">Prüfergebnis</fo:block>
			</fo:table-cell>			
		</fo:table-row>
	</xsl:template>

	<xsl:template match="Signatur">
		<fo:table-row>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="solid">
        		<fo:block xsl:use-attribute-sets="table-signer-style">
          			<xsl:if test="QualifiziertNachERVB ='Containersignatur'">Containersig natur</xsl:if>
          			<xsl:if test="QualifiziertNachERVB !='Containersignatur'">
             		<xsl:value-of select="QualifiziertNachERVB" />
          			</xsl:if>
        		</fo:block>
			</fo:table-cell>
      		<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="solid">
        		<fo:block xsl:use-attribute-sets="table-signer-style">
          			<xsl:value-of select="SigniertDurch" />
        		</fo:block>
        		<xsl:if test="SigniertDurch !=''">
        		  <fo:block xsl:use-attribute-sets="seriennummer-style">
          			(<xsl:value-of select="Seriennummer" />)
        		  </fo:block>
        		</xsl:if>
      		</fo:table-cell>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="solid">
				<fo:block xsl:use-attribute-sets="table-signer-style">
					<xsl:value-of select="BerufsbezogenesAttribut" />
				</fo:block>
			</fo:table-cell>
      		<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="solid" border-before-style="solid" border-after-style="solid">
        		<fo:block xsl:use-attribute-sets="table-signer-style">
          			<xsl:value-of select="SigniertAm" />
        		</fo:block>
      		</fo:table-cell>
			<fo:table-cell border-width="0.5pt" border-color="black" border-start-style="none" border-end-style="none" border-before-style="solid" border-after-style="solid">
          <fo:block xsl:use-attribute-sets="table-signer-style">
            <xsl:if test="Pruefergebnis/Gueltigkeitspruefung ='gueltig'">
              <fo:inline font-family="DroidSans" font-size="10pt" border-width="1pt" border-style="solid" background-color="#ccffcc" border-color="#227722" padding="2pt" margin-right="4pt">&#8730;</fo:inline> <fo:inline xsl:use-attribute-sets="pruefergebnis-style"> G&#252;ltigkeit</fo:inline>
            </xsl:if>
            <xsl:if test="Pruefergebnis/Gueltigkeitspruefung ='ungueltig'">
              <fo:inline font-family="DroidSans" font-size="10pt" border-width="1pt" border-style="solid" background-color="#ffcccc" border-color="#772222" padding="2pt"  margin-right="4pt">X</fo:inline> <fo:inline xsl:use-attribute-sets="pruefergebnis-style"> G&#252;ltigkeit</fo:inline>
            </xsl:if>
            <xsl:if test="Pruefergebnis/Gueltigkeitspruefung ='unbestimmt'">
              <fo:inline font-family="DroidSans" font-size="10pt" border-width="1pt" border-style="solid" background-color="#ffffcc" border-color="#777722" padding="2pt" margin-right="4pt">&#033;</fo:inline> <fo:inline xsl:use-attribute-sets="pruefergebnis-style"> G&#252;ltigkeit</fo:inline>
            </xsl:if>
          </fo:block>
          <fo:block xsl:use-attribute-sets="table-signer-style">
            <xsl:if test="Pruefergebnis/Integritaetspruefung ='gueltig'">
              <fo:inline font-family="DroidSans" font-size="10pt" border-width="1pt" border-style="solid" background-color="#ccffcc" border-color="#227722" padding="2pt" margin-right="4pt">&#8730;</fo:inline> <fo:inline xsl:use-attribute-sets="pruefergebnis-style"> Integrit&#228;t</fo:inline>        
            </xsl:if>
            <xsl:if test="Pruefergebnis/Integritaetspruefung ='ungueltig'">
              <fo:inline font-family="DroidSans" font-size="10pt" border-width="1pt" border-style="solid" background-color="#ffcccc" border-color="#772222" padding="2pt" margin-right="4pt">X</fo:inline> <fo:inline xsl:use-attribute-sets="pruefergebnis-style"> Integrit&#228;t</fo:inline>                                       
            </xsl:if>
            <xsl:if test="Pruefergebnis/Integritaetspruefung ='unbestimmt'">
              <fo:inline font-family="DroidSans" font-size="10pt" border-width="1pt" border-style="solid" background-color="#ffffcc" border-color="#777722" padding="2pt" margin-right="4pt">&#033;</fo:inline> <fo:inline xsl:use-attribute-sets="pruefergebnis-style"> Integrit&#228;t</fo:inline>
            </xsl:if>
          </fo:block>
    	 </fo:table-cell>
	  </fo:table-row>
	</xsl:template>

</xsl:stylesheet>