<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format">

  <xsl:attribute-set name="h1">
    <xsl:attribute name="font-family">DroidSans</xsl:attribute>
    <xsl:attribute name="font-size">16pt</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
    <xsl:attribute name="margin-top">5pt</xsl:attribute>
    <xsl:attribute name="margin-bottom">20pt</xsl:attribute>
    <xsl:attribute name="keep-with-next">always</xsl:attribute>
    <xsl:attribute name="text-align">center</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="block-style">
    <xsl:attribute name="font-family">DroidSans</xsl:attribute>
    <xsl:attribute name="font-size">9pt</xsl:attribute>
    <xsl:attribute name="text-align">left</xsl:attribute>
    <xsl:attribute name="margin-top">1</xsl:attribute>
    <xsl:attribute name="margin-bottom">1</xsl:attribute>
    <xsl:attribute name="margin-left">0</xsl:attribute>
    <xsl:attribute name="margin-right">0</xsl:attribute>
  </xsl:attribute-set>

  <xsl:template match="Nachricht">
    <fo:root xml:lang="de" xmlns:fo="http://www.w3.org/1999/XSL/Format">

      <fo:layout-master-set>
        <fo:simple-page-master
          master-name="A4-portrait" page-height="297mm" page-width="210mm"
          margin-left="20mm" margin-right="10mm" margin-top="20mm"
          margin-bottom="20mm">
          <fo:region-body />
        </fo:simple-page-master>
      </fo:layout-master-set>

      <fo:declarations>
        <x:xmpmeta xmlns:x="adobe:ns:meta/">
          <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
            <rdf:Description rdf:about="" xmlns:dc="http://purl.org/dc/elements/1.1/">
              <dc:title>Governikus COM Vibilia-Nachricht</dc:title>
              <dc:creator>Governikus GmbH &#38; Co. KG</dc:creator>
              <dc:description>Governikus COM Vibilia-Nachricht</dc:description>
            </rdf:Description>
          </rdf:RDF>
        </x:xmpmeta>
      </fo:declarations>

      <fo:page-sequence master-reference="A4-portrait">
        <fo:flow flow-name="xsl-region-body">
          <fo:block xsl:use-attribute-sets="h1"> Governikus COM Vibilia-Nachricht</fo:block>

          <fo:table table-layout="fixed" width="180mm">
            <fo:table-column column-width="25mm" />
            <fo:table-column column-width="155mm" />
            <fo:table-header><fo:table-row><fo:table-cell><fo:block></fo:block></fo:table-cell><fo:table-cell><fo:block></fo:block></fo:table-cell></fo:table-row></fo:table-header>
            <fo:table-body>
              <fo:table-row>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style">Betreff:</fo:block>
                </fo:table-cell>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style">
                    <xsl:value-of select="Betreff" />
                  </fo:block>
                </fo:table-cell>
              </fo:table-row>
              <fo:table-row>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style">Nachricht:</fo:block>
                </fo:table-cell>
                <fo:table-cell>
                  <fo:block xsl:use-attribute-sets="block-style" linefeed-treatment="preserve">
                    <xsl:value-of select="Text" />
                  </fo:block>
                </fo:table-cell>
              </fo:table-row>
            </fo:table-body>
          </fo:table>
        </fo:flow>
      </fo:page-sequence>

    </fo:root>
  </xsl:template>

</xsl:stylesheet>