/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.mcard.jce.sig.delegate;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public final class KeyStoreBasedX509KeyManager
implements X509KeyManager {
    private X509KeyManager okm;
    private KeyStore keyStore;
    private String clientAlias;
    private String serverAlias;
    private String[] serverAliases;

    public KeyStoreBasedX509KeyManager(KeyStore keyStore, char[] password, String keyManagerFactoryAlgorithm) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        this.setKeyStore(keyStore, password, keyManagerFactoryAlgorithm);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.clientAlias == null || this.clientAlias.trim().isEmpty()) {
            return this.okm.chooseClientAlias(keyType, issuers, socket);
        }
        return this.clientAlias;
    }

    public List<String> aliases() {
        try {
            return Collections.list(this.keyStore.aliases());
        }
        catch (KeyStoreException e) {
            return Collections.emptyList();
        }
    }

    public boolean isKeyEntry(String alias) {
        try {
            return this.keyStore.isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public boolean isCertificateEntry(String alias) {
        try {
            return this.keyStore.isCertificateEntry(alias);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public Certificate getCertificate(String alias) {
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public String getCertificateAlias(Certificate cert) {
        try {
            return this.keyStore.getCertificateAlias(cert);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certificates = this.keyStore.getCertificateChain(alias);
            X509Certificate[] x509certificates = new X509Certificate[certificates.length];
            for (int i = 0; i < certificates.length; ++i) {
                x509certificates[i] = (X509Certificate)certificates[i];
            }
            return x509certificates;
        }
        catch (Exception exception) {
            return this.okm.getCertificateChain(alias);
        }
    }

    public String getClientAlias() {
        return this.clientAlias;
    }

    public void setAlias(String clientAlias) {
        this.clientAlias = clientAlias;
    }

    public void setKeyStore(KeyStore keyStore, char[] password, String keyManagerFactoryAlgorithm) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        this.keyStore = keyStore;
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm == null || keyManagerFactoryAlgorithm.isEmpty() ? KeyManagerFactory.getDefaultAlgorithm() : keyManagerFactoryAlgorithm);
        keyManagerFactory.init(keyStore, password);
        this.okm = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.serverAlias == null || this.serverAlias.trim().isEmpty()) {
            this.okm.chooseServerAlias(keyType, issuers, socket);
        }
        return this.serverAlias;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] clientAliases = this.aliases().toArray(new String[0]);
        if (clientAliases == null || clientAliases.length == 0) {
            return this.okm.getClientAliases(keyType, issuers);
        }
        return clientAliases;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey result = null;
        try {
            result = (PrivateKey)this.keyStore.getKey(alias, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            // empty catch block
        }
        if (result == null) {
            return this.okm.getPrivateKey(alias);
        }
        return result;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (this.serverAliases == null || this.serverAliases.length == 0) {
            return this.okm.getServerAliases(keyType, issuers);
        }
        return this.serverAliases;
    }

    public String[] getServerAliases() {
        return this.serverAliases;
    }

    public void setServerAliases(String[] serverAliases) {
        this.serverAliases = serverAliases;
    }

    public String getServerAlias() {
        return this.serverAlias;
    }

    public void setServerAlias(String serverAlias) {
        this.serverAlias = serverAlias;
    }
}

