/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.mcard.jce.sig.delegate;

import de.governikus.mcard.jce.sig.delegate.JCEDelegateBaseSignature;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCEDelegateSignature
extends JCEDelegateBaseSignature {
    private static final Logger LOG = LoggerFactory.getLogger(JCEDelegateSignature.class);

    protected JCEDelegateSignature(String hashAlgorithm, String algorithm) {
        super(hashAlgorithm + "with" + algorithm);
        LOG.info("creating {} with {} - full algorithm: {}", new Object[]{this.getClass().getName(), hashAlgorithm, algorithm});
    }

    protected static abstract class CVCECDSASignature
    extends JCEDelegateSignature {
        protected CVCECDSASignature(String hashAlgorithm) {
            super(hashAlgorithm, "CVC-ECDSA");
        }

        public static class WHIRLPOOL
        extends CVCECDSASignature {
            public WHIRLPOOL() {
                super("WHIRLPOOL");
            }
        }

        public static class RIPEMD160
        extends CVCECDSASignature {
            public RIPEMD160() {
                super("RIPEMD160");
            }
        }

        public static class SHA512
        extends CVCECDSASignature {
            public SHA512() {
                super("SHA512");
            }
        }

        public static class SHA384
        extends CVCECDSASignature {
            public SHA384() {
                super("SHA384");
            }
        }

        public static class SHA224
        extends CVCECDSASignature {
            public SHA224() {
                super("SHA224");
            }
        }

        public static class SHA256
        extends CVCECDSASignature {
            public SHA256() {
                super("SHA256");
            }
        }

        public static class SHA1
        extends CVCECDSASignature {
            public SHA1() {
                super("SHA1");
            }
        }

        public static class MD5
        extends CVCECDSASignature {
            public MD5() {
                super("MD5");
            }
        }
    }

    protected static abstract class X962ECDSASignature
    extends JCEDelegateSignature {
        protected X962ECDSASignature(String hashAlgorithm) {
            super(hashAlgorithm, "ECDSA");
        }

        public static class WHIRLPOOL
        extends X962ECDSASignature {
            public WHIRLPOOL() {
                super("WHIRLPOOL");
            }
        }

        public static class RIPEMD160
        extends X962ECDSASignature {
            public RIPEMD160() {
                super("RIPEMD160");
            }
        }

        public static class SHA512
        extends X962ECDSASignature {
            public SHA512() {
                super("SHA512");
            }
        }

        public static class SHA384
        extends X962ECDSASignature {
            public SHA384() {
                super("SHA384");
            }
        }

        public static class SHA224
        extends X962ECDSASignature {
            public SHA224() {
                super("SHA224");
            }
        }

        public static class SHA256
        extends X962ECDSASignature {
            public SHA256() {
                super("SHA256");
            }
        }

        public static class SHA1
        extends X962ECDSASignature {
            public SHA1() {
                super("SHA1");
            }
        }

        public static class MD5
        extends X962ECDSASignature {
            public MD5() throws NoSuchAlgorithmException, NoSuchProviderException {
                super("MD5");
            }
        }
    }

    public static class WHIRLPOOL
    extends RSA {
        public WHIRLPOOL() {
            super("WHIRLPOOL");
        }
    }

    public static class RIPEMD160
    extends RSA {
        public RIPEMD160() {
            super("RIPEMD160");
        }
    }

    public static class SHA512
    extends RSA {
        public SHA512() {
            super("SHA512");
        }
    }

    public static class SHA384
    extends RSA {
        public SHA384() {
            super("SHA384");
        }
    }

    public static class SHA224
    extends RSA {
        public SHA224() {
            super("SHA224");
        }
    }

    public static class SHA256
    extends RSA {
        public SHA256() {
            super("SHA256");
        }
    }

    public static class SHA1
    extends RSA {
        public SHA1() {
            super("SHA1");
        }
    }

    public static class MD5
    extends RSA {
        public MD5() {
            super("MD5");
        }
    }

    public static class RSA
    extends JCEDelegateSignature {
        public RSA(String hashAlgorithm) {
            super(hashAlgorithm, "RSA");
        }
    }

    public static class WHIRLPOOLDINSIG
    extends RSADINSIG {
        public WHIRLPOOLDINSIG() {
            super("WHIRLPOOL");
        }
    }

    public static class SHA512DINSIG
    extends RSADINSIG {
        public SHA512DINSIG() {
            super("SHA512");
        }
    }

    public static class SHA384DINSIG
    extends RSADINSIG {
        public SHA384DINSIG() {
            super("SHA384");
        }
    }

    public static class SHA256DINSIG
    extends RSADINSIG {
        public SHA256DINSIG() {
            super("SHA256");
        }
    }

    public static class SHA224DINSIG
    extends RSADINSIG {
        public SHA224DINSIG() {
            super("SHA224");
        }
    }

    public static class RIPEMD160DINSIG
    extends RSADINSIG {
        public RIPEMD160DINSIG() {
            super("RIPEMD160");
        }
    }

    public static class SHA1DINSIG
    extends RSADINSIG {
        public SHA1DINSIG() {
            super("SHA1");
        }
    }

    public static class MD5DINSIG
    extends RSADINSIG {
        public MD5DINSIG() {
            super("MD5");
        }
    }

    public static class RSADINSIG
    extends JCEDelegateSignature {
        public RSADINSIG(String hashAlgorithm) {
            super(hashAlgorithm, "RSA/ISO9796-2rnd");
        }
    }
}

