/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.mcard.jce.sig.delegate;

import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEDelegateRawRSASignature
extends SignatureSpi {
    private static final String KEY_ALGORITHM_RSA = "RSA";
    private static final Logger LOG = LoggerFactory.getLogger(JCEDelegateRawRSASignature.class);
    private static final Map<String, String> MAP_OID_TO_JCE_NAME;
    private static final Map<Integer, String> MAP_DIGEST_LENGTH_TO_JCE_NAME;
    private ByteArrayOutputStream baos;
    private final List<String> params = new ArrayList<String>();
    private final List<Class<?>> paramSpecClasses = new ArrayList();
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private Signature signature;

    private static DigestInfo createDigestInfo(byte[] input, boolean signature) {
        try {
            DigestInfo result = DigestInfo.getInstance((Object)input);
            if (result.getAlgorithmId().getParameters() == null) {
                result = new DigestInfo(new AlgorithmIdentifier(result.getAlgorithmId().getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE), result.getDigest());
            }
            return result;
        }
        catch (Exception e) {
            if (signature) {
                String digestName = JCEDelegateRawRSASignature.getJCEDigestAlgorithmName(input.length);
                return new DigestInfo(new AlgorithmIdentifier(new DefaultDigestAlgorithmIdentifierFinder().find(digestName).getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE), input);
            }
            throw new IllegalArgumentException("verification input as DigestInfo supported only", e);
        }
    }

    private static String getJCEDigestAlgorithmName(int length) {
        String jceDigestAlgorithmName = MAP_DIGEST_LENGTH_TO_JCE_NAME.get(length);
        if (jceDigestAlgorithmName == null) {
            throw new IllegalArgumentException("invalid digest length, no matching SHA-2 jce digest algorithm found: " + length);
        }
        return jceDigestAlgorithmName;
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        if (this.signature == null) {
            return null;
        }
        return this.signature.getParameter(param);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.signature == null) {
            return null;
        }
        return this.signature.getParameters();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("private key can not be null");
        }
        if (!KEY_ALGORITHM_RSA.equals(privateKey.getAlgorithm())) {
            throw new InvalidKeyException("private key must be a RSA key: " + privateKey.getAlgorithm());
        }
        this.initDelegate();
        this.privateKey = privateKey;
        if (this.privateKey instanceof OCFPrivateKey) {
            KeyPairGenerator kpg;
            if (!(((OCFPrivateKey)this.privateKey).getOCFCertificatInfo().getCertificateBag().getCertificate().getPublicKey() instanceof RSAPublicKey)) {
                throw new InvalidKeyException("OCF private key must represent a RSA private key (checked by related certificate with public key is a RSA public key)");
            }
            int keySize = ((RSAPublicKey)((OCFPrivateKey)this.privateKey).getOCFCertificatInfo().getCertificateBag().getCertificate().getPublicKey()).getModulus().bitLength();
            try {
                kpg = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("substitute RSA private key can not be generated", e);
            }
            kpg.initialize(keySize);
            this.signature.initSign(kpg.generateKeyPair().getPrivate(), new SecureRandom());
        } else {
            if (!(this.privateKey instanceof RSAPrivateKey)) {
                throw new InvalidKeyException("RSA private key is expected: " + this.privateKey);
            }
            this.signature.initSign(this.privateKey, random);
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!KEY_ALGORITHM_RSA.equals(publicKey.getAlgorithm())) {
            throw new InvalidKeyException("public key must be a RSA key: " + publicKey.getAlgorithm());
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("public key must be a RSAPublicKey");
        }
        this.initDelegate();
        this.signature.initVerify(publicKey);
        this.publicKey = publicKey;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (this.signature == null) {
            return;
        }
        LOG.debug("set parameter: {}", (Object)params);
        this.paramSpecClasses.add(params.getClass());
        this.signature.setParameter(params);
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        if (this.signature == null) {
            return;
        }
        LOG.debug("set parameter: {} = {}", (Object)param, value);
        this.params.add(param);
        this.signature.setParameter(param, value);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        LOG.debug("parameters used: {}", this.params);
        LOG.debug("algorithm parameter specs used: {}", this.paramSpecClasses);
        LOG.debug("parameters: {}", (Object)this.signature.getParameters());
        LOG.debug("message length to sign (digest length): {}", (Object)this.baos.toByteArray().length);
        DigestInfo di = JCEDelegateRawRSASignature.createDigestInfo(this.baos.toByteArray(), true);
        if (this.privateKey instanceof OCFPrivateKey) {
            try {
                String digestName = this.getJCEDigestAlgorithmName(di.getAlgorithmId());
                Signature s = Signature.getInstance(digestName + "hashedWithRSA", "OCF");
                s.initSign(this.privateKey);
                s.update(di.getDigest());
                return s.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new SignatureException(e);
            }
        }
        try {
            this.signature.update(di.getEncoded());
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
        return this.signature.sign();
    }

    @Override
    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        if (offset < 0 || offset > outbuf.length) {
            throw new SignatureException("invalid offset");
        }
        if (len <= 0) {
            throw new SignatureException("invalid signature length");
        }
        if (len + offset > outbuf.length) {
            throw new SignatureException("invalid signature, offset and length does not match signature value");
        }
        byte[] signatureValue = this.engineSign();
        if (signatureValue == null || signatureValue.length == 0) {
            throw new SignatureException("invalid signature value created");
        }
        if (signatureValue.length > len) {
            throw new SignatureException("invalid signature value, signature value has more bytes than expected");
        }
        System.arraycopy(signatureValue, 0, outbuf, offset, Math.min(signatureValue.length, len));
        return signatureValue.length;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.baos != null) {
            this.baos.write(b);
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (this.baos != null) {
            this.baos.write(b, off, len);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        if (this.baos != null) {
            this.baos.write(input.array(), input.arrayOffset(), input.limit());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.signature == null) {
            return false;
        }
        if (sigBytes == null) {
            throw new SignatureException("invalid signature value");
        }
        return this.engineVerify(sigBytes, 0, sigBytes.length);
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes, int offset, int length) throws SignatureException {
        if (this.signature == null) {
            return false;
        }
        if (sigBytes == null) {
            throw new SignatureException("invalid signature value");
        }
        if (offset < 0 || offset > sigBytes.length) {
            throw new SignatureException("invalid offset");
        }
        if (length <= 0) {
            throw new SignatureException("invalid signature length");
        }
        if (length + offset > sigBytes.length) {
            throw new SignatureException("invalid signature, offset and length does not match signature value");
        }
        this.signature.update(this.baos.toByteArray());
        boolean result = this.signature.verify(sigBytes, offset, length);
        if (!result) {
            result = this.fallbackValdidationForBCDigestAlgorithmDERNullFault(sigBytes, offset, length);
        }
        return result;
    }

    private boolean fallbackValdidationForBCDigestAlgorithmDERNullFault(byte[] signature, int offset, int length) {
        try {
            Cipher c = Cipher.getInstance("RSA/ECB/NoPadding", "BC");
            c.init(1, this.publicKey);
            byte[] decryptedSignature = c.doFinal(signature, offset, length);
            if (decryptedSignature[0] != 0) {
                return false;
            }
            int idxLastZero = -1;
            for (int i = 1; i < decryptedSignature.length; ++i) {
                if (decryptedSignature[i] != 0) continue;
                idxLastZero = i;
                break;
            }
            if (idxLastZero < 0) {
                return false;
            }
            decryptedSignature = ByteUtils.subArray((byte[])decryptedSignature, (int)(idxLastZero + 1));
            DigestInfo digestInfo = DigestInfo.getInstance((Object)decryptedSignature);
            DigestInfo expectedDigestInfo = JCEDelegateRawRSASignature.createDigestInfo(this.baos.toByteArray(), false);
            return digestInfo.getAlgorithmId().getAlgorithm().getId().equals(expectedDigestInfo.getAlgorithmId().getAlgorithm().getId()) && Arrays.equals(digestInfo.getDigest(), expectedDigestInfo.getDigest());
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getJCEDigestAlgorithmName(AlgorithmIdentifier algorithmId) {
        if (algorithmId == null) {
            throw new IllegalArgumentException("invalid algorithm id null");
        }
        ASN1ObjectIdentifier algorithm = algorithmId.getAlgorithm();
        if (algorithm == null) {
            throw new IllegalArgumentException("invalid algorithm null");
        }
        String algorithmOID = algorithm.getId();
        if (algorithmOID == null) {
            throw new IllegalArgumentException("invalid algorithm OID null");
        }
        if (MAP_OID_TO_JCE_NAME.containsKey(algorithmOID)) {
            return MAP_OID_TO_JCE_NAME.get(algorithmOID);
        }
        throw new IllegalArgumentException("algorithm OID failed to be mapped to a JCE name: " + algorithmOID);
    }

    private void initDelegate() throws InvalidKeyException {
        this.baos = new ByteArrayOutputStream();
        this.params.clear();
        this.paramSpecClasses.clear();
        this.privateKey = null;
        this.publicKey = null;
        try {
            this.signature = Signature.getInstance("NONEwithRSA", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new InvalidKeyException(e);
        }
    }

    static {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        tmp.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        tmp.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        tmp.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        tmp.put(NISTObjectIdentifiers.id_sha224.getId(), "SHA224");
        MAP_OID_TO_JCE_NAME = Collections.unmodifiableMap(tmp);
        LinkedHashMap<Integer, String> tmp2 = new LinkedHashMap<Integer, String>();
        tmp2.put(32, "SHA256");
        tmp2.put(64, "SHA512");
        tmp2.put(48, "SHA384");
        tmp2.put(24, "SHA224");
        MAP_DIGEST_LENGTH_TO_JCE_NAME = Collections.unmodifiableMap(tmp2);
    }
}

