/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.mcard.jce.sig.delegate;

import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.OCFSignature;
import de.bos_bremen.gov2.jca_provider.OCF_PSS_Signature;
import de.governikus.mcard.jce.sig.delegate.JCEDelegateDiffieHellmanKeyAgreement;
import de.governikus.mcard.jce.sig.delegate.JCEDelegateKeyStore;
import de.governikus.mcard.jce.sig.delegate.JCEDelegatePSSSignature;
import de.governikus.mcard.jce.sig.delegate.JCEDelegateRawRSASignature;
import de.governikus.mcard.jce.sig.delegate.JCEDelegateSignature;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEDelegateMCardBCProvider
extends Provider {
    private static final String PROVIDER_NAME_SUN_JCE = "SunJCE";
    public static final String KEYSTORE_TYPE = "DELEGATE";
    private static final Logger LOG = LoggerFactory.getLogger(JCEDelegateMCardBCProvider.class);
    public static final String PROVIDER_INFO = "Delegating MCard (signature creation) / BouncyCastleProvider (signature verification) - additional algorithms might be used as required for BouncyCastle JSSE Provider TLS authentication using smartcards";
    public static final String PROVIDER_NAME = "JDMCBC";
    public static final double PROVIDER_VERSION = 1.0;
    private static final long serialVersionUID = 1L;

    public static void copyEntryWithOneCrit(Provider sourceProvider, Provider targetProvider, String crit1) {
        if (crit1 == null || crit1.isEmpty()) {
            return;
        }
        sourceProvider.keySet().stream().filter(o -> o.toString().contains(crit1)).forEach((? super T o) -> targetProvider.put(o.toString(), sourceProvider.get(o.toString())));
    }

    public static void copyEntryWithOneCritKeyOrValue(Provider sourceProvider, Provider targetProvider, String crit1) {
        if (crit1 == null || crit1.isEmpty()) {
            return;
        }
        sourceProvider.keySet().stream().filter(o -> o.toString().contains(crit1) || sourceProvider.getProperty(o.toString(), "").contains(crit1)).forEach((? super T o) -> targetProvider.put(o.toString(), sourceProvider.get(o.toString())));
    }

    public static void copyEntryWithTwoCritAnd(Provider sourceProvider, Provider targetProvider, String crit1, String crit2) {
        if (crit1 == null || crit1.isEmpty()) {
            JCEDelegateMCardBCProvider.copyEntryWithOneCrit(sourceProvider, targetProvider, crit2);
            return;
        }
        if (crit2 == null || crit2.isEmpty()) {
            JCEDelegateMCardBCProvider.copyEntryWithOneCrit(sourceProvider, targetProvider, crit1);
            return;
        }
        sourceProvider.keySet().stream().filter(o -> o.toString().contains(crit1) && o.toString().contains(crit2)).forEach((? super T o) -> targetProvider.put(o.toString(), sourceProvider.get(o.toString())));
    }

    public static void copyEntryWithThreeCritOr(Provider sourceProvider, Provider targetProvider, String crit1, String crit2, String crit3) {
        sourceProvider.keySet().stream().filter(o -> crit1 != null && !crit1.isEmpty() && o.toString().contains(crit1) || crit2 != null && !crit2.isEmpty() && o.toString().contains(crit2) || crit3 != null && !crit3.isEmpty() && o.toString().contains(crit3)).forEach((? super T o) -> targetProvider.put(o.toString(), sourceProvider.get(o.toString())));
    }

    public JCEDelegateMCardBCProvider() {
        this(null, null);
    }

    public JCEDelegateMCardBCProvider(Map<?, ?> externalAdditionalEntries) {
        this(null, externalAdditionalEntries);
    }

    public JCEDelegateMCardBCProvider(Map<?, ?> externalInitialEntries, Map<?, ?> externalAdditionalEntries) {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        if (externalInitialEntries != null && !externalInitialEntries.isEmpty()) {
            super.putAll(externalInitialEntries);
        }
        this.put("Signature.NONEwithRSA", JCEDelegateRawRSASignature.class.getName());
        this.registerMCardOCFProviderAlgorithms();
        this.registerSunJCEAlgorithms();
        this.registerBCAlgorithms();
        this.registerAdditionals();
        if (externalAdditionalEntries != null && !externalAdditionalEntries.isEmpty()) {
            super.putAll(externalAdditionalEntries);
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            LOG.debug("skip overwriting existing key value not with null: {}", key);
            return super.get(key);
        }
        if (super.contains(key) && super.get(key) != null && !value.equals(super.get(key))) {
            LOG.debug("changing/overwriting existing key: {}, old value: {}, new value: {}", new Object[]{key, super.get(key), value});
        }
        LOG.debug("set key: {}, value: {}", key, value);
        return super.put(key, value);
    }

    private void registerSunJCEAlgorithms() {
        Provider provider = Security.getProvider(PROVIDER_NAME_SUN_JCE);
        if (provider == null) {
            throw new IllegalArgumentException("missing required registered provider: SunJCE");
        }
        for (String sunJceKey : new String[]{"DiffieHellman", "DH"}) {
            JCEDelegateMCardBCProvider.copyEntryWithOneCritKeyOrValue(provider, this, sunJceKey);
        }
        this.put("KeyPairGenerator.DiffieHellman", provider.getProperty("KeyPairGenerator.DH"));
        this.put("KeyFactory.DiffieHellman", provider.getProperty("KeyFactory.DH"));
    }

    private void registerBCAlgorithms() {
        Object provider;
        Object object = provider = Security.getProvider("BC") == null ? new BouncyCastleProvider() : Security.getProvider("BC");
        if (Security.getProvider("BC") == null) {
            LOG.warn("missing required registered  provider: BC");
        }
        for (String bcKey : new String[]{"MessageDigest", "SecureRandom", "Agreement", "AlgorithmParameters", "AES", "GCM", "CertificateFactory", "Mac", "NONEwithRSA"}) {
            JCEDelegateMCardBCProvider.copyEntryWithOneCrit((Provider)provider, this, bcKey);
        }
        JCEDelegateMCardBCProvider.copyEntryWithTwoCritAnd((Provider)provider, this, "KeyPairGenerator", "X25519");
        JCEDelegateMCardBCProvider.copyEntryWithTwoCritAnd((Provider)provider, this, "KeyFactory", "X25519");
        for (String bcKey : new String[]{"DiffieHellman", "DH"}) {
            JCEDelegateMCardBCProvider.copyEntryWithOneCritKeyOrValue((Provider)provider, this, bcKey);
        }
    }

    private void registerAdditionals() {
        this.put("KeyStore.DELEGATE", JCEDelegateKeyStore.class.getName());
        this.put("KeyAggreement.DiffieHellman", JCEDelegateDiffieHellmanKeyAgreement.class.getName());
    }

    private void registerMCardOCFProviderAlgorithms() {
        OCFProvider provider = new OCFProvider();
        provider.keySet().stream().filter(arg_0 -> JCEDelegateMCardBCProvider.lambda$registerMCardOCFProviderAlgorithms$8((Provider)provider, arg_0)).forEach(arg_0 -> this.lambda$registerMCardOCFProviderAlgorithms$9((Provider)provider, arg_0));
        provider.keySet().stream().filter(arg_0 -> JCEDelegateMCardBCProvider.lambda$registerMCardOCFProviderAlgorithms$10((Provider)provider, arg_0)).forEach(arg_0 -> this.lambda$registerMCardOCFProviderAlgorithms$11((Provider)provider, arg_0));
        for (String ocfKey : new String[]{"Agreement", "AlgorithmParameters", "AES", "GCM"}) {
            JCEDelegateMCardBCProvider.copyEntryWithOneCrit((Provider)provider, this, ocfKey);
        }
        JCEDelegateMCardBCProvider.copyEntryWithThreeCritOr((Provider)provider, this, "RSA/ECB/PKCS1Padding", "OCFDECRYPTRSA", "Cipher.RSA");
    }

    private /* synthetic */ void lambda$registerMCardOCFProviderAlgorithms$11(Provider provider, Object o) {
        this.put(o.toString(), provider.get(o.toString()).toString().replace(OCFPrivateKey.class.getName(), OCFPrivateKey.class.getName() + "|" + PrivateKey.class.getName() + "|" + PublicKey.class.getName()));
    }

    private static /* synthetic */ boolean lambda$registerMCardOCFProviderAlgorithms$10(Provider provider, Object o) {
        return o.toString().contains("Signature") && o.toString().contains("SupportedKeyClasses") && provider.get(o.toString()).toString().contains(OCFPrivateKey.class.getName());
    }

    private /* synthetic */ void lambda$registerMCardOCFProviderAlgorithms$9(Provider provider, Object o) {
        this.put(o.toString(), provider.get(o.toString()).toString().replace(OCFSignature.class.getName(), JCEDelegateSignature.class.getName()).replace(OCF_PSS_Signature.class.getName(), JCEDelegatePSSSignature.class.getName()));
    }

    private static /* synthetic */ boolean lambda$registerMCardOCFProviderAlgorithms$8(Provider provider, Object o) {
        return o.toString().contains("Signature") && (provider.get(o.toString()).toString().contains(OCFSignature.class.getName()) || provider.get(o.toString()).toString().contains(OCF_PSS_Signature.class.getName()));
    }
}

