/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.mcard.jce.sig.delegate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEDelegateKeyStore
extends KeyStoreSpi {
    private static final Logger LOG = LoggerFactory.getLogger(JCEDelegateKeyStore.class);
    private static String alias;
    private static KeyStore keyStore;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        LOG.debug("getKey: {}", (Object)alias);
        try {
            return this.checkInitialized().getKey(alias, password);
        }
        catch (Exception e) {
            UnrecoverableKeyException ex = new UnrecoverableKeyException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private KeyStore checkInitialized() {
        if (keyStore == null) {
            throw new IllegalStateException();
        }
        return keyStore;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.checkInitialized().getCertificateChain(alias);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        try {
            return this.checkInitialized().getCertificate(alias);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        try {
            return this.checkInitialized().getCreationDate(alias);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<String> engineAliases() {
        if (alias != null) {
            return new Enumeration<String>(){
                private boolean first = true;

                @Override
                public boolean hasMoreElements() {
                    return this.first;
                }

                @Override
                public String nextElement() {
                    this.first = false;
                    return alias;
                }
            };
        }
        try {
            return this.checkInitialized().aliases();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        try {
            return this.checkInitialized().containsAlias(alias);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int engineSize() {
        try {
            return this.checkInitialized().size();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        try {
            return this.checkInitialized().isKeyEntry(alias);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        try {
            return this.checkInitialized().isCertificateEntry(alias);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.checkInitialized().getCertificateAlias(cert);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public static KeyStore getKeyStore() {
        return keyStore;
    }

    public static void setKeyStore(KeyStore keyStore) {
        JCEDelegateKeyStore.keyStore = keyStore;
    }
}

