/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.mcard.jce.sig.delegate;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class JCEDelegateDiffieHellmanKeyAgreement
extends KeyAgreementSpi {
    public static final String ALGORITHM = "DiffieHellman";
    private static final String PROVIDER_DIFFIE_HELLMAN = "SunJCE";
    private KeyAgreement delegate;

    private void checkState() {
        if (this.delegate == null) {
            throw new IllegalStateException("not initializated properly");
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        this.checkState();
        return this.delegate.doPhase(key, lastPhase);
    }

    @Override
    protected byte[] engineGenerateSecret() {
        this.checkState();
        return this.delegate.generateSecret();
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws ShortBufferException {
        this.checkState();
        return this.delegate.generateSecret(sharedSecret, offset);
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        this.checkState();
        return this.delegate.generateSecret(algorithm);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initDelegate();
        this.delegate.init(key, params, random);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        this.initDelegate();
        this.delegate.init(key, random);
    }

    private void initDelegate() throws InvalidKeyException {
        try {
            this.delegate = KeyAgreement.getInstance(ALGORITHM, PROVIDER_DIFFIE_HELLMAN);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new InvalidKeyException(e.getMessage() + e.getMessage(), e);
        }
    }
}

