/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.mcard.jce.sig.delegate;

import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCEDelegateBaseSignature
extends SignatureSpi {
    private static final Logger LOG = LoggerFactory.getLogger(JCEDelegateBaseSignature.class);
    private Signature delegateSignature;
    private final String algorithm;

    protected JCEDelegateBaseSignature(String algorithm) {
        this.algorithm = algorithm;
        LOG.info("creating {} with {}", (Object)this.getClass().getName(), (Object)algorithm);
    }

    @Override
    protected final void engineSetParameter(String param, Object value) throws InvalidParameterException {
        LOG.info("engineSetParameter(String,Object): {}, {}", (Object)param, value);
        this.delegateSignature.setParameter(param, value);
    }

    @Override
    @Deprecated
    protected final Object engineGetParameter(String param) throws InvalidParameterException {
        LOG.info("engineGetParameter: {}", (Object)param);
        return this.delegateSignature.getParameter(param);
    }

    @Override
    protected final AlgorithmParameters engineGetParameters() {
        LOG.debug("engineGetParameters()");
        return this.delegateSignature.getParameters();
    }

    @Override
    protected final void engineUpdate(byte b) throws SignatureException {
        LOG.info("engineUpdate: {}", (Object)b);
        this.delegateSignature.update(b);
    }

    @Override
    protected final void engineUpdate(byte[] bytes, int offset, int length) throws SignatureException {
        LOG.info("engineUpdate: {}, {}, {}", new Object[]{bytes.length, offset, length});
        this.delegateSignature.update(bytes, offset, length);
    }

    @Override
    protected final byte[] engineSign() throws SignatureException {
        LOG.info("engineSign()");
        return this.delegateSignature.sign();
    }

    @Override
    protected final int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        LOG.info("engineSign: {}, {}, {}", new Object[]{outbuf, offset, len});
        return this.delegateSignature.sign(outbuf, offset, len);
    }

    @Override
    protected final boolean engineVerify(byte[] sigBytes) throws SignatureException {
        LOG.info("engineVerify: {}", (Object)sigBytes.length);
        boolean result = this.delegateSignature.verify(sigBytes);
        LOG.info("engineVerify: verification result: {}", (Object)result);
        return result;
    }

    @Override
    protected final boolean engineVerify(byte[] sigBytes, int offset, int length) throws SignatureException {
        LOG.info("engineVerify: {},{},{}", new Object[]{sigBytes.length, offset, length});
        boolean result = this.delegateSignature.verify(sigBytes, offset, length);
        LOG.info("engineVerify: verification result: {}", (Object)result);
        return result;
    }

    @Override
    protected final void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        LOG.info("engineInitVerify: {}", (Object)publicKey);
        if (this.delegateSignature != null) {
            throw new InvalidKeyException("Signature already initialized");
        }
        this.delegateSignature = JCEDelegateBaseSignature.createDelegate("BC", this.algorithm, "verification");
        this.delegateSignature.initVerify(publicKey);
    }

    @Override
    protected final void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        LOG.info("engineInitSign: {}", (Object)privateKey);
        if (this.delegateSignature != null) {
            throw new InvalidKeyException("Signature already initialized");
        }
        this.delegateSignature = JCEDelegateBaseSignature.createDelegate(privateKey instanceof OCFPrivateKey ? "OCF" : "BC", this.algorithm, "signature");
        this.delegateSignature.initSign(privateKey);
    }

    private static Signature createDelegate(String providerName, String algorithm, String description) throws InvalidKeyException {
        try {
            LOG.info("createDelegate for {}: {}, {}", new Object[]{description, algorithm, providerName});
            return Signature.getInstance(algorithm, providerName);
        }
        catch (Exception e) {
            LOG.error("failed creating signature delegate", (Throwable)e);
            throw new InvalidKeyException("initialization of " + providerName + " Signature for " + description + " with algorithm " + algorithm + " failed: " + e.getMessage(), e);
        }
    }
}

