/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxArray;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDict;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSName;

public class DSSPdfBoxUtil {
    static final String FIELD_PARENT = COSName.PARENT.getName();
    static final String FIELD_TYPE = COSName.TYPE.getName();
    static final String FIELD_SIG = COSName.SIG.getName();
    static final String FIELD_ANNOT = COSName.ANNOT.getName();
    static final String FIELD_FT = COSName.FT.getName();
    static final String FIELD_V = COSName.V.getName();
    static final String FIELD_RECT = COSName.RECT.getName();

    static boolean isSignatureDict(PdfBoxDict pdfDict) {
        return FIELD_SIG.equals(pdfDict.getNameValue(FIELD_FT)) && pdfDict.getAsDict(FIELD_V) != null;
    }

    static boolean isAnnotationDict(Object obj) {
        return FIELD_ANNOT.equals(((PdfBoxDict)obj).getNameValue(FIELD_TYPE));
    }

    static Long getIdOfParentSigDict(PdfBoxDict pdfBoxDict) {
        Object parentObj = pdfBoxDict.getObject(FIELD_PARENT);
        if (!(parentObj instanceof PdfBoxDict) || !DSSPdfBoxUtil.isSignatureDict((PdfBoxDict)parentObj)) {
            return null;
        }
        return pdfBoxDict.getObjectNumber(FIELD_PARENT);
    }

    public static List<Long> getSigObjIDsForAnnotChange(Object obj) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (obj == null) {
            return ids;
        }
        if (obj instanceof PdfBoxDict) {
            DSSPdfBoxUtil.processPdfBoxDict(obj, ids);
        } else if (obj instanceof PdfBoxArray) {
            DSSPdfBoxUtil.processPdfBoxArray(obj, ids);
        }
        return ids;
    }

    private static void processPdfBoxDict(Object obj, List<Long> ids) {
        Long parentId;
        PdfBoxDict pdfBoxDict = (PdfBoxDict)obj;
        if (DSSPdfBoxUtil.isAnnotationDict(pdfBoxDict) && (parentId = DSSPdfBoxUtil.getIdOfParentSigDict(pdfBoxDict)) != null && DSSPdfBoxUtil.hasZeroRectangle(pdfBoxDict)) {
            ids.add(parentId);
        }
    }

    static boolean hasZeroRectangle(PdfBoxDict pdfBoxDict) {
        PdfArray rectArray = pdfBoxDict.getAsArray(FIELD_RECT);
        return rectArray != null && rectArray.size() == 4 && rectArray.getNumber(0).intValue() == 0 && rectArray.getNumber(1).intValue() == 0 && rectArray.getNumber(2).intValue() == 0 && rectArray.getNumber(3).intValue() == 0;
    }

    private static void processPdfBoxArray(Object obj, List<Long> ids) {
        PdfBoxArray pdfBoxArray = (PdfBoxArray)obj;
        ArrayList<Long> tmpIDs = new ArrayList<Long>();
        for (int i = 0; i < pdfBoxArray.size(); ++i) {
            Long objectNumber;
            PdfBoxDict pdfBoxDict;
            PdfDict object = pdfBoxArray.getAsDict(i);
            if (!(object instanceof PdfBoxDict) || !DSSPdfBoxUtil.isAnnotationDict(pdfBoxDict = (PdfBoxDict)object) || !DSSPdfBoxUtil.hasZeroRectangle(pdfBoxDict)) continue;
            Long parentId = DSSPdfBoxUtil.getIdOfParentSigDict(pdfBoxDict);
            if (parentId != null) {
                tmpIDs.add(parentId);
                continue;
            }
            if (!DSSPdfBoxUtil.isSignatureDict(pdfBoxDict) || (objectNumber = pdfBoxArray.getObjectNumber(i)) == null) continue;
            tmpIDs.add(objectNumber);
        }
        if (pdfBoxArray.size() == tmpIDs.size()) {
            ids.addAll(tmpIDs);
        }
    }
}

