/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.debug_mode.mail;

import de.bos_bremen.debug_mode.mail.AttachmentZipper;
import de.bos_bremen.debug_mode.mail.MailAttachment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.jdic.desktop.Desktop;
import org.jdesktop.jdic.desktop.Message;

public class MailSender {
    private static final Logger LOG = LogManager.getLogger(MailSender.class);

    public void sendMail(boolean threaded, String subject, String mailBody, List<String> receiver, List<File> filesToSend, List<MailAttachment> ioToSend) {
        try {
            AttachmentZipper zipper = new AttachmentZipper();
            ArrayList<String> attachments = new ArrayList<String>();
            File attachmentFile = zipper.zipLogFilesTo(filesToSend, ioToSend, null);
            attachments.add(attachmentFile.getAbsolutePath());
            Message message = new Message();
            message.setToAddrs(receiver);
            message.setSubject(subject);
            message.setBody(mailBody);
            message.setAttachments(attachments);
            SendThread st = new SendThread(message);
            if (threaded) {
                st.start();
            } else {
                st.send();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public static InputStream getSystemPropertiesAsInputStream() {
        Properties lProps = System.getProperties();
        ArrayList<String> sortlist = Collections.list(lProps.propertyNames());
        Collections.sort(sortlist);
        StringBuilder stringBuffer = new StringBuilder();
        for (String aKey : sortlist) {
            String aValue = System.getProperty(aKey);
            stringBuffer.append(aKey).append(" = ").append(aValue).append("\n");
        }
        return new ByteArrayInputStream(stringBuffer.toString().getBytes(StandardCharsets.UTF_8));
    }

    private class SendThread
    extends Thread {
        private Message message;

        public SendThread(Message m) {
            this.message = m;
        }

        @Override
        public void run() {
            this.send();
        }

        protected void send() {
            try {
                Desktop.mail((Message)this.message);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
    }
}

