/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.debug_mode.mail;

import de.bos_bremen.debug_mode.mail.MailAttachment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttachmentZipper {
    private static final Logger LOG = LogManager.getLogger(AttachmentZipper.class);
    private static final String FILENAME = "debug_info";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipEntry(ZipOutputStream zos, String entryName, InputStream is) throws IOException {
        LOG.debug("entry : {}", (Object)entryName);
        ZipEntry ze = new ZipEntry(entryName);
        zos.putNextEntry(ze);
        try {
            byte[] buffer = new byte[4096];
            int readBytes = is.read(buffer);
            while (readBytes != -1) {
                zos.write(buffer, 0, readBytes);
                readBytes = is.read(buffer);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            zos.closeEntry();
        }
    }

    public File zipLogFilesTo(List<File> fileAttachments, List<MailAttachment> ioToSend, File logFile) throws IOException {
        if (fileAttachments == null && ioToSend == null) {
            LOG.error("zipLogFilesTo was called with null parameters for both fileAttachments and ioToSend; the zip file cannot be created...");
            return null;
        }
        if (logFile == null) {
            logFile = File.createTempFile(FILENAME, ".zip");
            LOG.info("temporary zip file: {}", (Object)logFile.getAbsolutePath());
        }
        try (FileOutputStream os = new FileOutputStream(logFile);
             ZipOutputStream zos = new ZipOutputStream(os);){
            zos.setLevel(8);
            if (fileAttachments != null) {
                for (File file : fileAttachments) {
                    LOG.info(file.getName());
                    this.zipEntry(zos, file.getName(), new FileInputStream(file));
                }
            }
            if (ioToSend != null) {
                for (MailAttachment att : ioToSend) {
                    LOG.info(att.getName());
                    this.zipEntry(zos, att.getName(), att.getInputStream());
                }
            }
        }
        LOG.debug("log zip : {}", (Object)logFile.getAbsolutePath());
        return logFile;
    }
}

