/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.debug_mode;

import de.bos_bremen.debug_mode.DebugLevel;
import de.bos_bremen.debug_mode.exception.LogFileException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class DebugMode {
    private static final Logger LOG = LogManager.getLogger(DebugMode.class);
    private static final Layout<String> LAYOUT = PatternLayout.newBuilder().withPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} %-5p %-100l : %m%n").build();
    private static final String SIGNER_APPENDER = "SignerFile";
    private static DebugMode theInstance;
    private DebugLevel debugLevel;
    private File logFile;
    private static final String TEMP_FILE_PREFIX = "debug_mode";

    private DebugMode() {
        this.cleanUp();
    }

    public static synchronized DebugMode getInstance() {
        if (theInstance == null) {
            theInstance = new DebugMode();
        }
        return theInstance;
    }

    public DebugLevel getDebugLevel() {
        return this.debugLevel;
    }

    private void cleanUp() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        LOG.info("deleting old temp files in {}", (Object)tempDir);
        String[] files = tempDir.list();
        for (int i = 0; i < files.length; ++i) {
            File debugFile;
            if (!files[i].startsWith(TEMP_FILE_PREFIX) || !(debugFile = new File(tempDir, files[i])).canWrite()) continue;
            try {
                Files.delete(debugFile.toPath());
            }
            catch (IOException e) {
                LOG.warn("could not delete debug file: {}", (Object)debugFile);
            }
            LOG.debug("deleted: {}", (Object)debugFile.getAbsolutePath());
        }
        LOG.info("deleting old temp files...done");
    }

    public void setDebugLevelAndLogFile(DebugLevel debugLevel, File logFile) throws LogFileException {
        if (debugLevel == null) {
            throw new IllegalArgumentException("debugLevel must not be null");
        }
        if (debugLevel == DebugLevel.none) {
            this.setLogFile(null);
        } else {
            this.setLogFile(logFile);
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    private void setLogFile(File logFile) throws LogFileException {
        this.testLogFile(logFile);
        this.logFile = logFile;
        this.setAppenderFile(logFile);
    }

    private void testLogFile(File logFile) throws LogFileException {
        LOG.debug("testing logFile ... : {}", (Object)logFile);
        if (logFile == null) {
            return;
        }
        if (logFile.exists() && !logFile.canWrite()) {
            throw new LogFileException("The logFile " + logFile + " cannot be written to.");
        }
        LOG.debug("logFile is ok");
    }

    private void setAppenderFile(File logFile) {
        LOG.info("setting logFile in the appender to {}", (Object)logFile);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ctx.reconfigure();
        Configuration config = ctx.getConfiguration();
        if (logFile == null) {
            Appender console = config.getAppender(SIGNER_APPENDER);
            if (console != null) {
                console.stop();
            }
            return;
        }
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName(SIGNER_APPENDER)).withAppend(false).setImmediateFlush(false)).setIgnoreExceptions(false)).setBufferedIo(false)).withFileName(logFile.getAbsolutePath()).setLayout(LAYOUT)).withCreateOnDemand(true).build();
        appender.start();
        config.addAppender((Appender)appender);
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.addAppender((Appender)appender, Level.DEBUG, null);
        ctx.updateLoggers();
    }
}

