/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.NativeContextDispatch;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.time.Duration;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class NativeContextDispatchGen {
    NativeContextDispatchGen() {
    }

    static NativeContextDispatch createHSToNative(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        return new StartPoint(enterprisePolyglotImpl);
    }

    static NativeContextDispatch createNativeToNative(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        return new StartPoint(enterprisePolyglotImpl);
    }

    static NativeContextDispatch create(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        if (ImageInfo.inImageCode()) {
            return NativeContextDispatchGen.createNativeToNative(enterprisePolyglotImpl);
        }
        return NativeContextDispatchGen.createHSToNative(enterprisePolyglotImpl);
    }

    private static final class StartPoint
    extends NativeContextDispatch {
        private static final BinaryMarshaller<Duration> durationMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(EnterprisePolyglotImpl enterprisePolyglotImpl) {
            super(enterprisePolyglotImpl);
        }

        @Override
        void closeImpl(Object object, boolean bl) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.closeImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), bl);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        void explicitEnterImpl(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.explicitEnterImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        void explicitLeaveImpl(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.explicitLeaveImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        Object getBindingsImpl(Object object, String string) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getBindingsImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), string);
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object2 = objectWithValueReceiverMarshaller.read(binaryInput);
                return object2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Object getPolyglotBindings(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getPolyglotBindings0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object2 = objectWithValueReceiverMarshaller.read(binaryInput);
                return object2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        boolean initializeLanguageImpl(Object object, String string) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                boolean bl = StartPoint.initializeLanguageImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), string);
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public boolean interrupt(Object object, Duration duration) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                int n2 = durationMarshaller.inferSize((Object)duration);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                durationMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)duration);
                boolean bl = StartPoint.interrupt0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), byteArrayBinaryOutput.getArray());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        void onContextCollectedImpl(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.onContextCollectedImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public void resetLimits(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.resetLimits0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public void safepoint(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.safepoint0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void closeImpl0(long var0, long var2, boolean var4);

        private static native void explicitEnterImpl0(long var0, long var2);

        private static native void explicitLeaveImpl0(long var0, long var2);

        private static native byte[] getBindingsImpl0(long var0, long var2, String var4);

        private static native byte[] getPolyglotBindings0(long var0, long var2);

        private static native boolean initializeLanguageImpl0(long var0, long var2, String var4);

        private static native boolean interrupt0(long var0, long var2, byte[] var4);

        private static native void onContextCollectedImpl0(long var0, long var2);

        private static native void resetLimits0(long var0, long var2);

        private static native void safepoint0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            durationMarshaller = jNIConfig.lookupMarshaller(Duration.class, new Class[0]);
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ValueReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Duration> durationMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_closeImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void closeImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, boolean bl) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::closeImpl", (JNI.JNIEnv)jNIEnv);){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.close(object2, bl);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_explicitEnterImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void explicitEnterImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::explicitEnterImpl", (JNI.JNIEnv)jNIEnv);){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.explicitEnter(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_explicitLeaveImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void explicitLeaveImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::explicitLeaveImpl", (JNI.JNIEnv)jNIEnv);){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.explicitLeave(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_getBindingsImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getBindingsImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::getBindingsImpl", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                Object object3 = abstractContextDispatch.getBindings(object2, JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString));
                int n2 = objectWithValueReceiverMarshaller.inferSize(object3);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    objectWithValueReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object3);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_getPolyglotBindings0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getPolyglotBindings(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::getPolyglotBindings", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                Object object3 = abstractContextDispatch.getPolyglotBindings(object2);
                int n2 = objectWithValueReceiverMarshaller.inferSize(object3);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    objectWithValueReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object3);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_initializeLanguageImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean initializeLanguageImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            boolean bl;
            block8: {
                JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::initializeLanguageImpl", (JNI.JNIEnv)jNIEnv);
                try {
                    boolean bl2;
                    Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                    AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                    Object object2 = NativeContextDispatch.resolveReceiver(object);
                    bl = bl2 = abstractContextDispatch.initializeLanguage(object2, JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString));
                    if (jNIMethodScope == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (jNIMethodScope != null) {
                            try {
                                jNIMethodScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                        return false;
                    }
                }
                jNIMethodScope.close();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_interrupt0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean interrupt(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::interrupt", (JNI.JNIEnv)jNIEnv);){
                boolean bl;
                block12: {
                    Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                    AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                    Object object2 = NativeContextDispatch.resolveReceiver(object);
                    CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                    int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                    CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                    try {
                        boolean bl2;
                        JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                        BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                        Duration duration = (Duration)durationMarshaller.read(binaryInput);
                        bl = bl2 = abstractContextDispatch.interrupt(object2, duration);
                        if (cCharPointer2 == cCharPointer) break block12;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free((PointerBase)cCharPointer2);
                        }
                        throw throwable;
                    }
                    UnmanagedMemory.free((PointerBase)cCharPointer2);
                }
                return bl;
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                return false;
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_onContextCollectedImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void onContextCollectedImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::onContextCollectedImpl", (JNI.JNIEnv)jNIEnv);){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.onContextCollected(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_resetLimits0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void resetLimits(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::resetLimits", (JNI.JNIEnv)jNIEnv);){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.resetLimits(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_safepoint0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void safepoint(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeContextDispatchGen::safepoint", (JNI.JNIEnv)jNIEnv);){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.safepoint(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            durationMarshaller = jNIConfig.lookupMarshaller(Duration.class, new Class[0]);
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ValueReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

