/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import com.oracle.truffle.polyglot.enterprise.NativeObjectReferences;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateServices;
import java.lang.ref.Reference;
import org.graalvm.collections.Pair;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.polyglot.Context;

final class NativeContext
extends NativeObject {
    private final Context localContext;
    private final NativeObjectReferences guestToHostReceiver;
    private final PolyglotIsolateServices polyglotIsolateServices;
    private final IsolateSourceCache sourceCache;
    int registrationRequired;
    private volatile Reference<Context> weakAPI;

    NativeContext(NativeIsolate nativeIsolate, long l2, Context context, NativeObjectReferences nativeObjectReferences, PolyglotIsolateServices polyglotIsolateServices) {
        super(nativeIsolate, l2);
        this.localContext = context;
        this.guestToHostReceiver = nativeObjectReferences;
        this.polyglotIsolateServices = polyglotIsolateServices;
        this.sourceCache = polyglotIsolateServices.getSourceCache();
        nativeObjectReferences.setAPI(this);
    }

    void setContextAPIReference(Reference<Context> reference) {
        this.weakAPI = reference;
    }

    Reference<Context> getContextAPIReference() {
        return this.weakAPI;
    }

    Context getContextAPI() {
        Context context = this.weakAPI.get();
        if (context == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"API object must not be garbage collected when context implementation is in use.");
        }
        return context;
    }

    Context getContextAPIOrNull() {
        return this.weakAPI.get();
    }

    Context getLocalContext() {
        return this.localContext;
    }

    NativeObjectReferences getGuestToHostReceiver() {
        return this.guestToHostReceiver;
    }

    PolyglotIsolateServices getPolyglotIsolateServices() {
        return this.polyglotIsolateServices;
    }

    IsolateSourceCache getSourceCache() {
        return this.sourceCache;
    }

    Pair<Long, Long> getKey() {
        return Pair.create((Object)this.getIsolate().getIsolateId(), (Object)this.getHandle());
    }
}

