/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.validate.AlgorithmCatalog;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.FailureInterpretation;
import de.governikus.csl.uom.validate.KeyUsageCheckSettings;
import de.governikus.csl.uom.validate.PathValidationMethod;
import de.governikus.csl.uom.validate.RevocationFreshnessCheckSettings;
import de.governikus.csl.uom.validate.RevocationValueValidationDepth;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.TrustAnchorPolicy;
import de.governikus.csl.validation.policy.ValidatePolicyDefaults;

public class ValidatePolicyDefaultsFacade
implements ValidatePolicy {
    private ValidatePolicy policy;

    public ValidatePolicyDefaultsFacade(ValidatePolicy policy) {
        this.policy = policy;
    }

    public PolicyInformation getPolicyInformation() {
        return this.policy.getPolicyInformation();
    }

    public Boolean isAdesBaselineConformityRequired() {
        Boolean value = this.policy.isAdesBaselineConformityRequired();
        return value == null ? ValidatePolicyDefaults.ADES_BASELINE_CONFORMITY_REQUIRED : value;
    }

    public Boolean isENConformity() {
        Boolean value = this.policy.isENConformity();
        return value == null ? ValidatePolicyDefaults.EN_CONFORMITY : value;
    }

    public RevocationFreshnessCheckSettings getRevocationFreshnessCheckSettings() {
        RevocationFreshnessCheckSettings value = this.policy.getRevocationFreshnessCheckSettings();
        return value == null ? ValidatePolicyDefaults.REVOCATION_FRESHNESSCHECK_SETTINGS : value;
    }

    public PathValidationMethod getPathValidationMethod() {
        PathValidationMethod value = this.policy.getPathValidationMethod();
        return value == null ? ValidatePolicyDefaults.PATH_VALIDATION_METHOD : value;
    }

    public RevocationValueValidationDepth getRevocationValueValidationDepth() {
        RevocationValueValidationDepth value = this.policy.getRevocationValueValidationDepth();
        return value == null ? ValidatePolicyDefaults.REVOCATION_VALUE_VALIDATION_DEPTH : value;
    }

    public Long getMaxRevocationValueAge() {
        Long value = this.policy.getMaxRevocationValueAge();
        return value == null ? ValidatePolicyDefaults.MAX_REVOCATION_VALUE_AGE : value;
    }

    public Boolean isClaimedSigningTimeCheckRequired() {
        Boolean value = this.policy.isClaimedSigningTimeCheckRequired();
        return value == null ? ValidatePolicyDefaults.CLAIMED_SIGNING_TIME_CHECK_REQUIRED : value;
    }

    public Boolean isClaimedSigningTimeInFutureAllowed() {
        Boolean value = this.policy.isClaimedSigningTimeInFutureAllowed();
        return value == null ? ValidatePolicyDefaults.CLAIMED_SIGNING_TIME_IN_FUTURE_ALLOWED : value;
    }

    public KeyUsageCheckSettings getKeyUsageCheckSettings() {
        KeyUsageCheckSettings value = this.policy.getKeyUsageCheckSettings();
        return value == null ? ValidatePolicyDefaults.getKeyUsageCheckSettings() : value;
    }

    public Boolean isAlgorithmValidityCheckAtValidationTimeRequired() {
        Boolean value = this.policy.isAlgorithmValidityCheckAtValidationTimeRequired();
        return value == null ? ValidatePolicyDefaults.ALGORITHM_VALIDITY_CHECK_AT_VALIDATION_TIME_REQUIRED : value;
    }

    public Boolean isAlgorithmValidityCheckAtBestPOERequired() {
        Boolean value = this.policy.isAlgorithmValidityCheckAtBestPOERequired();
        return value == null ? ValidatePolicyDefaults.ALGORITHM_VALIDITY_CHECK_AT_BEST_POE_REQUIRED : value;
    }

    public Boolean isAlgorithmValidityCheckAtClaimedSigningTimeRequired() {
        Boolean value = this.policy.isAlgorithmValidityCheckAtClaimedSigningTimeRequired();
        return value == null ? ValidatePolicyDefaults.ALGORITHM_VALIDITY_CHECK_AT_CLAIMED_SIGNING_TIME_REQUIRED : value;
    }

    public Boolean isRevocationValueTrustRequired() {
        Boolean value = this.policy.isRevocationValueTrustRequired();
        return value == null ? ValidatePolicyDefaults.REVOCATION_VALUE_TRUST_REQUIRED : value;
    }

    public Boolean isCertHashInOCSPRequired() {
        Boolean value = this.policy.isCertHashInOCSPRequired();
        return value == null ? ValidatePolicyDefaults.CERT_HASH_IN_OCSP_REQUIRED : value;
    }

    public Long getMaxOCSPCacheDurationEE() {
        Long value = this.policy.getMaxOCSPCacheDurationEE();
        return value == null ? ValidatePolicyDefaults.MAX_OCSP_CACHE_DURATION_EE : value;
    }

    public Long getMaxOCSPCacheDurationCA() {
        Long value = this.policy.getMaxOCSPCacheDurationCA();
        return value == null ? ValidatePolicyDefaults.MAX_OCSP_CACHE_DURATION_CA : value;
    }

    public TrustAnchorPolicy getTrustAnchorUsagePolicy() {
        TrustAnchorPolicy value = this.policy.getTrustAnchorUsagePolicy();
        return value == null ? ValidatePolicyDefaults.TRUST_ANCHOR_USAGE_POLICY : value;
    }

    public Boolean isOnlyOCSPAllowed() {
        Boolean value = this.policy.isOnlyOCSPAllowed();
        return value == null ? ValidatePolicyDefaults.ONLY_OCSP_ALLOWED : value;
    }

    public DateType getMinimalRequiredPOELevel() {
        DateType value = this.policy.getMinimalRequiredPOELevel();
        return value == null ? ValidatePolicyDefaults.MINIMAL_REQUIRED_POE_LEVEL : value;
    }

    public DateType getMinimalRequiredAlgPOELevel() {
        DateType value = this.policy.getMinimalRequiredAlgPOELevel();
        return value == null ? ValidatePolicyDefaults.MINIMAL_REQUIRED_ALG_POE_LEVEL : value;
    }

    public FailureInterpretation getRevokedCertificateInterpretation() {
        FailureInterpretation value = this.policy.getRevokedCertificateInterpretation();
        return value == null ? ValidatePolicyDefaults.REVOKED_CERTIFICATE_INTERPRETATION : value;
    }

    public Boolean isSelfSignedCertificateRevocationCheckRequired() {
        Boolean value = this.policy.isSelfSignedCertificateRevocationCheckRequired();
        return value == null ? ValidatePolicyDefaults.SELFSIGNED_CERTIFICATE_REVOCATION_CHECK_REQUIRED : value;
    }

    public Boolean isInvalidateOldAlgorithms() {
        Boolean value = this.policy.isInvalidateOldAlgorithms();
        return value == null ? ValidatePolicyDefaults.INVALIDATE_OLD_ALGORITHMS : value;
    }

    public Boolean isTrustCenterGuidelineIgnored() {
        Boolean value = this.policy.isTrustCenterGuidelineIgnored();
        return value == null ? ValidatePolicyDefaults.TRUSTCENTER_GUIDELINE_IGNORED : value;
    }

    public AlgorithmCatalog getAlgorithmCatalog() {
        AlgorithmCatalog value = this.policy.getAlgorithmCatalog();
        return value == null ? ValidatePolicyDefaults.ALGORITHM_CATALOG : value;
    }

    public Boolean isCertificateValidationDisabled() {
        Boolean value = this.policy.isCertificateValidationDisabled();
        return value == null ? ValidatePolicyDefaults.CERTIFICATE_VALIDATION_DISABLED : value;
    }

    public Boolean isRevocationValueTrustCheckRequired() {
        Boolean value = this.policy.isRevocationValueTrustCheckRequired();
        return value == null ? ValidatePolicyDefaults.REVOCATION_VALUE_TRUST_CHECK_REQUIRED : value;
    }

    public ValidatePolicyDefaultsFacade clone() {
        return new ValidatePolicyDefaultsFacade(this.policy);
    }

    public Boolean isRevocationRequestRequiredForShortTermCertificate() {
        Boolean value = this.policy.isRevocationRequestRequiredForShortTermCertificate();
        return value == null ? ValidatePolicyDefaults.REVOCATION_REQUEST_REQUIRED_FOR_SHORT_TERM_CERTIFICATE : value;
    }
}

