/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.uom.validate.AlgorithmCatalog;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.FailureInterpretation;
import de.governikus.csl.uom.validate.PathValidationMethod;
import de.governikus.csl.uom.validate.RevocationFreshnessCheckSettings;
import de.governikus.csl.uom.validate.RevocationValueValidationDepth;
import de.governikus.csl.uom.validate.commons.TrustAnchorPolicy;
import de.governikus.csl.validation.policy.KeyUsageCheckType;
import de.governikus.csl.validation.policy.ValidationPolicyType;

public class ValidatePolicyDefaults {
    public static final Boolean ADES_BASELINE_CONFORMITY_REQUIRED = Boolean.FALSE;
    public static final AlgorithmCatalog ALGORITHM_CATALOG = AlgorithmCatalog.getDefault();
    public static final Boolean ALGORITHM_VALIDITY_CHECK_AT_BEST_POE_REQUIRED = Boolean.TRUE;
    public static final Boolean ALGORITHM_VALIDITY_CHECK_AT_CLAIMED_SIGNING_TIME_REQUIRED = Boolean.FALSE;
    public static final Boolean ALGORITHM_VALIDITY_CHECK_AT_VALIDATION_TIME_REQUIRED = Boolean.FALSE;
    public static final Boolean CERT_HASH_IN_OCSP_REQUIRED = Boolean.FALSE;
    public static final Boolean CERTIFICATE_VALIDATION_DISABLED = Boolean.FALSE;
    public static final Boolean CLAIMED_SIGNING_TIME_CHECK_REQUIRED = Boolean.TRUE;
    public static final Boolean CLAIMED_SIGNING_TIME_IN_FUTURE_ALLOWED = Boolean.FALSE;
    public static final Boolean EN_CONFORMITY = Boolean.FALSE;
    public static final Boolean INVALIDATE_OLD_ALGORITHMS = Boolean.FALSE;
    public static final Long MAX_OCSP_CACHE_DURATION_CA = new Long(60000L);
    public static final Long MAX_OCSP_CACHE_DURATION_EE = new Long(60000L);
    public static final Long MAX_REVOCATION_VALUE_AGE = new Long(60000L);
    public static final DateType MINIMAL_REQUIRED_ALG_POE_LEVEL = DateType.QTST;
    public static final DateType MINIMAL_REQUIRED_POE_LEVEL = DateType.CLAIMED_SIGNING_TIME;
    public static final Boolean ONLY_OCSP_ALLOWED = Boolean.TRUE;
    public static final PathValidationMethod PATH_VALIDATION_METHOD = PathValidationMethod.STRAIGHT;
    public static final RevocationFreshnessCheckSettings REVOCATION_FRESHNESSCHECK_SETTINGS = RevocationFreshnessCheckSettings.CHECK_AT_POE;
    public static final Boolean REVOCATION_VALUE_TRUST_CHECK_REQUIRED = Boolean.TRUE;
    public static final Boolean REVOCATION_VALUE_TRUST_REQUIRED = Boolean.TRUE;
    public static final Boolean REVOCATION_REQUEST_REQUIRED_FOR_SHORT_TERM_CERTIFICATE = Boolean.FALSE;
    public static final RevocationValueValidationDepth REVOCATION_VALUE_VALIDATION_DEPTH = RevocationValueValidationDepth.NORMAL;
    public static final FailureInterpretation REVOKED_CERTIFICATE_INTERPRETATION = FailureInterpretation.INVALIDATE_RESULT;
    public static final Boolean SELFSIGNED_CERTIFICATE_REVOCATION_CHECK_REQUIRED = Boolean.FALSE;
    public static final TrustAnchorPolicy TRUST_ANCHOR_USAGE_POLICY = TrustAnchorPolicy.ONLY_CERT_OCSP_CRL_TST_EUMS;
    public static final Boolean TRUSTCENTER_GUIDELINE_IGNORED = Boolean.FALSE;

    public static KeyUsageCheckType getKeyUsageCheckSettings() {
        KeyUsageCheckType keyUsageCheckType = new KeyUsageCheckType();
        keyUsageCheckType.setCheckCACertificateUsage(true);
        keyUsageCheckType.setCheckEndEntityCertificateUsage(true);
        keyUsageCheckType.setCheckRevocationValueCertificateUsage(true);
        keyUsageCheckType.setCheckTSPCertificateUsage(true);
        return keyUsageCheckType;
    }

    public static ValidationPolicyType getDefaultPolicy() {
        ValidationPolicyType policy = new ValidationPolicyType();
        policy.setAlgorithmCatalog(ALGORITHM_CATALOG);
        policy.setRevocationValueValidationDepth(REVOCATION_VALUE_VALIDATION_DEPTH);
        policy.setKeyUsageCheckSettings(ValidatePolicyDefaults.getKeyUsageCheckSettings());
        policy.setMaxOCSPCacheDurationCA(MAX_OCSP_CACHE_DURATION_CA);
        policy.setMaxOCSPCacheDurationEE(MAX_OCSP_CACHE_DURATION_EE);
        policy.setMaxRevocationValueAge(MAX_REVOCATION_VALUE_AGE);
        policy.setMinimalRequiredPOELevel(MINIMAL_REQUIRED_POE_LEVEL);
        policy.setAlgorithmValidityCheckAtBestPOERequired(ALGORITHM_VALIDITY_CHECK_AT_BEST_POE_REQUIRED);
        policy.setAdesBaselineConformityRequired(ADES_BASELINE_CONFORMITY_REQUIRED);
        policy.setRevocationValueTrustCheckRequired(REVOCATION_VALUE_TRUST_CHECK_REQUIRED);
        policy.setTrustAnchorUsagePolicy(TRUST_ANCHOR_USAGE_POLICY);
        policy.setRevokedCertificateInterpretation(REVOKED_CERTIFICATE_INTERPRETATION);
        policy.setPathValidationMethod(PATH_VALIDATION_METHOD);
        policy.setMinimalRequiredAlgPOELevel(MINIMAL_REQUIRED_ALG_POE_LEVEL);
        policy.setAlgorithmValidityCheckAtClaimedSigningTimeRequired(ALGORITHM_VALIDITY_CHECK_AT_CLAIMED_SIGNING_TIME_REQUIRED);
        policy.setCertHashInOCSPRequired(CERT_HASH_IN_OCSP_REQUIRED);
        policy.setRevocationValueTrustRequired(REVOCATION_VALUE_TRUST_REQUIRED);
        policy.setAlgorithmValidityCheckAtValidationTimeRequired(ALGORITHM_VALIDITY_CHECK_AT_VALIDATION_TIME_REQUIRED);
        policy.setClaimedSigningTimeCheckRequired(CLAIMED_SIGNING_TIME_CHECK_REQUIRED);
        policy.setClaimedSigningTimeInFutureAllowed(CLAIMED_SIGNING_TIME_IN_FUTURE_ALLOWED);
        policy.setENConformity(EN_CONFORMITY);
        policy.setInvalidateOldAlgorithms(INVALIDATE_OLD_ALGORITHMS);
        policy.setOnlyOCSPAllowed(ONLY_OCSP_ALLOWED);
        policy.setRevocationFreshnessCheckSettings(REVOCATION_FRESHNESSCHECK_SETTINGS);
        policy.setSelfSignedCertificateRevocationCheckRequired(SELFSIGNED_CERTIFICATE_REVOCATION_CHECK_REQUIRED);
        policy.setTrustCenterGuidelineIgnored(TRUSTCENTER_GUIDELINE_IGNORED);
        policy.setCertificateValidationDisabled(CERTIFICATE_VALIDATION_DISABLED);
        policy.setRevocationRequestRequiredForShortTermCertificate(REVOCATION_REQUEST_REQUIRED_FOR_SHORT_TERM_CERTIFICATE);
        return policy;
    }
}

