/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.validation.policy.MultiLanguageStringType;
import de.governikus.csl.validation.policy.PolicyInformationType;
import de.governikus.csl.validation.policy.ValidatePolicyDefaults;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.validation.policy.ValidityIntervallType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;

public class PolicyNormalizer {
    public void normalizePolicy(ValidationPolicyType policy) {
        PolicyNormalizer.normalizePolicy(policy, ValidatePolicyDefaults.getDefaultPolicy());
    }

    public static void normalizePolicy(ValidationPolicyType policy, ValidationPolicyType base) {
        if (policy.getAlgorithmCatalog() == null) {
            policy.setAlgorithmCatalog(base.getAlgorithmCatalog());
        }
        if (policy.getRevocationValueValidationDepth() == null) {
            policy.setRevocationValueValidationDepth(base.getRevocationValueValidationDepth());
        }
        if (policy.getKeyUsageCheckSettings() == null) {
            policy.setKeyUsageCheckSettings(base.getKeyUsageCheckSettings());
        }
        if (policy.getMaxOCSPCacheDurationCA() == null) {
            policy.setMaxOCSPCacheDurationCA(base.getMaxOCSPCacheDurationCA());
        }
        if (policy.getMaxOCSPCacheDurationEE() == null) {
            policy.setMaxOCSPCacheDurationEE(base.getMaxOCSPCacheDurationEE());
        }
        if (policy.getMaxRevocationValueAge() == null) {
            policy.setMaxRevocationValueAge(base.getMaxRevocationValueAge());
        }
        if (policy.getMinimalRequiredPOELevel() == null) {
            policy.setMinimalRequiredPOELevel(base.getMinimalRequiredPOELevel());
        }
        if (policy.getMinimalRequiredAlgPOELevel() == null) {
            policy.setMinimalRequiredAlgPOELevel(base.getMinimalRequiredAlgPOELevel());
        }
        if (policy.getPathValidationMethod() == null) {
            policy.setPathValidationMethod(base.getPathValidationMethod());
        }
        if (policy.getRevokedCertificateInterpretation() == null) {
            policy.setRevokedCertificateInterpretation(base.getRevokedCertificateInterpretation());
        }
        if (policy.getTrustAnchorUsagePolicy() == null) {
            policy.setTrustAnchorUsagePolicy(base.getTrustAnchorUsagePolicy());
        }
        if (policy.isRevocationValueTrustCheckRequired() == null) {
            policy.setRevocationValueTrustCheckRequired(base.isRevocationValueTrustCheckRequired());
        }
        if (policy.isAdesBaselineConformityRequired() == null) {
            policy.setAdesBaselineConformityRequired(base.isAdesBaselineConformityRequired());
        }
        if (policy.isAlgorithmValidityCheckAtBestPOERequired() == null) {
            policy.setAlgorithmValidityCheckAtBestPOERequired(base.isAlgorithmValidityCheckAtBestPOERequired());
        }
        if (policy.isAlgorithmValidityCheckAtClaimedSigningTimeRequired() == null) {
            policy.setAlgorithmValidityCheckAtClaimedSigningTimeRequired(base.isAlgorithmValidityCheckAtClaimedSigningTimeRequired());
        }
        if (policy.isAlgorithmValidityCheckAtValidationTimeRequired() == null) {
            policy.setAlgorithmValidityCheckAtValidationTimeRequired(base.isAlgorithmValidityCheckAtValidationTimeRequired());
        }
        if (policy.isRevocationValueTrustRequired() == null) {
            policy.setRevocationValueTrustRequired(base.isRevocationValueTrustRequired());
        }
        if (policy.isCertHashInOCSPRequired() == null) {
            policy.setCertHashInOCSPRequired(base.isCertHashInOCSPRequired());
        }
        if (policy.isClaimedSigningTimeCheckRequired() == null) {
            policy.setClaimedSigningTimeCheckRequired(base.isClaimedSigningTimeCheckRequired());
        }
        if (policy.isClaimedSigningTimeInFutureAllowed() == null) {
            policy.setClaimedSigningTimeInFutureAllowed(base.isClaimedSigningTimeInFutureAllowed());
        }
        if (policy.isENConformity() == null) {
            policy.setENConformity(base.isENConformity());
        }
        if (policy.isInvalidateOldAlgorithms() == null) {
            policy.setInvalidateOldAlgorithms(base.isInvalidateOldAlgorithms());
        }
        if (policy.isOnlyOCSPAllowed() == null) {
            policy.setOnlyOCSPAllowed(base.isOnlyOCSPAllowed());
        }
        if (policy.getRevocationFreshnessCheckSettings() == null) {
            policy.setRevocationFreshnessCheckSettings(base.getRevocationFreshnessCheckSettings());
        }
        if (policy.isSelfSignedCertificateRevocationCheckRequired() == null) {
            policy.setSelfSignedCertificateRevocationCheckRequired(base.isSelfSignedCertificateRevocationCheckRequired());
        }
        if (policy.isTrustCenterGuidelineIgnored() == null) {
            policy.setTrustCenterGuidelineIgnored(base.isTrustCenterGuidelineIgnored());
        }
        if (policy.isCertificateValidationDisabled() == null) {
            policy.setCertificateValidationDisabled(base.isCertificateValidationDisabled());
        }
        if (policy.isRevocationRequestRequiredForShortTermCertificate() == null) {
            policy.setRevocationRequestRequiredForShortTermCertificate(base.isRevocationRequestRequiredForShortTermCertificate());
        }
    }

    public static ValidationPolicyType createDefaultInstance() {
        Date fromDate = new Date();
        ValidityIntervallType vi = new ValidityIntervallType();
        vi.setValidFrom(fromDate);
        vi.setValidFrom(new Date(fromDate.getTime() + 1471228928L));
        MultiLanguageStringType mlNameDE = new MultiLanguageStringType();
        mlNameDE.setLang("DE");
        mlNameDE.setValue("Governikus Pr\u00fcfrichtlinie mit Standardwerten");
        MultiLanguageStringType mlNameEN = new MultiLanguageStringType();
        mlNameEN.setLang("EN");
        mlNameEN.setValue("Governikus policy with default values");
        PolicyInformationType policyInfo = new PolicyInformationType();
        policyInfo.version = "1.0";
        policyInfo.author = "Governikus GmbH & Co. KG";
        policyInfo.name = Collections.unmodifiableList(Arrays.asList(mlNameDE, mlNameEN));
        policyInfo.description = Collections.unmodifiableList(Arrays.asList(mlNameDE, mlNameEN));
        policyInfo.setValidityIntervall(vi);
        return PolicyNormalizer.createDefaultInstance(policyInfo);
    }

    public static ValidationPolicyType createDefaultInstance(PolicyInformationType policyInfo) {
        Objects.requireNonNull(policyInfo, "policyInfo must not be NULL!");
        ValidationPolicyType policy = ValidatePolicyDefaults.getDefaultPolicy();
        new PolicyNormalizer().normalizePolicy(policy);
        policy.setPolicyInformation(policyInfo);
        return policy;
    }
}

