/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.xml;

import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XML {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XML.class);
    private static DocumentBuilderFactory dbf;

    private XML() {
    }

    private static DocumentBuilder getDBWithNSAware() {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
        }
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            log.error("", (Throwable)ex);
            return null;
        }
    }

    public static void toStream(Document doc, File file) {
        if (doc == null || file == null) {
            return;
        }
        try (FileOutputStream fOut = new FileOutputStream(file);){
            Transformer copy = XML.getTransformer();
            DOMSource ds = new DOMSource(doc);
            StreamResult rs = new StreamResult(fOut);
            copy.transform(ds, rs);
        }
        catch (TransformerException e) {
            log.error("Unable to transform", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Unable to write file", (Throwable)e);
        }
    }

    public static InputStream asStream(Document doc) throws TransformerException {
        Transformer copy = XML.getTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(doc.getDocumentElement());
        copy.transform(domSource, new StreamResult(baos));
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static Document createDocument() {
        DocumentBuilder docbuilder = XML.getDBWithNSAware();
        if (docbuilder == null) {
            return null;
        }
        docbuilder.reset();
        return docbuilder.newDocument();
    }

    public static Document fromStream(File xml) throws SAXException, IOException {
        DocumentBuilder docbuilder = XML.getDBWithNSAware();
        if (docbuilder == null) {
            return null;
        }
        docbuilder.reset();
        return docbuilder.parse(xml);
    }

    public static Document fromStream(InputStream xml) throws SAXException, IOException {
        DocumentBuilder docbuilder = XML.getDBWithNSAware();
        if (docbuilder == null) {
            return null;
        }
        docbuilder.reset();
        return docbuilder.parse(xml);
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)tf);
        Transformer copy = tf.newTransformer();
        copy.setOutputProperty("indent", "yes");
        copy.setOutputProperty("method", "xml");
        copy.setOutputProperty("omit-xml-declaration", "no");
        copy.setOutputProperty("encoding", "utf-8");
        return copy;
    }
}

