/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.vhn;

import de.governikus.gcf.businesscard.BCKey;
import de.governikus.gcf.businesscard.BusinessCard;
import de.governikus.gcf.csl.xml.XML;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement(name="Visitenkarte")
@XmlType(propOrder={"nutzerID", "titel", "vorname", "name", "strasse", "hausnummer", "postleitzahl", "ort", "bundesland", "land", "organisation", "organisationszusatz", "berufstraegereigenschaft", "externeID"})
public class Visitenkarte {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Visitenkarte.class);
    private String nutzerID;
    private String vorname;
    private String name;
    private String strasse;
    private String hausnummer;
    private String postleitzahl;
    private String ort;
    private String bundesland;
    private String land;
    private String titel;
    private String organisation;
    private String organisationszusatz;
    private String berufstraegereigenschaft;
    private String externeID;

    public Visitenkarte() {
    }

    public Visitenkarte(BusinessCard bc) {
        this.setTitel(bc.get(BCKey.TITLE));
        this.setName(bc.get(BCKey.NAME));
        this.setVorname(bc.get(BCKey.CHRISTIANNAME));
        this.setOrganisation(bc.get(BCKey.ORGANIZATION));
        this.setOrganisationszusatz(bc.get(BCKey.ORGANIZATIONUNIT));
        this.setStrasse(bc.get(BCKey.STREET));
        this.setHausnummer(bc.get(BCKey.STREETNUMBER));
        this.setPostleitzahl(bc.get(BCKey.ZIPCODE));
        this.setOrt(bc.get(BCKey.CITY));
        this.setBundesland(bc.get(BCKey.FEDERAL_STATE));
        this.setLand(bc.get(BCKey.COUNTRY));
        this.setBerufstraegereigenschaft(bc.get(BCKey.PROFESSION_PROPERTY));
        this.setNutzerID(bc.get(BCKey.USER_ID));
        this.setExterneID(bc.get(BCKey.EXTERNAL_ID));
    }

    public BusinessCard getBusinessCard() {
        BusinessCard bc = new BusinessCard();
        bc.set(BCKey.TITLE, this.getTitel());
        bc.set(BCKey.NAME, this.getName());
        bc.set(BCKey.CHRISTIANNAME, this.getVorname());
        bc.set(BCKey.ORGANIZATION, this.getOrganisation());
        bc.set(BCKey.ORGANIZATIONUNIT, this.getOrganisationszusatz());
        bc.set(BCKey.PROFESSION_PROPERTY, this.getBerufstraegereigenschaft());
        bc.set(BCKey.STREET, this.getStrasse());
        bc.set(BCKey.STREETNUMBER, this.getHausnummer());
        bc.set(BCKey.ZIPCODE, this.getPostleitzahl());
        bc.set(BCKey.CITY, this.getOrt());
        bc.set(BCKey.FEDERAL_STATE, this.getBundesland());
        bc.set(BCKey.COUNTRY, this.getLand());
        bc.set(BCKey.USER_ID, this.getNutzerID());
        bc.set(BCKey.EXTERNAL_ID, this.getExterneID());
        return bc;
    }

    @XmlElement(name="Organisation")
    public String getOrganisation() {
        return this.organisation == null ? "" : this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    @XmlElement(name="Organisationszusatz")
    public String getOrganisationszusatz() {
        return this.organisationszusatz == null ? "" : this.organisationszusatz;
    }

    public void setOrganisationszusatz(String organisationszusatz) {
        this.organisationszusatz = organisationszusatz;
    }

    @XmlElement(name="Berufstraegereigenschaft")
    public String getBerufstraegereigenschaft() {
        return this.berufstraegereigenschaft == null ? "" : this.berufstraegereigenschaft;
    }

    public void setBerufstraegereigenschaft(String berufstraegereigenschaft) {
        this.berufstraegereigenschaft = berufstraegereigenschaft;
    }

    @XmlElement(name="Titel")
    public String getTitel() {
        return this.titel == null ? "" : this.titel;
    }

    public void setTitel(String titel) {
        this.titel = titel;
    }

    @XmlElement(name="Vorname")
    public String getVorname() {
        return this.vorname == null ? "" : this.vorname;
    }

    public void setVorname(String vorname) {
        this.vorname = vorname;
    }

    @XmlElement(name="Name")
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="Strasse")
    public String getStrasse() {
        return this.strasse == null ? "" : this.strasse;
    }

    public void setStrasse(String strasse) {
        this.strasse = strasse;
    }

    @XmlElement(name="Hausnummer")
    public String getHausnummer() {
        return this.hausnummer == null ? "" : this.hausnummer;
    }

    public void setHausnummer(String hausnummer) {
        this.hausnummer = hausnummer;
    }

    @XmlElement(name="Postleitzahl")
    public String getPostleitzahl() {
        return this.postleitzahl == null ? "" : this.postleitzahl;
    }

    public void setPostleitzahl(String postleitzahl) {
        this.postleitzahl = postleitzahl;
    }

    @XmlElement(name="Ort")
    public String getOrt() {
        return this.ort == null ? "" : this.ort;
    }

    public void setOrt(String ort) {
        this.ort = ort;
    }

    @XmlElement(name="Bundesland")
    public String getBundesland() {
        return this.bundesland == null ? "" : this.bundesland;
    }

    public void setBundesland(String bundesland) {
        this.bundesland = bundesland;
    }

    @XmlElement(name="Land")
    public String getLand() {
        return this.land == null ? "" : this.land;
    }

    public void setLand(String land) {
        this.land = land;
    }

    @XmlElement(name="Nutzer_ID")
    public String getNutzerID() {
        return this.nutzerID == null ? "" : this.nutzerID;
    }

    public void setNutzerID(String nutzerID) {
        this.nutzerID = nutzerID;
    }

    @XmlElement(name="Externe_ID")
    public String getExterneID() {
        return this.externeID == null ? "" : this.externeID;
    }

    public void setExterneID(String externeID) {
        this.externeID = externeID;
    }

    public Document getDocument() {
        try {
            Document document = XML.createDocument();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Visitenkarte.class});
            context.createMarshaller().marshal((Object)this, (Node)document);
            return document;
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return null;
        }
    }

    public static Visitenkarte getObjectFromDocument(Document doc) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Visitenkarte.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (Visitenkarte)unmarshaller.unmarshal((Node)doc.getDocumentElement());
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return null;
        }
    }
}

