/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.vhn;

import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.gcf.csl.vhn.UebermittlungswegTyp;
import de.governikus.gcf.csl.vhn.VhnTyp;
import java.util.ResourceBundle;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uebermittlungsweg {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Uebermittlungsweg.class);
    private static final ResourceBundle res = ResourceBundle.getBundle(Uebermittlungsweg.class.getName());
    private final UebermittlungswegTyp uebermittlungswegTyp;
    private final VhnTyp vhnTyp;
    private final MajorTotalResult majorTotalResult;
    private final boolean sichererUebermittlungsweg;

    public Uebermittlungsweg(UebermittlungswegTyp uebermittlungswegTyp, VhnTyp vhnTyp, MajorTotalResult majorTotalResult, boolean sichererUebermittlungsweg) {
        this.uebermittlungswegTyp = uebermittlungswegTyp;
        this.vhnTyp = vhnTyp;
        this.majorTotalResult = majorTotalResult;
        this.sichererUebermittlungsweg = sichererUebermittlungsweg;
    }

    public Uebermittlungsweg(UebermittlungswegTyp uebermittlungswegTyp, VhnTyp vhnTyp, MajorTotalResult majorTotalResult) {
        this.uebermittlungswegTyp = uebermittlungswegTyp;
        this.vhnTyp = vhnTyp;
        this.majorTotalResult = majorTotalResult;
        this.sichererUebermittlungsweg = true;
    }

    public Uebermittlungsweg(UebermittlungswegTyp uebermittlungswegTyp) {
        this.uebermittlungswegTyp = uebermittlungswegTyp;
        this.vhnTyp = null;
        this.majorTotalResult = MajorTotalResult.TOTAL_FAILED;
        this.sichererUebermittlungsweg = false;
    }

    public UebermittlungswegTyp getUebermittlungswegTyp() {
        return this.uebermittlungswegTyp;
    }

    public MajorTotalResult getMajorTotalResult() {
        return this.majorTotalResult;
    }

    public VhnTyp getVhnTyp() {
        return this.vhnTyp;
    }

    public String getForHtml() {
        if (this.majorTotalResult == null || this.majorTotalResult == MajorTotalResult.NOT_VALIDATED) {
            log.warn("majorTotalResult is null -> return null");
            return null;
        }
        String value = res.getString(this.getResourceBundleStr());
        return StringEscapeUtils.escapeHtml4((String)value);
    }

    public String getForPdfOrXml() {
        if (this.majorTotalResult == null || this.majorTotalResult == MajorTotalResult.NOT_VALIDATED) {
            log.warn("majorTotalResult is null -> return null");
            return null;
        }
        return res.getString(this.getResourceBundleStr());
    }

    public String getResourceBundleStr() {
        if (this.uebermittlungswegTyp == UebermittlungswegTyp.VHN2) {
            String result = this.uebermittlungswegTyp + "_" + this.vhnTyp + "_" + Uebermittlungsweg.getSignal(this.majorTotalResult) + "_";
            result = result + (this.sichererUebermittlungsweg ? "ja" : "nein");
            return result;
        }
        if (this.uebermittlungswegTyp == UebermittlungswegTyp.VHN1) {
            return this.uebermittlungswegTyp + "_" + this.vhnTyp + "_" + Uebermittlungsweg.getSignal(this.majorTotalResult);
        }
        return this.uebermittlungswegTyp.name();
    }

    public static String getSignal(MajorTotalResult signal) {
        if (signal == MajorTotalResult.TOTAL_PASSED) {
            return "green";
        }
        if (signal == MajorTotalResult.TOTAL_FAILED) {
            return "red";
        }
        return "yellow";
    }
}

