/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.vhn;

import de.governikus.gcf.csl.vhn.VhnTyp;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OriginatorTransportsignaturUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OriginatorTransportsignaturUtils.class);
    private static final KeyStore vhn = OriginatorTransportsignaturUtils.getIssuerKeyStore();

    private OriginatorTransportsignaturUtils() {
    }

    public static KeyStore getKeyStore() {
        return vhn;
    }

    public static VhnTyp getBCustomResultBlock(X509Certificate cert) {
        String userName = cert.getIssuerX500Principal().getName("RFC2253");
        KeyStore keystore = OriginatorTransportsignaturUtils.getKeyStore();
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate issuerCert = keystore.getCertificate(alias);
                String issuerName = ((X509Certificate)issuerCert).getSubjectX500Principal().getName("RFC2253");
                if (!userName.equals(issuerName)) continue;
                cert.verify(issuerCert.getPublicKey());
                return OriginatorTransportsignaturUtils.getCustomResultBlock(alias);
            }
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static VhnTyp getCustomResultBlock(String alias) {
        if ("bea".equals(alias)) {
            return VhnTyp.BEA;
        }
        if ("bebpo".equals(alias)) {
            return VhnTyp.BEBPO;
        }
        if ("best".equals(alias)) {
            return VhnTyp.BEST;
        }
        if ("demail".equals(alias)) {
            return VhnTyp.DE_MAIL;
        }
        if ("ebo".equals(alias)) {
            return VhnTyp.EBO;
        }
        if ("egvp".equals(alias)) {
            return VhnTyp.EGVP;
        }
        if ("justiz".equals(alias)) {
            return VhnTyp.JUSTIZ;
        }
        if ("notar".equals(alias)) {
            return VhnTyp.BEN;
        }
        if ("ozg".equals(alias)) {
            return VhnTyp.OZG;
        }
        if ("test".equals(alias)) {
            return VhnTyp.TEST;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getIssuerKeyStore() {
        InputStream in = OriginatorTransportsignaturUtils.class.getResourceAsStream("/vhn_issuer.p12");
        if (in != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
                keyStore.load(in, "123456".toCharArray());
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.debug("");
                }
            }
        }
        return null;
    }
}

