/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.versand;

import de.governikus.gcf.csl.pruefvermerk.Visitenkarte;
import de.governikus.gcf.csl.versand.Dokument;
import de.governikus.gcf.csl.versand.EingangsbestaetigungReport;
import de.governikus.gcf.csl.versand.Nachricht;
import de.governikus.gcf.csl.vhn.Uebermittlungsweg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="Eingangsbestaetigung")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"erstellungszeitpunkt", "eingangszeitpunkt", "abholzeitpunkt", "uebermittlungsweg", "osciManager", "nachrichtenkennzeichen", "nachricht", "absender", "empfaenger", "dokumenten"})
public class Eingangsbestaetigung {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Eingangsbestaetigung.class);
    @XmlAttribute(name="eingangsbestaetigungVersion")
    private String version = "1";
    @XmlElement(name="Erstellungszeitpunkt")
    private String erstellungszeitpunkt;
    @XmlElement(name="Eingangszeitpunkt")
    private String eingangszeitpunkt;
    @XmlElement(name="Abholzeitpunkt")
    private String abholzeitpunkt = EingangsbestaetigungReport.getString("abholzeitpunkt");
    @XmlTransient
    private Uebermittlungsweg uebermittlungsweg;
    @XmlElement(name="Nachrichtenkennzeichen")
    private String nachrichtenkennzeichen;
    @XmlElement(name="OsciManager")
    private String osciManager;
    @XmlElement(name="Nachricht")
    private Nachricht nachricht;
    @XmlElement(name="Absender")
    private Visitenkarte absender;
    @XmlElement(name="Empfaenger")
    private Visitenkarte empfaenger;
    @XmlElement(name="Dokument")
    private List<Dokument> dokumenten = new ArrayList<Dokument>();

    public String getErstellungszeitpunkt() {
        return this.erstellungszeitpunkt;
    }

    public void setErstellungszeitpunkt(Date date) {
        this.erstellungszeitpunkt = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss").format(date);
    }

    public void setErstellungszeitpunkt(String erstellungszeitpunkt) {
        this.erstellungszeitpunkt = erstellungszeitpunkt;
    }

    public String getEingangszeitpunkt() {
        return this.eingangszeitpunkt;
    }

    public void setEingangszeitpunkt(String eingangszeitpunkt) {
        this.eingangszeitpunkt = eingangszeitpunkt;
    }

    public void setEingangszeitpunkt(Date date) {
        this.eingangszeitpunkt = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss").format(date);
    }

    public String getAbholzeitpunkt() {
        return this.abholzeitpunkt;
    }

    public void setAbholzeitpunkt(String abholzeitpunkt) {
        this.abholzeitpunkt = abholzeitpunkt;
    }

    public void setAbholzeitpunkt(Date date) {
        this.abholzeitpunkt = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss").format(date);
    }

    @XmlElement(name="Uebermittlungsweg")
    public String getUebermittlungsweg() {
        if (this.uebermittlungsweg != null) {
            return this.uebermittlungsweg.getForPdfOrXml();
        }
        return "";
    }

    public void setUebermittlungsweg(Uebermittlungsweg uebermittlungsweg) {
        this.uebermittlungsweg = uebermittlungsweg;
    }

    public String getOsciManager() {
        return this.osciManager;
    }

    public void setOsciManager(String osciManager) {
        this.osciManager = osciManager;
    }

    public String getNachrichtenkennzeichen() {
        return this.nachrichtenkennzeichen;
    }

    public void setNachrichtenkennzeichen(String nachrichtenkennzeichen) {
        this.nachrichtenkennzeichen = nachrichtenkennzeichen;
    }

    public Nachricht getNachricht() {
        return this.nachricht == null ? new Nachricht() : this.nachricht;
    }

    public void setNachricht(Nachricht nachricht) {
        this.nachricht = nachricht;
    }

    public Visitenkarte getAbsender() {
        return this.absender;
    }

    public void setAbsender(Visitenkarte absender) {
        this.absender = absender;
    }

    public Visitenkarte getEmpfaenger() {
        return this.empfaenger;
    }

    public void setEmpfaenger(Visitenkarte empfaenger) {
        this.empfaenger = empfaenger;
    }

    public List<Dokument> getDokumenten() {
        return this.dokumenten;
    }

    public void setDokumenten(List<Dokument> dokumenten) {
        this.dokumenten = dokumenten;
    }

    public void addDokument(Dokument dokument) {
        if (this.checkDuplicate(dokument)) {
            this.dokumenten.add(dokument);
            Collections.sort(this.dokumenten);
        }
    }

    private boolean checkDuplicate(Dokument dok) {
        for (Dokument d : this.dokumenten) {
            if (!d.getDateiName().equals(dok.getDateiName())) continue;
            return false;
        }
        return true;
    }

    public static String getXML(Object object) throws JAXBException {
        log.info("");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Eingangsbestaetigung.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter writer = new StringWriter();
        m.marshal(object, (Writer)writer);
        return writer.toString();
    }

    public static void setXML(Object object, File file) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Eingangsbestaetigung.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)"eingangsbestaetigung.xsd");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream fos = new FileOutputStream(file);
        m.marshal(object, (OutputStream)fos);
        fos.close();
    }
}

