/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.versand;

import de.governikus.gcf.csl.Utils;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.io.FilenameUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"anzeigename", "format"})
public class Dokument
implements Comparable<Dokument> {
    @XmlElement(name="Format")
    private String format;
    @XmlTransient
    private String dateiName;
    static FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
    static Font font = new Font("Times New Roman", 0, 10);

    public Dokument(String dateiName) {
        this.dateiName = Utils.getUTF8Encoded(dateiName);
        this.format = FilenameUtils.getExtension((String)this.dateiName);
    }

    @XmlElement(name="DateiName")
    public String getAnzeigename() {
        return Dokument.addWhiteSpaces(this.dateiName, 131, true);
    }

    public String getFormat() {
        return this.format == null ? "" : this.format;
    }

    public String getDateiName() {
        return this.dateiName == null ? "" : this.dateiName;
    }

    public void setDateiName(String dateiName) {
        this.dateiName = Utils.getUTF8Encoded(dateiName);
        this.format = FilenameUtils.getExtension((String)this.dateiName);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public static String addWhiteSpaces(String str, int length, boolean unsichtbar) {
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        StringBuilder result = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String s;
            String token = tokenizer.nextToken();
            if (Dokument.getTextwidth(token) <= length) {
                result.append(token);
                result.append(" ");
                continue;
            }
            StringBuilder subs = new StringBuilder();
            for (int index = 0; index < token.length(); index += s.length()) {
                s = "";
                int count = 0;
                while (Dokument.getTextwidth(s) < length && index + count < token.length()) {
                    s = token.substring(index, index + ++count);
                }
                subs.append(s).append(unsichtbar ? "\u200b" : " ");
            }
            result.append((CharSequence)subs);
            result.append(unsichtbar ? " " : "");
        }
        return Utils.getUTF8Encoded(result.toString().trim());
    }

    public static int getTextwidth(String text) {
        return (int)font.getStringBounds(text, frc).getWidth();
    }

    @Override
    public int compareTo(Dokument o) {
        return this.getDateiName().toLowerCase().compareTo(o.getDateiName().toLowerCase());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dokument) {
            Dokument dokument = (Dokument)obj;
            return this.getDateiName().equalsIgnoreCase(dokument.getDateiName());
        }
        return false;
    }

    public int hashCode() {
        return this.getDateiName().hashCode();
    }
}

