/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.validate;

import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.request.ValidationRequest;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DetachedContentCallback;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.ValidateOptions;
import de.governikus.csl.uom.validate.ValidateRequest;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.gcf.csl.Utils;
import de.governikus.gcf.csl.report.CslReport;
import de.governikus.gcf.csl.report.StackedCslReport;
import de.governikus.gcf.csl.validate.ValidationService;
import de.governikus.gcf.csl.validate.X509Document;
import de.governikus.gcf.observableserver.ObservableServer;
import de.governikus.gcf.observableserver.ServiceData;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Validator.class);
    private final File reportFolder;
    private final ValidationService service;
    private final ObservableServer observableServer;

    public Validator(File temporaryFolder, ObservableServer observableServer, ServiceData serviceData, HttpClient httpClient, List<X509Certificate> certificates) {
        this.observableServer = observableServer;
        this.reportFolder = new File(temporaryFolder, "report" + System.currentTimeMillis());
        this.service = new ValidationService(serviceData, httpClient, certificates, temporaryFolder);
    }

    public StackedCslReport validateMultiple(List<SignedData> signedData, ValidateOptions options) {
        StackedCslReport reports = new StackedCslReport();
        for (SignedData sd : signedData) {
            reports.addReport(this.validate(sd, options));
        }
        return reports;
    }

    public CslReport validate(SignedData signedData) {
        return this.validate(signedData, this.getOptions());
    }

    public CslReport validate(SignedData signedData, int depth) {
        ValidationOptions options = (ValidationOptions)this.getOptions();
        options.setMaxRecursiveValidationStepsForIncludedFiles(depth);
        return this.validate(signedData, (ValidateOptions)options);
    }

    public CslReport validate(SignedData signedData, DetachedContentCallback detachedContentCallback) {
        ValidationOptions options = (ValidationOptions)this.getOptions();
        if (detachedContentCallback != null) {
            options.setDetachedContentCallback(detachedContentCallback);
        }
        return this.validate(signedData, (ValidateOptions)options);
    }

    public CslReport validate(SignedData signedData, ValidateOptions options) {
        if (signedData == null || options == null) {
            log.error("Missing Arguments: data(set: {}), options(set: {})", (Object)(signedData == null ? 1 : 0), (Object)(options == null ? 1 : 0));
            return null;
        }
        try {
            long timeStart = System.currentTimeMillis();
            ValidationRequest vr = new ValidationRequest();
            vr.setSignedData(signedData);
            vr.setOptions((Options)options);
            CslReport report = new CslReport(this.service.getProcessor().validate((ValidateRequest)vr), this.reportFolder);
            log.info("Validation time: {} ms", (Object)(System.currentTimeMillis() - timeStart));
            this.observableServer.setOnline(this.isOnline(report.getResponse()), null);
            return report;
        }
        catch (CoreException e) {
            log.error("Could not validate", (Throwable)e);
            this.observableServer.setOnline(false, (Throwable)e);
            return null;
        }
    }

    private boolean isOnline(ValidateResponse response) {
        Object cvsURL;
        PublicKeyCertificateValidationResult pcvr;
        List<OSCIDocumentValidationResult> cocoList = Utils.getOSCIDocumentValidationResult(response);
        for (OSCIDocumentValidationResult coco : cocoList) {
            for (SignatureValidationResult vr : coco.getSignatureValidationResults()) {
                pcvr = vr.getSigningCertificateValidationResult();
                if (pcvr == null || (cvsURL = pcvr.getCvsURL()) != null && !((String)cvsURL).trim().isEmpty()) continue;
                return false;
            }
        }
        for (OSCIDocumentValidationResult coco : cocoList) {
            for (ObjectValidationResult ovr : coco.getIncludedFileValidationResults()) {
                List svr = ovr.getSignatureValidationResults();
                cvsURL = svr.iterator();
                while (cvsURL.hasNext()) {
                    String cvsURL2;
                    SignatureValidationResult signatureValidationResult = (SignatureValidationResult)cvsURL.next();
                    PublicKeyCertificateValidationResult pcvr2 = signatureValidationResult.getSigningCertificateValidationResult();
                    if (pcvr2 == null || (cvsURL2 = pcvr2.getCvsURL()) != null && !cvsURL2.trim().isEmpty()) continue;
                    return false;
                }
            }
        }
        ObjectValidationResult ovr = response.getDocumentValidationResult();
        if (ovr != null) {
            List svr = ovr.getSignatureValidationResults();
            for (SignatureValidationResult signatureValidationResult : svr) {
                if (!(signatureValidationResult instanceof PublicKeyCertificateValidationResult) || (cvsURL = (pcvr = (PublicKeyCertificateValidationResult)signatureValidationResult).getCvsURL()) != null && !((String)cvsURL).trim().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public ValidateOptions getOptions(Date validationDate) {
        return this.service.getOptions(validationDate);
    }

    public ValidateOptions getOptions() {
        return this.service.getOptions(new Date());
    }

    public CslReport validate(FlatCertificate certificate, Date choosenDate) {
        try {
            ValidationRequest vr = new ValidationRequest();
            vr.setSignedData((SignedData)new SimpleSignedData((Document)new X509Document(certificate)));
            vr.setOptions((Options)this.service.getOptions(choosenDate));
            CslReport report = new CslReport(this.service.getProcessor().validate((ValidateRequest)vr), this.reportFolder);
            this.observableServer.setOnline(this.isOnline(report.getResponse()), null);
            return report;
        }
        catch (CoreException e) {
            log.error("Could not validate", (Throwable)e);
            this.observableServer.setOnline(false, (Throwable)e);
            return null;
        }
    }
}

