/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.validate;

import de.governikus.csl.request.ValidationOptions;
import de.governikus.csl.setup.validation.SetupException;
import de.governikus.csl.setup.validation.ValidationProcessorSetup;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.validate.AlgorithmCatalog;
import de.governikus.csl.uom.validate.ValidateProcessor;
import de.governikus.gcf.observableserver.ServiceData;
import java.io.File;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationService.class);
    private ServiceData serviceData;
    private HttpClient httpClient;
    private List<X509Certificate> certificates;
    private ValidationProcessorSetup setup;
    private ValidateProcessor validationProcessor;

    public ValidationService(ServiceData serviceData, HttpClient httpClient, List<X509Certificate> certificates, File saveFolder) {
        this.init(serviceData, httpClient, certificates, saveFolder);
    }

    void init(ServiceData serviceData, HttpClient httpClient, List<X509Certificate> certificates, File saveFolder) {
        this.serviceData = serviceData;
        this.httpClient = httpClient;
        this.certificates = certificates;
        this.setup = new ValidationProcessorSetup();
        this.setup.setTempDataFolder(saveFolder).addCAdESPlugin().addPAdESPlugin().addX509Plugin().addOSCIPlugin().addAttributeCertificatePlugin().setCreateExecutorService(true).setRelaySigningCertificates(certificates);
        try {
            Class.forName("de.governikus.csl.zip.ZipContainerValidatePlugin");
            this.setup.addZipPlugin();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.setup.setTrustedAlgoCatalogSigningCertificates(this.getTrustedAlgoCatalogSigningCertificates());
        this.setup.addAlgorithmCatalog(AlgorithmCatalog.SOGIS_PLUS.name(), "algo_cat_sogis_plus.xml-signed.xml");
        this.setup.addAlgorithmCatalog(AlgorithmCatalog.SOGIS_ETSI.name(), "algo_cat_sogis_etsi.xml-signed.xml");
        this.setConfig();
    }

    private void setConfig() {
        this.setup.setRelayURL(this.serviceData.getURI().toString());
        this.setup.setRelaySigningCertificates(this.certificates);
        this.setup.setHttpClient(this.httpClient);
        try {
            this.validationProcessor = this.setup.buildValidationProcessor();
        }
        catch (SetupException ex) {
            log.error("", (Throwable)ex);
        }
    }

    ValidationOptions getOptions(Date validationDate) {
        ValidationOptions options = new ValidationOptions();
        options.setValidationDate(validationDate);
        options.setMaxRecursiveValidationStepsForIncludedFiles(3);
        return options;
    }

    ValidateProcessor getProcessor() {
        return this.validationProcessor;
    }

    private List<? extends X509Certificate> getTrustedAlgoCatalogSigningCertificates() {
        X509Certificate cert;
        CertificateFactory cf;
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        InputStream is = ValidationService.class.getResourceAsStream("/algo_cat_signing_certificate02.cer");
        if (is != null) {
            try {
                cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(is);
                result.add(cert);
            }
            catch (CertificateException ex) {
                log.error("", (Throwable)ex);
            }
        }
        if ((is = ValidationService.class.getResourceAsStream("/algo_cat_signing_certificate03.cer")) != null) {
            try {
                cf = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)cf.generateCertificate(is);
                result.add(cert);
            }
            catch (CertificateException ex) {
                log.error("", (Throwable)ex);
            }
        }
        return result;
    }
}

