/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.validate;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.JX509Certificate;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.ResponseData;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.gcf.observableserver.ConnectionListener;
import de.governikus.gcf.observableserver.ObservableServer;
import de.governikus.gcf.observableserver.ServerType;
import de.governikus.gcf.observableserver.ServiceData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.event.EventListenerList;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValidationServer
implements ServiceData,
ObservableServer,
HttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateValidationServer.class);
    private final EventListenerList ell;
    private String name;
    private boolean online;
    private final String version;
    private URI uri;
    private final List<X509Certificate> certificates;
    private final Map<String, String> header;

    public CertificateValidationServer(String name, String version, URI uri, List<X509Certificate> certificates, String userAgent) {
        this.name = name;
        this.version = version;
        this.uri = uri;
        this.certificates = certificates;
        this.ell = new EventListenerList();
        this.header = new HashMap<String, String>();
        if (userAgent != null) {
            this.header.put("User-Agent", userAgent);
        }
        this.header.put("Content-Type", "text/xml");
        this.header.put("Accept-Charset", StandardCharsets.UTF_8.name());
    }

    public CertificateValidationServer(String name, String version, URI uri, List<X509Certificate> certificates) {
        this(name, version, uri, certificates, null);
    }

    public String getXkmsVersion() {
        return this.version;
    }

    public List<FlatCertificate> getFlatCertificate() {
        if (this.certificates.isEmpty()) {
            log.info("No CSL certificate");
            return new ArrayList<FlatCertificate>();
        }
        ArrayList<FlatCertificate> result = new ArrayList<FlatCertificate>();
        for (X509Certificate certificate : this.certificates) {
            try {
                FlatCertificate c = FlatCertificate.Factory.forX509((Certificate)certificate);
                result.add(c);
            }
            catch (ParseException | CertificateEncodingException e) {
                log.error("Could not load certificate");
            }
        }
        return result;
    }

    public void addConnectionListener(ConnectionListener l) {
        this.ell.add(ConnectionListener.class, l);
    }

    public boolean checkNow() {
        if (this.getServices().isEmpty()) {
            return false;
        }
        try {
            URLConnection httpConn = this.uri.toURL().openConnection();
            int responseCode = 500;
            if (httpConn instanceof HttpsURLConnection) {
                responseCode = ((HttpsURLConnection)httpConn).getResponseCode();
            } else if (httpConn instanceof HttpURLConnection) {
                responseCode = ((HttpURLConnection)httpConn).getResponseCode();
            }
            log.info("responseCode: {} for {}", (Object)responseCode, (Object)this.uri);
            this.setOnline(responseCode == 200 || responseCode == 405, null);
            return responseCode == 200 || responseCode == 405;
        }
        catch (Exception e) {
            this.setOnline(false, e);
            log.error("", (Throwable)e);
            return false;
        }
    }

    public ServerType getServerType() {
        return ServerType.VERISERVER;
    }

    public List<? extends ServiceData> getServices() {
        return List.of(this);
    }

    public boolean isOnline() {
        return this.online;
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.ell.remove(ConnectionListener.class, l);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOnline(boolean online, Throwable cause) {
        ConnectionListener[] listeners;
        this.online = online;
        for (ConnectionListener l : listeners = (ConnectionListener[])this.ell.getListeners(ConnectionListener.class)) {
            l.connectionStateChanged((ObservableServer)this, cause);
        }
    }

    public void setCertificate(JX509Certificate certificate) {
        this.certificates.add((X509Certificate)certificate);
    }

    public JX509Certificate getCertificate() {
        if (this.certificates.isEmpty()) {
            return null;
        }
        X509Certificate cert = this.certificates.get(0);
        return JX509Certificate.forX509((X509Certificate)cert);
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public ResponseData sendPOSTRequest(String url, Map<String, String> mapHeader, byte[] request) throws IOException {
        URLConnection con;
        log.info("{}", (Object)url);
        try {
            con = new URI(url).toURL().openConnection();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.toString());
        }
        this.header.keySet().forEach(key -> con.setRequestProperty((String)key, this.header.get(key)));
        con.setUseCaches(false);
        con.setDoOutput(true);
        HttpURLConnection connection = (HttpURLConnection)con;
        connection.setRequestMethod("POST");
        OutputStream os = con.getOutputStream();
        os.write(request);
        os.flush();
        os.close();
        int responseCode = connection.getResponseCode();
        log.info("POST Response Code {} ", (Object)responseCode);
        if (responseCode == 200) {
            return new ResponseData(IOUtils.toByteArray((InputStream)con.getInputStream()), null, responseCode);
        }
        return new ResponseData(null, null, responseCode);
    }

    public void addDefaultHeader(String name, String value) {
    }

    public void close() throws IOException {
    }

    public HttpResponse delete(URI uri, HttpHeader ... headers) throws ConnectionException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <T> T post(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        log.info("");
        try (HttpResponse response = this.post(uri, entity, headers);){
            Object object = handler.handleResponse(response);
            return (T)object;
        }
    }

    public HttpResponse post(URI uri, HttpRequest requestBody, HttpHeader ... headers) throws ConnectionException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <T> T put(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public HttpResponse put(URI uri, HttpRequest entity, HttpHeader ... headers) throws ConnectionException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <T> T get(URI uri, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public HttpResponse get(URI uri, HttpHeader ... headers) throws ConnectionException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ResponseData sendGETRequest(String url) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ResponseData sendPOSTRequest(String url) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ResponseData sendPOSTRequest(String url, byte[] request) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ResponseData sendGETRequest(String url, Map<String, String> header) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ResponseData sendPOSTRequest(String url, Map<String, String> header) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }
}

