/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.report;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ResultInterpreter;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import de.governikus.csl.validate.svp.ZipDocumentValidationResult;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WholeDocumentSignedCheck
implements ResultInterpreter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WholeDocumentSignedCheck.class);
    private MajorTotalResult majorTotalResult = MajorTotalResult.NOT_VALIDATED;

    public String getDescriptionMsgCode() {
        return "functional.test.wholeOrSecurePDF.signed.description";
    }

    public ValidationResult getInterpretedResult(ObjectValidationResult validationResult) {
        log.info("");
        if (validationResult instanceof OSCIDocumentValidationResult) {
            OSCIDocumentValidationResult osciValidationResult = (OSCIDocumentValidationResult)validationResult;
            List list = osciValidationResult.getResultsForContainedObjects();
            for (ObjectValidationResult objectValidationResult : list) {
                log.info("parsing coco {}", (Object)objectValidationResult.getObjectName());
                for (ObjectValidationResult ovr : objectValidationResult.getIncludedFileValidationResults()) {
                    log.info("parsing content {}", (Object)ovr.getObjectName());
                    if (ovr instanceof PAdESDocumentValidationResult) {
                        PAdESDocumentValidationResult pvr = (PAdESDocumentValidationResult)ovr;
                        ValidationResult vr = this.getPdfInterpretedResult(pvr);
                        if (vr.getMajor() != MajorTotalResult.TOTAL_FAILED) continue;
                        return vr;
                    }
                    if (!(ovr instanceof ZipDocumentValidationResult)) continue;
                    ZipDocumentValidationResult zipValidationResult = (ZipDocumentValidationResult)ovr;
                    for (ObjectValidationResult ovr2 : zipValidationResult.getIncludedFileValidationResults()) {
                        if (!(ovr2 instanceof PAdESDocumentValidationResult)) continue;
                        PAdESDocumentValidationResult padesValidationResult = (PAdESDocumentValidationResult)ovr2;
                        log.info("parsing zip entry {}", (Object)ovr2.getObjectName());
                        ValidationResult vr = this.getPdfInterpretedResult(padesValidationResult);
                        if (vr.getMajor() != MajorTotalResult.TOTAL_FAILED) continue;
                        return vr;
                    }
                }
            }
        } else if (validationResult instanceof PAdESDocumentValidationResult) {
            PAdESDocumentValidationResult padesValidationResult = (PAdESDocumentValidationResult)validationResult;
            return this.getPdfInterpretedResult(padesValidationResult);
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null);
    }

    private ValidationResult getPdfInterpretedResult(PAdESDocumentValidationResult padesValidationResult) {
        log.info("parsing file {}", (Object)padesValidationResult.getObjectName());
        PAdESRevisionValidationResult lastSignedRevision = de.governikus.csl.pades.functional.WholeDocumentSignedCheck.getLastSignedRevision((PAdESDocumentValidationResult)padesValidationResult);
        if (lastSignedRevision != null) {
            Boolean wholeDocumentSigned = lastSignedRevision.isWholeDocumentSigned();
            Boolean lastHavingOnlySecureChanges = lastSignedRevision.isLastHavingOnlySecureChanges();
            if (wholeDocumentSigned == null || lastHavingOnlySecureChanges == null) {
                this.majorTotalResult = MajorTotalResult.TOTAL_FAILED;
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, null, (String[])new String[]{"functional.test.wholeOrSecurePDF.signed.neither"});
            }
            if (wholeDocumentSigned.booleanValue()) {
                this.majorTotalResult = MajorTotalResult.TOTAL_PASSED;
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"functional.test.wholeOrSecurePDF.signed.whole"});
            }
            if (lastHavingOnlySecureChanges.booleanValue()) {
                this.majorTotalResult = MajorTotalResult.TOTAL_PASSED;
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"functional.test.wholeOrSecurePDF.signed.secure"});
            }
            this.majorTotalResult = MajorTotalResult.TOTAL_FAILED;
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, null, (String[])new String[]{"functional.test.wholeOrSecurePDF.signed.neither"});
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null);
    }

    public ResourceBundle getResourceBundle(Locale l) {
        return ResourceBundle.getBundle("i18n.functional_validations", l);
    }

    public boolean useResourceBundleForMajorResult() {
        return false;
    }

    public boolean isWholeDocumentSigned(PAdESDocumentValidationResult padesValidationResult) {
        PAdESRevisionValidationResult lastSignedRevision = de.governikus.csl.pades.functional.WholeDocumentSignedCheck.getLastSignedRevision((PAdESDocumentValidationResult)padesValidationResult);
        if (lastSignedRevision == null) {
            return true;
        }
        Boolean wholeDocumentSigned = lastSignedRevision.isWholeDocumentSigned();
        Boolean lastHavingOnlySecureChanges = lastSignedRevision.isLastHavingOnlySecureChanges();
        if (wholeDocumentSigned == null || lastHavingOnlySecureChanges == null) {
            return true;
        }
        if (wholeDocumentSigned.booleanValue()) {
            return true;
        }
        return lastHavingOnlySecureChanges;
    }

    @Generated
    public MajorTotalResult getMajorTotalResult() {
        return this.majorTotalResult;
    }
}

