/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.report;

import de.governikus.csl.result.ObjectValidationResultVisitor;
import de.governikus.csl.result.ObjectValidationResultWalker;
import de.governikus.csl.result.SignatureCollectingResultVisitor;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ResultInterpreter;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsignedContainerCheck
implements ResultInterpreter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnsignedContainerCheck.class);
    private static final ResourceBundle resources = ResourceBundle.getBundle(UnsignedContainerCheck.class.getName());
    private MajorTotalResult majorTotalResult = MajorTotalResult.NOT_VALIDATED;

    public String getDescriptionMsgCode() {
        return "unsignedOSCI.description";
    }

    public ValidationResult getInterpretedResult(ObjectValidationResult validationResult) {
        log.info("");
        if (validationResult instanceof OSCIDocumentValidationResult) {
            OSCIDocumentValidationResult osciValidationResult = (OSCIDocumentValidationResult)validationResult;
            SignatureCollectingResultVisitor visitor = new SignatureCollectingResultVisitor();
            ObjectValidationResultWalker wl = new ObjectValidationResultWalker();
            wl.walkResult((ObjectValidationResult)osciValidationResult, (ObjectValidationResultVisitor)visitor);
            List signatureValidationResults = visitor.getSignatureValidationResults();
            CumulatedValidationResult overallResult = validationResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR);
            if (!(signatureValidationResults != null && !signatureValidationResults.isEmpty() || overallResult != null && overallResult.getMajor() != MajorTotalResult.TOTAL_PASSED)) {
                this.majorTotalResult = MajorTotalResult.TOTAL_PASSED;
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"unsignedOSCI.notSigned"});
            }
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null);
    }

    public ResourceBundle getResourceBundle(Locale l) {
        return resources;
    }

    public boolean useResourceBundleForMajorResult() {
        return false;
    }

    @Generated
    public MajorTotalResult getMajorTotalResult() {
        return this.majorTotalResult;
    }
}

