/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.report;

import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.gcf.csl.report.CslReport;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class StackedCslReport {
    private final List<CslReport> reports = new ArrayList<CslReport>();

    public void addReport(CslReport report) {
        this.reports.add(report);
    }

    public List<CslReport> getReports() {
        return this.reports;
    }

    public MajorTotalResult getOverallResult() {
        List res = this.reports.stream().map(r -> r.getResponse().getOverallResult(true).getMajor()).filter(rm -> rm != MajorTotalResult.TOTAL_PASSED).collect(Collectors.toList());
        if (res.isEmpty()) {
            return MajorTotalResult.TOTAL_PASSED;
        }
        if (res.contains(MajorTotalResult.TOTAL_FAILED)) {
            return MajorTotalResult.TOTAL_FAILED;
        }
        return MajorTotalResult.INDETERMINATE;
    }
}

