/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.report;

import de.governikus.csl.inspect.fo.InspectionSheetPDF;
import de.governikus.csl.inspect.html.InspectionSheetHTMLAccordeon;
import de.governikus.csl.sig_val_report.SignatureValidationReportOutput;
import de.governikus.csl.uom.output.LayoutException;
import de.governikus.csl.uom.output.OutputPlugin;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.gcf.csl.report.AllSignaturesCheck;
import de.governikus.gcf.csl.report.UnsignedContainerCheck;
import de.governikus.gcf.csl.report.VhnSignatureCheck;
import de.governikus.gcf.csl.report.WholeDocumentSignedCheck;
import de.governikus.gcf.csl.report.ZipCheck;
import de.governikus.gcf.csl.vhn.Uebermittlungsweg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CslReport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CslReport.class);
    private final ValidateResponse response;

    public CslReport(ValidateResponse response, File reportFolder) {
        if (!reportFolder.mkdirs()) {
            log.info("Report folder {} already exists", (Object)reportFolder.getName());
        }
        this.response = response;
    }

    public MajorTotalResult getHtmlReport(File file) {
        return this.createReport((OutputPlugin)new InspectionSheetHTMLAccordeon(), file, null, false);
    }

    public MajorTotalResult getPdfReport(File file) {
        return this.createReport((OutputPlugin)new InspectionSheetPDF(Locale.GERMANY), file, null, false);
    }

    public MajorTotalResult getHtmlReport(File file, Uebermittlungsweg uebermittlungsweg) {
        return this.createReport((OutputPlugin)new InspectionSheetHTMLAccordeon(), file, uebermittlungsweg, false);
    }

    public MajorTotalResult getHtmlReport(File file, Uebermittlungsweg uebermittlungsweg, boolean zipFileHasPasswordEncryptedEntry) {
        return this.createReport((OutputPlugin)new InspectionSheetHTMLAccordeon(), file, uebermittlungsweg, zipFileHasPasswordEncryptedEntry);
    }

    public void getXMLReport(File xmlFile) {
        SignatureValidationReportOutput sheet = new SignatureValidationReportOutput();
        try (FileOutputStream fos = new FileOutputStream(xmlFile);){
            sheet.layout(this.response, (OutputStream)fos);
        }
        catch (Exception e) {
            log.error("Could not create xml report", (Throwable)e);
        }
    }

    public ValidateResponse getResponse() {
        return this.response;
    }

    public MajorTotalResult getMajorTotalResult(Uebermittlungsweg uebermittlungsweg) {
        ObjectValidationResult objectValidationResult = this.response.getDocumentValidationResult();
        AllSignaturesCheck allSignaturesCheck = new AllSignaturesCheck();
        MajorTotalResult majorTotalResult = allSignaturesCheck.getInterpretedResult(objectValidationResult).getMajor();
        WholeDocumentSignedCheck wholeDocumentSignedCheck = new WholeDocumentSignedCheck();
        majorTotalResult = MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)wholeDocumentSignedCheck.getInterpretedResult(objectValidationResult).getMajor());
        majorTotalResult = uebermittlungsweg != null && uebermittlungsweg.getMajorTotalResult() != null ? MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)uebermittlungsweg.getMajorTotalResult()) : MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)new UnsignedContainerCheck().getInterpretedResult(objectValidationResult).getMajor());
        return majorTotalResult;
    }

    private MajorTotalResult createReport(OutputPlugin plugin, File report, Uebermittlungsweg uebermittlungsweg, boolean zipFileHasPasswordEncryptedEntry) {
        ArrayList<Object> ip = new ArrayList<Object>();
        UnsignedContainerCheck unsignedContainerCheck = null;
        if (uebermittlungsweg != null) {
            ip.add(new VhnSignatureCheck(uebermittlungsweg));
        } else {
            unsignedContainerCheck = new UnsignedContainerCheck();
            ip.add(unsignedContainerCheck);
        }
        ZipCheck zipCheck = null;
        if (zipFileHasPasswordEncryptedEntry) {
            zipCheck = new ZipCheck();
            ip.add(zipCheck);
        }
        AllSignaturesCheck allSignaturesCheck = new AllSignaturesCheck();
        ip.add(allSignaturesCheck);
        WholeDocumentSignedCheck wholeDocumentSignedCheck = new WholeDocumentSignedCheck();
        ip.add(wholeDocumentSignedCheck);
        plugin.setResultInterpreter(ip);
        HashMap<String, Boolean> additionalSettings = new HashMap<String, Boolean>();
        additionalSettings.put("summary_inspection", Boolean.TRUE);
        additionalSettings.put("dontPrintUnsignedObjects", Boolean.TRUE);
        plugin.setAdditionalSettings(additionalSettings);
        try (FileOutputStream out = new FileOutputStream(report);){
            plugin.layout(this.response, (OutputStream)out);
        }
        catch (LayoutException e) {
            log.error("Could not create layout", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not create temporary file", (Throwable)e);
        }
        MajorTotalResult majorTotalResult = allSignaturesCheck.getMajorTotalResult();
        majorTotalResult = MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)wholeDocumentSignedCheck.getMajorTotalResult());
        if (unsignedContainerCheck != null) {
            majorTotalResult = MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)unsignedContainerCheck.getMajorTotalResult());
        }
        if (uebermittlungsweg != null && uebermittlungsweg.getMajorTotalResult() != null) {
            majorTotalResult = MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)uebermittlungsweg.getMajorTotalResult());
        }
        if (zipCheck != null) {
            majorTotalResult = MajorTotalResult.max((MajorTotalResult)majorTotalResult, (MajorTotalResult)zipCheck.getMajorTotalResult());
        }
        return majorTotalResult;
    }

    public MajorTotalResult getPdfReport(File file, Uebermittlungsweg uebermittlungsweg) {
        return this.createReport((OutputPlugin)new InspectionSheetPDF(Locale.GERMANY), file, uebermittlungsweg, false);
    }

    public MajorTotalResult getPdfReport(File file, Uebermittlungsweg uebermittlungsweg, boolean zipFileHasPasswordEncryptedEntry) {
        return this.createReport((OutputPlugin)new InspectionSheetPDF(Locale.GERMANY), file, uebermittlungsweg, zipFileHasPasswordEncryptedEntry);
    }
}

