/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.report;

import de.governikus.csl.result.ObjectValidationResultVisitor;
import de.governikus.csl.result.SignatureCollectingResultVisitor;
import de.governikus.csl.result.UntypedObjectValidationResultWalker;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ResultInterpreter;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllSignaturesCheck
implements ResultInterpreter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AllSignaturesCheck.class);
    private static ResourceBundle resources = ResourceBundle.getBundle(AllSignaturesCheck.class.getName());
    private MajorTotalResult majorTotalResult = MajorTotalResult.NOT_VALIDATED;

    public String getDescriptionMsgCode() {
        return "allSignatures.description";
    }

    public ValidationResult getInterpretedResult(ObjectValidationResult validationResult) {
        log.info("");
        UntypedObjectValidationResultWalker walker = new UntypedObjectValidationResultWalker();
        SignatureCollectingResultVisitor visitor = new SignatureCollectingResultVisitor();
        walker.walkResult(validationResult, (ObjectValidationResultVisitor)visitor);
        List signatureValidationResults = visitor.getSignatureValidationResults();
        if (signatureValidationResults == null || signatureValidationResults.isEmpty()) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null);
        }
        this.majorTotalResult = MajorTotalResult.TOTAL_PASSED;
        for (SignatureValidationResult svr : signatureValidationResults) {
            CumulatedValidationResult overallResult = svr.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR);
            MajorTotalResult major = overallResult.getMajor();
            this.majorTotalResult = MajorTotalResult.max((MajorTotalResult)this.majorTotalResult, (MajorTotalResult)major);
        }
        String msgCode = this.selectMsgCode(this.majorTotalResult);
        return SVPFactory.create((MajorTotalResult)this.majorTotalResult, null, (String[])new String[]{msgCode});
    }

    private String selectMsgCode(MajorTotalResult current) {
        switch (current) {
            case INDETERMINATE: {
                return "allSignatures.indeterminate";
            }
            case TOTAL_FAILED: {
                return "allSignatures.invalid";
            }
            case TOTAL_PASSED: {
                return "allSignatures.valid";
            }
        }
        return null;
    }

    public ResourceBundle getResourceBundle(Locale l) {
        return resources;
    }

    public boolean useResourceBundleForMajorResult() {
        return false;
    }

    public MajorTotalResult getMajorTotalResult() {
        return this.majorTotalResult;
    }
}

