/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.pruefvermerk;

import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.x509.AdmissionSyntax;
import de.bos_bremen.ci.asn1.x509.Admissions;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.ProfessionInfo;
import de.bos_bremen.ci.asn1.x509.ext.AdmissionExtension;
import de.governikus.gcf.csl.pruefvermerk.Dokument;
import de.governikus.gcf.csl.pruefvermerk.Pruefergebnis;
import de.governikus.gcf.csl.pruefvermerk.PruefergebnisCode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import lombok.Generated;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"qualifiziertNachERVB", "signiertDurch", "berufsbezogenesAttribut", "seriennummer", "signiertAm", "pruefergebnis"})
public class Signatur {
    @XmlElement(name="QualifiziertNachERVB")
    private String qualifiziertNachERVB;
    @XmlElement(name="SigniertDurch")
    private String signiertDurch;
    @XmlElement(name="SigniertAm")
    private String signiertAm;
    @XmlElement(name="BerufsbezogenesAttribut")
    private String berufsbezogenesAttribut;
    @XmlElement(name="Seriennummer")
    private String seriennummer;
    @XmlElement(name="Pruefergebnis")
    private Pruefergebnis pruefergebnis = new Pruefergebnis();
    @XmlTransient
    private Date signiertAmDate;

    public String getSigniertDurch() {
        return this.signiertDurch == null ? "" : this.signiertDurch;
    }

    public void setSigniertDurch(String signiertDurch) {
        this.signiertDurch = signiertDurch;
    }

    public String getSeriennummer() {
        return this.seriennummer == null ? "" : this.seriennummer;
    }

    public void setSeriennummer(String value) {
        String[] list = value.split("(?<=\\G.{24})");
        StringBuilder strBuilder = new StringBuilder();
        for (String str : list) {
            strBuilder.append(str).append(" ");
        }
        this.seriennummer = strBuilder.toString().trim();
    }

    public String getSigniertAm() {
        return this.signiertAm == null ? "" : this.signiertAm;
    }

    public void setSigniertAm(Date signiertAm) {
        if (signiertAm == null) {
            return;
        }
        this.signiertAmDate = signiertAm;
        this.signiertAm = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss").format(signiertAm);
    }

    public String getQualifiziertNachERVB() {
        return this.qualifiziertNachERVB;
    }

    public void setQualifiziertNachERVB(String qualifiziertNachERVB) {
        this.qualifiziertNachERVB = qualifiziertNachERVB;
    }

    protected boolean isQualifiziert() {
        if (this.qualifiziertNachERVB == null) {
            return false;
        }
        return "ja".equalsIgnoreCase(this.qualifiziertNachERVB) || "Containersignatur".equalsIgnoreCase(this.qualifiziertNachERVB);
    }

    public String getBerufsbezogenesAttribut() {
        return this.berufsbezogenesAttribut == null ? "" : this.berufsbezogenesAttribut;
    }

    public void setBerufsbezogenesAttribut(FlatCertificate flatCert) {
        if (!(flatCert instanceof Certificate)) {
            return;
        }
        Extensions extensions = flatCert.getExtensions();
        if (extensions == null) {
            return;
        }
        Extension extension = extensions.get("1.3.36.8.3.3");
        if (!(extension instanceof AdmissionExtension)) {
            return;
        }
        AdmissionExtension admissionExtension = (AdmissionExtension)extension;
        AdmissionSyntax admissionSyntax = admissionExtension.getSyntax();
        if (admissionSyntax == null) {
            return;
        }
        List admissionsList = admissionSyntax.getAdmissions();
        if (admissionsList == null) {
            return;
        }
        for (Admissions admissions : admissionsList) {
            List professionInfos = admissions.getProfessionInfos();
            if (professionInfos == null) continue;
            for (ProfessionInfo professionInfo : professionInfos) {
                CharString charString;
                Iterator iter;
                List professionItems = professionInfo.getProfessionItems();
                if (professionItems == null || !(iter = professionItems.iterator()).hasNext() || (charString = (CharString)iter.next()) == null) continue;
                this.berufsbezogenesAttribut = Dokument.addWhiteSpaces(charString.getValue(), 60, true);
                return;
            }
        }
    }

    public Pruefergebnis getPruefergebnis() {
        if (!this.isQualifiziert()) {
            return null;
        }
        return this.pruefergebnis;
    }

    public void setPruefergebnis(Pruefergebnis pruefergebnis) {
        this.pruefergebnis = pruefergebnis;
    }

    public void setGueltigkeitspruefung(PruefergebnisCode gueltigkeitspruefung) {
        this.pruefergebnis.setGueltigkeitspruefung(gueltigkeitspruefung);
    }

    public void setIntegritaetspruefung(PruefergebnisCode integritaetspruefung) {
        this.pruefergebnis.setIntegritaetspruefung(integritaetspruefung);
    }

    public int hashCode() {
        return this.signiertAmDate != null ? (int)this.signiertAmDate.getTime() : -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Signatur) || this.signiertAmDate == null) {
            return false;
        }
        Signatur signatur = (Signatur)o;
        return this.signiertAmDate.equals(signatur.getSigniertAmDate());
    }

    @Generated
    public Date getSigniertAmDate() {
        return this.signiertAmDate;
    }
}

