/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.pruefvermerk;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.validate.CertificateType;
import de.governikus.csl.uom.validate.Quality;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import de.governikus.csl.validate.svp.CAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.CertificateQualityResult;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.QualityResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.gcf.csl.CertificateQualificationUtils;
import de.governikus.gcf.csl.Utils;
import de.governikus.gcf.csl.pruefvermerk.ContainerSignatur;
import de.governikus.gcf.csl.pruefvermerk.Dokument;
import de.governikus.gcf.csl.pruefvermerk.JARResourceResolver;
import de.governikus.gcf.csl.pruefvermerk.PruefergebnisCode;
import de.governikus.gcf.csl.pruefvermerk.Pruefvermerk;
import de.governikus.gcf.csl.pruefvermerk.PruefvermerkParameter;
import de.governikus.gcf.csl.pruefvermerk.Signatur;
import de.governikus.gcf.csl.pruefvermerk.Signaturformat;
import de.governikus.gcf.csl.pruefvermerk.UebermittlungswegUtil;
import de.governikus.gcf.csl.pruefvermerk.Visitenkarte;
import de.governikus.gcf.csl.report.WholeDocumentSignedCheck;
import de.governikus.gcf.csl.xml.XML;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.type.AbstractField;
import org.apache.xmpbox.xml.XmpSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PruefvermerkReport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PruefvermerkReport.class);
    private static final ResourceBundle res = ResourceBundle.getBundle(PruefvermerkReport.class.getName());
    private static final String RFC_822_DE_MAIL_DATE_FORMAT = "EEEE, yyyy.MM.dd HH:mm:ss Z";
    static final String CONTAINER_SIGNATUR = "Containersignatur";
    private static final HashSet<String> ignoreList = new HashSet();
    private final Pruefvermerk pruefvermerk = new Pruefvermerk();

    public PruefvermerkReport(PruefvermerkParameter controller) {
        this.pruefvermerk.setErstellungszeitpunkt(new Date());
        String value = controller.getEntranceOnServer();
        if (value != null) {
            this.pruefvermerk.setEingangszeitpunkt(new Date(Long.parseLong(value)));
        }
        this.pruefvermerk.setNachrichtenkennzeichen(controller.getMessageID());
        this.pruefvermerk.setUebermittlungsweg(controller.getUebermittlungsweg());
        this.pruefvermerk.setNurImVHN(controller.getNurImVHN());
        this.pruefvermerk.setNichtImVHN(controller.getNichtImVHN());
        this.pruefvermerk.setAbsender(controller.getOriginatorBusinessCard());
        this.pruefvermerk.setEmpfaenger(controller.getReceiverBusinessCard());
        this.pruefvermerk.setNachricht(controller.getNachricht());
        File xJustizNachricht = this.getXJustizNachricht(controller.getAttachments());
        this.parseXJustizNachricht(xJustizNachricht);
        if (UebermittlungswegUtil.isDeMail(controller.getUebermittlungsweg())) {
            File deMailFile = this.getDeMailFile(controller.getAttachments());
            this.parseDeMailFile(deMailFile);
        }
        ContainerSignatur cs = new ContainerSignatur();
        List<OSCIDocumentValidationResult> cocoList = Utils.getOSCIDocumentValidationResult(controller.getValidateResponse());
        cs.setPruefergebnis(Utils.getOSCIDocumentMajorTotalResult(controller.getValidateResponse()).toString());
        for (OSCIDocumentValidationResult coco : cocoList) {
            if (!"project_coco".equalsIgnoreCase(coco.getObjectName())) continue;
            this.validateOsciSignatures(cs, coco);
        }
        if (cs.isQualifiziert()) {
            this.pruefvermerk.setContainerSignatur(cs);
        }
        for (OSCIDocumentValidationResult coco : cocoList) {
            log.info(coco.getObjectName());
            if (!"project_coco".equalsIgnoreCase(coco.getObjectName())) continue;
            for (ObjectValidationResult ovr : coco.getIncludedFileValidationResults()) {
                log.info("dateiname:  {} - dateityp:  {}", (Object)ovr.getObjectName(), (Object)ovr.getObjectTypeID());
                this.createAttachmentTag(controller, ovr, null);
            }
        }
        for (File f : controller.getAttachments()) {
            if (this.shouldIgnore(f.getName())) continue;
            this.pruefvermerk.addDokument(new Dokument(f.getName()));
            if (!f.getName().toLowerCase().endsWith(".zip")) continue;
            this.getAllZipFiles(f);
        }
        this.pruefvermerk.setDokumenten(this.deduplicate(this.pruefvermerk.getDokumenten().stream()));
        this.pruefvermerk.getDokumenten().forEach(d -> d.setInnereDokumentList(this.deduplicate(d.getInnereDokumentList().stream())));
    }

    private void validateOsciSignatures(ContainerSignatur cs, OSCIDocumentValidationResult osci) {
        for (SignatureValidationResult vr : osci.getSignatureValidationResults()) {
            CertificateQualityResult cqr;
            PublicKeyCertificateValidationResult scvr = vr.getSigningCertificateValidationResult();
            if (scvr == null || scvr.getQualityInformation() == null) continue;
            boolean qualified = false;
            QualityResult qr = scvr.getQualityResult();
            if (qr != null && (cqr = qr.getCertificateQualityResult()) != null) {
                Quality q = cqr.getQuality();
                log.info("Quality: {}", (Object)q);
                CertificateType certificateType = cqr.getCertificateType();
                log.info("CertificateType: {}", (Object)certificateType);
                qualified = q == Quality.QC && certificateType == CertificateType.SIG;
            }
            Signatur signatur = new Signatur();
            signatur.setQualifiziertNachERVB(qualified ? "ja" : "nein");
            signatur.setSigniertAm(vr.getBestSignatureTime());
            signatur.setGueltigkeitspruefung(PruefvermerkReport.getState(vr.getOverallResult(true).getMajor()));
            signatur.setIntegritaetspruefung(PruefvermerkReport.getState(vr.getSignatureValidationIntegrityResult().getMajor()));
            signatur.setSigniertDurch(vr.getSigningCertificateValidationResult().getCert().getSubjectX500Principal().getName());
            X509CertificateImpl c = vr.getSigningCertificateValidationResult().getCert();
            try {
                signatur.setBerufsbezogenesAttribut((FlatCertificate)new Certificate((Source)new BSource(c.getEncoded())));
            }
            catch (ParseException | CertificateEncodingException e) {
                log.error("Unable to read certificate", e);
            }
            cs.addSigner(signatur);
        }
    }

    public void setPdfPruefvermerk(File file) {
        log.info("");
        String source = this.pruefvermerk.getContainerSignatur() != null ? "/de/governikus/gcf/csl/pruefvermerk/pruefvermerkWithCS.xsl" : "/de/governikus/gcf/csl/pruefvermerk/pruefvermerk.xsl";
        try (InputStream xsltFile = Pruefvermerk.class.getResourceAsStream(source);){
            String str = Pruefvermerk.getXML(this.pruefvermerk);
            StreamSource xmlSource = new StreamSource(new StringReader(str));
            FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
            String fopBaseConfig = "fop_conf.xml";
            try (InputStream cfgStream = PruefvermerkReport.class.getResourceAsStream(fopBaseConfig);){
                FopConfParser fopConfParser = new FopConfParser(cfgStream, new URI("jarprotocol:/"), (ResourceResolver)new JARResourceResolver());
                FopFactoryBuilder fopFactoryBuilder = fopConfParser.getFopFactoryBuilder();
                fopFactory = fopFactoryBuilder.build();
            }
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            foUserAgent.setAccessibility(true);
            try (FileOutputStream out = new FileOutputStream(file);){
                Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
                TransformerFactory factory = TransformerFactory.newInstance();
                SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)factory);
                Transformer transformer = factory.newTransformer(new StreamSource(xsltFile));
                SAXResult result = new SAXResult(fop.getDefaultHandler());
                transformer.transform(xmlSource, result);
            }
            this.setXMPMetadata(file);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void setXmlPruefvermerk(File file) {
        log.info("");
        try {
            Pruefvermerk.setXML(this.pruefvermerk, file);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    static PruefergebnisCode getState(MajorTotalResult result) {
        PruefergebnisCode value = PruefergebnisCode.unbestimmt;
        if (result == MajorTotalResult.TOTAL_PASSED) {
            value = PruefergebnisCode.gueltig;
        } else if (result == MajorTotalResult.TOTAL_FAILED) {
            value = PruefergebnisCode.ungueltig;
        }
        return value;
    }

    private File getAttachmentAsFile(String objectName, PruefvermerkParameter controller) {
        Optional<File> file = controller.getAttachments().stream().filter(attachment -> attachment.getName().equals(objectName)).findFirst();
        return file.orElse(null);
    }

    private void createAttachmentTag(PruefvermerkParameter controller, ObjectValidationResult attachment, Dokument zipDokument) {
        if (this.shouldIgnore(attachment.getObjectName())) {
            return;
        }
        if (attachment instanceof PAdESDocumentValidationResult) {
            PAdESDocumentValidationResult padesDocumentValidationResult = (PAdESDocumentValidationResult)attachment;
            this.createPDFAttachmentTag(padesDocumentValidationResult, zipDokument);
        } else {
            List signatureValidationResults = attachment.getSignatureValidationResults();
            if (signatureValidationResults != null && !signatureValidationResults.isEmpty()) {
                log.info("");
                for (SignatureValidationResult signatureValidationResult : signatureValidationResults) {
                    if (!(signatureValidationResult instanceof CAdESSignatureValidationResult)) {
                        Dokument dokument = new Dokument(attachment.getObjectName());
                        dokument.setPruefergebnisCode(PruefergebnisCode.nicht_lesbar);
                        this.attachDokument(zipDokument, dokument);
                        continue;
                    }
                    CAdESSignatureValidationResult cades = (CAdESSignatureValidationResult)signatureValidationResult;
                    if (cades.getSignatureType() == SignatureType.ENVELOPED) continue;
                    Dokument dokument = new Dokument(attachment.getObjectName());
                    dokument.setSignaturformat(Signaturformat.CADES);
                    this.checkNotReachable(dokument, signatureValidationResult);
                    File contentFile = this.getSignedData(cades, controller);
                    if (contentFile == null) {
                        dokument.setPruefergebnisCode(PruefergebnisCode.keine_inhaltsdatei);
                    } else {
                        dokument.setInhaltsdaten(contentFile);
                    }
                    for (SignatureValidationResult signatureEntry : attachment.getSignatureValidationResults()) {
                        this.createSignatureProperties(dokument, signatureEntry);
                    }
                    if (zipDokument != null) {
                        this.pruefvermerk.addDokumentIntoZip(zipDokument, dokument);
                        continue;
                    }
                    this.pruefvermerk.addDokument(dokument);
                }
            }
        }
        List files = attachment.getIncludedFileValidationResults();
        if (files != null && !files.isEmpty()) {
            Dokument zipDokument2 = null;
            if (attachment.getObjectTypeID().toLowerCase().contains("zip")) {
                zipDokument2 = new Dokument(attachment.getObjectName());
                this.pruefvermerk.addDokument(zipDokument2);
            }
            for (ObjectValidationResult fileInZip : files) {
                log.info("dateiname: {} - dateityp:  {}", (Object)fileInZip.getObjectName(), (Object)fileInZip.getObjectTypeID());
                this.createAttachmentTag(controller, fileInZip, zipDokument2);
                List zipFiles = fileInZip.getIncludedFileValidationResults();
                if (zipFiles == null || zipFiles.isEmpty()) continue;
                Dokument zipDokument3 = null;
                if (fileInZip.getObjectTypeID().toLowerCase().contains("zip")) {
                    zipDokument3 = new Dokument(fileInZip.getObjectName());
                    this.pruefvermerk.addDokument(zipDokument3);
                }
                for (ObjectValidationResult fileInZip2 : zipFiles) {
                    log.info("dateiname: {} - dateityp:  {}", (Object)fileInZip2.getObjectName(), (Object)fileInZip2.getObjectTypeID());
                    this.createAttachmentTag(controller, fileInZip2, zipDokument3);
                }
            }
        }
    }

    private void attachDokument(Dokument zipDokument, Dokument attachment) {
        if (zipDokument != null) {
            this.pruefvermerk.addDokumentIntoZip(zipDokument, attachment);
        } else {
            this.pruefvermerk.addDokument(attachment);
        }
    }

    private void getSignatureFromPAdESDocument(PAdESDocumentValidationResult pvr, Dokument attachment) {
        List objectValidationResults;
        List signatureValidationResults = pvr.getSignatureValidationResults();
        if (signatureValidationResults != null) {
            for (SignatureValidationResult svr : signatureValidationResults) {
                this.checkNotReachable(attachment, svr);
                this.createSignatureProperties(attachment, svr);
            }
        }
        if ((objectValidationResults = pvr.getResultsForContainedObjects()) == null) {
            return;
        }
        for (ObjectValidationResult objectValidationResult : objectValidationResults) {
            log.info("ObjectName: {}", (Object)objectValidationResult.getObjectName());
            if (!(objectValidationResult instanceof PAdESDocumentValidationResult)) continue;
            PAdESDocumentValidationResult padesDocumentValidationResult = (PAdESDocumentValidationResult)objectValidationResult;
            this.getSignatureFromPAdESDocument(padesDocumentValidationResult, attachment);
        }
    }

    private void createPDFAttachmentTag(PAdESDocumentValidationResult pvr, Dokument zipDokument) {
        boolean isWholeDocumentSigned;
        Dokument attachment = new Dokument(pvr.getObjectName());
        attachment.setSignaturformat(Signaturformat.PADES);
        if (pvr.getOverallResult(true) == null || pvr.getOverallResult(true).getMajor() == null) {
            log.info("Die Datei ({}) ist nicht signiert.", (Object)pvr.getObjectName());
            return;
        }
        if (zipDokument != null) {
            this.pruefvermerk.addDokumentIntoZip(zipDokument, attachment);
        }
        if (!(isWholeDocumentSigned = new WholeDocumentSignedCheck().isWholeDocumentSigned(pvr))) {
            attachment.setAenderungNachSignaturanbringung(true);
        }
        this.getSignatureFromPAdESDocument(pvr, attachment);
        this.attachDokument(zipDokument, attachment);
    }

    private void createSignatureProperties(Dokument dokument, SignatureValidationResult svr) {
        CertificateQualityResult cqr;
        Date signingTime = svr.getBestSignatureTime();
        if (signingTime == null) {
            return;
        }
        Signatur signer = new Signatur();
        boolean qualified = false;
        PublicKeyCertificateValidationResult scvr = svr.getSigningCertificateValidationResult();
        if (scvr == null) {
            return;
        }
        QualityResult qr = scvr.getQualityResult();
        if (qr != null && (cqr = qr.getCertificateQualityResult()) != null) {
            Quality q = cqr.getQuality();
            log.info("Quality: {}", (Object)q);
            CertificateType certificateType = cqr.getCertificateType();
            log.info("CertificateType: {}", (Object)certificateType);
            qualified = q == Quality.QC && certificateType == CertificateType.SIG;
        }
        try {
            X509CertificateImpl c = svr.getSigningCertificateValidationResult().getCert();
            if (c == null) {
                return;
            }
            Certificate cert = new Certificate((Source)new BSource(c.getEncoded()));
            if (!qualified) {
                qualified = CertificateQualificationUtils.isQualified(cert);
            }
            signer.setSigniertAm(signingTime);
            signer.setGueltigkeitspruefung(PruefvermerkReport.getState(svr.getOverallResult(true).getMajor()));
            signer.setIntegritaetspruefung(PruefvermerkReport.getState(svr.getSignatureValidationIntegrityResult().getMajor()));
            signer.setSigniertDurch(cert.getSubjectCommonName());
            signer.setSeriennummer(cert.getSerialNumber().getValueAsString());
            signer.setBerufsbezogenesAttribut((FlatCertificate)cert);
            dokument.addSigner(signer);
        }
        catch (ParseException | CertificateEncodingException e) {
            log.error("Unable to read certificate", e);
        }
        signer.setQualifiziertNachERVB(qualified ? "ja" : "nein");
        if (qualified && "zip".equalsIgnoreCase(dokument.getFormat())) {
            signer.setQualifiziertNachERVB(CONTAINER_SIGNATUR);
        }
    }

    private void getAllZipFiles(File zip) {
        Dokument dok = this.getDokument(zip.getName());
        if (dok == null && (dok = this.getInhaltsdaten(zip.getName())) == null) {
            dok = new Dokument(zip.getName());
            this.pruefvermerk.addDokument(dok);
        }
        try (ZipFile zipFile = ((ZipFile.Builder)((ZipFile.Builder)ZipFile.builder().setCharset("Cp437")).setFile(zip)).get();){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
                String filename = zipEntry.getName();
                if (zipEntry.isDirectory() || zipEntry.getName().contains("/") || zipEntry.getName().contains("\\")) continue;
                dok.addDokument(new Dokument(filename));
            }
        }
        catch (IOException e) {
            log.error("Unable to read ZIP content", (Throwable)e);
        }
    }

    private Dokument getInhaltsdaten(String filename) {
        for (Dokument dokument : this.pruefvermerk.getDokumenten()) {
            if (!dokument.getInhaltsdaten().equals(filename)) continue;
            return dokument;
        }
        return null;
    }

    private File getXJustizNachricht(List<File> list) {
        if (list == null) {
            return null;
        }
        for (File file : list) {
            if (!"xjustiz_nachricht.xml".equalsIgnoreCase(file.getName().toLowerCase())) continue;
            return file;
        }
        return null;
    }

    private void parseXJustizNachricht(File file) {
        if (file == null) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fis);
            Element root = doc.getDocumentElement();
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("//nachrichtenkopf/aktenzeichen.absender/text()");
            String value = (String)expr.evaluate(root.getOwnerDocument(), XPathConstants.STRING);
            if (value != null && !value.isEmpty()) {
                this.pruefvermerk.getNachricht().setAbsenderAktenzeichen(value);
            }
            if ((value = (String)(expr = xpath.compile("//nachrichtenkopf/aktenzeichen.empfaenger/text()")).evaluate(root.getOwnerDocument(), XPathConstants.STRING)) != null && !value.isEmpty()) {
                this.pruefvermerk.getNachricht().setEmpfaengerAktenzeichen(value);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    private File getDeMailFile(List<File> list) {
        for (File file : list) {
            if (!"De_Mail_Pruefprotokoll.xml".equalsIgnoreCase(file.getName().toLowerCase())) continue;
            return file;
        }
        return null;
    }

    private void parseDeMailFile(File file) {
        if (file == null) {
            return;
        }
        Visitenkarte absender = new Visitenkarte();
        try {
            String deMailMessageId;
            String deMailSender;
            String displaynameOfSender;
            String eingangszeitpunkt;
            Document doc = XML.fromStream(file);
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("/protokoll/x-de-mail-authoritative/text()");
            String authoritative = (String)expr.evaluate(doc, XPathConstants.STRING);
            if (authoritative != null) {
                this.pruefvermerk.setDeMailMitAbsenderbestaetigung("JA".equalsIgnoreCase(authoritative));
            }
            if ((eingangszeitpunkt = (String)(expr = xpath.compile("/protokoll/date/text()")).evaluate(doc, XPathConstants.STRING)) != null) {
                Date date = new SimpleDateFormat(RFC_822_DE_MAIL_DATE_FORMAT).parse(eingangszeitpunkt);
                this.pruefvermerk.setEingangszeitpunkt(date);
            }
            if ((displaynameOfSender = (String)(expr = xpath.compile("/protokoll/displayname-of-sender/text()")).evaluate(doc, XPathConstants.STRING)) != null && !displaynameOfSender.isEmpty()) {
                absender.setName(displaynameOfSender);
            }
            if ((deMailSender = (String)(expr = xpath.compile("/protokoll/x-de-mail-sender/text()")).evaluate(doc, XPathConstants.STRING)) != null && !deMailSender.isEmpty()) {
                String name = absender.getName();
                absender.setName((String)(name != null ? deMailSender + ", " + name : deMailSender));
            }
            if ((deMailMessageId = (String)(expr = xpath.compile("/protokoll/x-de-mail-message-id/text()")).evaluate(doc, XPathConstants.STRING)) != null) {
                this.pruefvermerk.setNachrichtenkennzeichen(deMailMessageId);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        this.pruefvermerk.setAbsender(absender);
    }

    private boolean shouldIgnore(String filename) {
        return this.pruefvermerk.isDeMailNachricht() && ignoreList.contains(filename.toLowerCase());
    }

    private Dokument getDokument(String filename) {
        for (Dokument dokument : this.pruefvermerk.getDokumenten()) {
            if (!dokument.getDateiName().equals(filename)) continue;
            return dokument;
        }
        return null;
    }

    private void setXMPMetadata(File file) {
        try (PDDocument doc = PDDocument.load((File)file);){
            XMPMetadata xmp = XMPMetadata.createXMPMetadata();
            PDDocumentCatalog catalog = doc.getDocumentCatalog();
            catalog.setLanguage("German");
            catalog.setViewerPreferences(new PDViewerPreferences(new COSDictionary()));
            catalog.getViewerPreferences().setDisplayDocTitle(true);
            catalog.getCOSObject().setString(COSName.LANG, "DE");
            String pdfaSchema = "pdfaSchema";
            String pdfaProperty = "pdfaProperty";
            String pdfuaid = "pdfuaid";
            String pdfaid = "pdfaid";
            xmp.createAndAddPDFAExtensionSchemaWithDefaultNS();
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/schema#", "pdfaSchema");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/property#", "pdfaProperty");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/id/", "pdfaid");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfua/ns/id/", "pdfuaid");
            XMPSchema uaSchema = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaSchema", "pdfaSchema", "pdfaSchema");
            uaSchema.setTextPropertyValue("schema", "PDF/UA UA ID Schema");
            uaSchema.setTextPropertyValue("namespaceURI", "http://www.aiim.org/pdfua/ns/id/");
            uaSchema.setTextPropertyValue("prefix", "pdfuaid");
            XMPSchema uaProp = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaProperty", "pdfaProperty", "pdfaProperty");
            uaProp.setTextPropertyValue("name", "part");
            uaProp.setTextPropertyValue("valueType", "Integer");
            uaProp.setTextPropertyValue("category", "internal");
            uaProp.setTextPropertyValue("description", "Part of PDF/UA standard");
            uaSchema.addUnqualifiedSequenceValue("property", (AbstractField)uaProp);
            xmp.getPDFExtensionSchema().addBagValue("schemas", (AbstractField)uaSchema);
            PDFAIdentificationSchema id = xmp.createAndAddPDFAIdentificationSchema();
            id.setPart(Integer.valueOf(2));
            id.setConformance("A");
            xmp.getPDFExtensionSchema().setPrefix("pdfuaid");
            xmp.getPDFExtensionSchema().setTextPropertyValue("part", "1");
            String title = res.getString("title");
            DublinCoreSchema dc = xmp.createAndAddDublinCoreSchema();
            dc.setTitle(title);
            dc.addCreator(res.getString("application"));
            dc.addDate(Calendar.getInstance());
            dc.setFormat("application/pdf");
            Calendar cal = Calendar.getInstance();
            PDDocumentInformation info = doc.getDocumentInformation();
            info.setCreationDate(cal);
            info.setModificationDate(cal);
            info.setAuthor(res.getString("application"));
            info.setProducer(res.getString("creator"));
            info.setCreator(res.getString("application"));
            info.setTitle(title);
            info.setSubject(title);
            XmpSerializer serializer = new XmpSerializer();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                serializer.serialize(xmp, (OutputStream)baos, true);
                PDMetadata metadata = new PDMetadata(doc);
                metadata.importXMPMetadata(baos.toByteArray());
                catalog.setMetadata(metadata);
                doc.save(file);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    private File getSignedData(CAdESSignatureValidationResult cades, PruefvermerkParameter controller) {
        List contentNames = cades.getContentNames();
        if (contentNames == null) {
            return null;
        }
        Iterator iterator = contentNames.iterator();
        if (iterator.hasNext()) {
            String filename = (String)iterator.next();
            File file = this.getAttachmentAsFile(filename, controller);
            if (file != null && file.exists()) {
                return file;
            }
            return new File(filename);
        }
        return null;
    }

    private void checkNotReachable(Dokument dokument, SignatureValidationResult signatureValidationResult) {
        PublicKeyCertificateValidationResult svr = signatureValidationResult.getSigningCertificateValidationResult();
        if (svr == null) {
            return;
        }
        String cvsURL = svr.getCvsURL();
        if (cvsURL == null || cvsURL.trim().isEmpty()) {
            dokument.setPruefergebnisCode(PruefergebnisCode.pruefung_unbestimmt);
            return;
        }
        List list = signatureValidationResult.getOverallResult(true).getMessages();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ValidationMessageCode msg : list) {
            log.info(msg.getMessageCode());
            if ("cvs_signature_broken".equals(msg.getMessageCode())) {
                dokument.setPruefergebnisCode(PruefergebnisCode.pruefung_unbestimmt);
            }
            if (!"revocation_values_not_found".equals(msg.getMessageCode()) && !"revocation_values_not_found_only_ocsp".equals(msg.getMessageCode())) continue;
            dokument.setPruefergebnisCode(PruefergebnisCode.pruefung_unbestimmt);
        }
    }

    private List<Dokument> deduplicate(Stream<Dokument> doks) {
        return doks.collect(Collectors.groupingBy(d -> d.getInhaltsdaten().toLowerCase())).values().stream().map(this::merge).sorted(Comparator.comparing(Dokument::getDateiName)).collect(Collectors.toList());
    }

    private Dokument merge(List<Dokument> documents) {
        Dokument doc = documents.get(0);
        if (documents.size() == 1) {
            return doc;
        }
        documents.stream().map(Dokument::getSignaturList).flatMap(Collection::stream).forEach(doc::addSigner);
        return doc;
    }

    @Generated
    public Pruefvermerk getPruefvermerk() {
        return this.pruefvermerk;
    }

    static {
        ignoreList.add("de-mail.eml");
        ignoreList.add("demail.txt");
        ignoreList.add("smime.p7m");
        ignoreList.add("de_mail_pruefprotokoll.xml");
        ignoreList.add("de_mail_pruefprotokoll.pdf");
    }
}

