/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.pruefvermerk;

import de.governikus.gcf.csl.pruefvermerk.ContainerSignatur;
import de.governikus.gcf.csl.pruefvermerk.Dokument;
import de.governikus.gcf.csl.pruefvermerk.Nachricht;
import de.governikus.gcf.csl.pruefvermerk.UebermittlungswegUtil;
import de.governikus.gcf.csl.pruefvermerk.Visitenkarte;
import de.governikus.gcf.csl.vhn.Uebermittlungsweg;
import de.governikus.gcf.csl.xml.XML;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement(name="Pruefvermerk")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"erstellungszeitpunkt", "uebermittlungsweg", "eingangszeitpunkt", "nachrichtenkennzeichen", "nachricht", "absender", "empfaenger", "containerSignatur", "dokumenten", "nurImVHN"})
public class Pruefvermerk {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Pruefvermerk.class);
    @XmlAttribute(name="pruefvermerkVersion")
    private String version = "1";
    @XmlElement(name="Erstellungszeitpunkt")
    private String erstellungszeitpunkt;
    @XmlElement(name="Eingangszeitpunkt")
    private String eingangszeitpunkt;
    @XmlElement(name="Nachrichtenkennzeichen")
    private String nachrichtenkennzeichen;
    @XmlElement(name="Nachricht")
    private Nachricht nachricht;
    @XmlElement(name="Absender")
    private Visitenkarte absender;
    @XmlElement(name="Empfaenger")
    private Visitenkarte empfaenger;
    @XmlElement(name="Dokument")
    private List<Dokument> dokumenten = new ArrayList<Dokument>();
    @XmlElement(name="ContainerSignatur")
    private ContainerSignatur containerSignatur;
    @XmlTransient
    private Uebermittlungsweg uebermittlungsweg;
    @XmlTransient
    private boolean deMailMitAbsenderbestaetigung = false;
    @XmlElement(name="nurImVHN")
    private Boolean nurImVHN = null;
    @XmlTransient
    private List<String> nichtImVHN = Collections.emptyList();

    public void addDokument(Dokument dokument) {
        if (this.nichtImVHN.contains(dokument.getDateiName())) {
            dokument.setNichtImVHN(Boolean.TRUE);
        }
        if (!this.checkDuplicate(dokument)) {
            this.dokumenten.forEach(d -> {
                if (d.getInhaltsdaten().equals(dokument.getInhaltsdaten())) {
                    dokument.getSignaturList().forEach(d::addSigner);
                }
            });
        } else {
            this.dokumenten.add(dokument);
        }
        Collections.sort(this.dokumenten);
    }

    public void addDokumentIntoZip(Dokument zipDokument, Dokument dokument) {
        for (Dokument d : this.dokumenten) {
            if (!d.getDateiName().equals(zipDokument.getDateiName()) && !d.getInhaltsdaten().equals(zipDokument.getInhaltsdaten())) continue;
            d.addDokument(dokument);
            return;
        }
    }

    public void setNichtImVHN(String str) {
        if (str == null) {
            this.nichtImVHN = Collections.emptyList();
            return;
        }
        this.nichtImVHN = Collections.list(new StringTokenizer(str, ";", false)).stream().map(String.class::cast).toList();
    }

    @XmlElement(name="Uebermittlungsweg")
    public String getUebermittlungsweg() {
        if (this.uebermittlungsweg != null) {
            return this.uebermittlungsweg.getForPdfOrXml();
        }
        return "";
    }

    public void setErstellungszeitpunkt(Date erstellungszeitpunkt) {
        this.erstellungszeitpunkt = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss z").format(erstellungszeitpunkt);
    }

    public void setEingangszeitpunkt(String eingangszeitpunkt) {
        this.eingangszeitpunkt = eingangszeitpunkt;
    }

    public void setEingangszeitpunkt(Date eingangszeitpunkt) {
        this.eingangszeitpunkt = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss z").format(eingangszeitpunkt);
    }

    public Visitenkarte getAbsender() {
        return this.absender == null ? new Visitenkarte() : this.absender;
    }

    public Nachricht getNachricht() {
        return this.nachricht == null ? new Nachricht() : this.nachricht;
    }

    public String getNachrichtenkennzeichen() {
        return this.nachrichtenkennzeichen == null ? "" : this.nachrichtenkennzeichen;
    }

    public boolean isDeMailNachricht() {
        return UebermittlungswegUtil.isDeMail(this.uebermittlungsweg);
    }

    public String getDeMailMitAbsenderbestaetigung() {
        return this.deMailMitAbsenderbestaetigung ? "Ja" : "Nein";
    }

    public Document getDocument() {
        try {
            Document document = XML.createDocument();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Pruefvermerk.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)this, (Node)document);
            return document;
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return null;
        }
    }

    public static String getXML(Object object) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Pruefvermerk.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter writer = new StringWriter();
        m.marshal(object, (Writer)writer);
        return writer.toString();
    }

    public static void setXML(Object object, File file) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Pruefvermerk.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)"pruefvermerk.xsd");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream fos = new FileOutputStream(file);
        m.marshal(object, (OutputStream)fos);
        fos.close();
    }

    private boolean checkDuplicate(Dokument dok) {
        for (Dokument d : this.dokumenten) {
            if (!d.getDateiName().equals(dok.getDateiName())) continue;
            return false;
        }
        return true;
    }

    @Generated
    public String getErstellungszeitpunkt() {
        return this.erstellungszeitpunkt;
    }

    @Generated
    public String getEingangszeitpunkt() {
        return this.eingangszeitpunkt;
    }

    @Generated
    public void setNachrichtenkennzeichen(String nachrichtenkennzeichen) {
        this.nachrichtenkennzeichen = nachrichtenkennzeichen;
    }

    @Generated
    public void setNachricht(Nachricht nachricht) {
        this.nachricht = nachricht;
    }

    @Generated
    public void setAbsender(Visitenkarte absender) {
        this.absender = absender;
    }

    @Generated
    public void setEmpfaenger(Visitenkarte empfaenger) {
        this.empfaenger = empfaenger;
    }

    @Generated
    public Visitenkarte getEmpfaenger() {
        return this.empfaenger;
    }

    @Generated
    public List<Dokument> getDokumenten() {
        return this.dokumenten;
    }

    @Generated
    public void setDokumenten(List<Dokument> dokumenten) {
        this.dokumenten = dokumenten;
    }

    @Generated
    public void setContainerSignatur(ContainerSignatur containerSignatur) {
        this.containerSignatur = containerSignatur;
    }

    @Generated
    public ContainerSignatur getContainerSignatur() {
        return this.containerSignatur;
    }

    @Generated
    public void setUebermittlungsweg(Uebermittlungsweg uebermittlungsweg) {
        this.uebermittlungsweg = uebermittlungsweg;
    }

    @Generated
    public void setDeMailMitAbsenderbestaetigung(boolean deMailMitAbsenderbestaetigung) {
        this.deMailMitAbsenderbestaetigung = deMailMitAbsenderbestaetigung;
    }

    @Generated
    public Boolean getNurImVHN() {
        return this.nurImVHN;
    }

    @Generated
    public void setNurImVHN(Boolean nurImVHN) {
        this.nurImVHN = nurImVHN;
    }
}

