/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.pruefvermerk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;

public class JARResourceResolver
implements ResourceResolver {
    public Resource getResource(URI uri) throws IOException {
        InputStream resourceStream;
        String path = uri.getPath();
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if ((resourceStream = JARResourceResolver.getResourceAsStream(path)) == null) {
            throw new IOException("cannot load Apache FOP resource '" + uri.toString() + "'!");
        }
        return new Resource(resourceStream);
    }

    public OutputStream getOutputStream(URI uri) throws IOException {
        throw new IOException("cannot write a resource for '" + uri.toString() + "'!");
    }

    public static InputStream getResourceAsStream(String resourcePath) {
        InputStream resourceStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            resourceStream = classLoader.getResourceAsStream(resourcePath);
        }
        if (resourceStream == null) {
            resourceStream = InputStream.class.getResourceAsStream(resourcePath);
        }
        return resourceStream;
    }
}

