/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.pruefvermerk;

import de.governikus.gcf.csl.Utils;
import de.governikus.gcf.csl.pruefvermerk.Pruefergebnis;
import de.governikus.gcf.csl.pruefvermerk.PruefergebnisCode;
import de.governikus.gcf.csl.pruefvermerk.Signatur;
import de.governikus.gcf.csl.pruefvermerk.Signaturformat;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.io.FilenameUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"anzeigename", "format", "nichtImVHN", "signaturList", "innereDokumentList"})
public class Dokument
implements Comparable<Dokument> {
    @XmlTransient
    private String inhaltsdaten;
    @XmlElement(name="Format")
    private String format;
    @XmlElement(name="nichtImVHN")
    private Boolean nichtImVHN = null;
    @XmlTransient
    private Set<Signatur> signaturList = new HashSet<Signatur>();
    @XmlTransient
    private Boolean aenderungNachSignaturanbringung = null;
    @XmlTransient
    PruefergebnisCode pruefergebnisCode = null;
    @XmlTransient
    private String dateiName;
    @XmlTransient
    private Signaturformat signaturformat;
    @XmlElement(name="inneresDokument")
    private List<Dokument> innereDokumentList = new ArrayList<Dokument>();
    @XmlTransient
    private boolean istInnereDokument = false;
    static FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
    static Font font = new Font("Times New Roman", 0, 10);

    public Dokument() {
    }

    public Dokument(String dateiName) {
        this.inhaltsdaten = dateiName;
        this.dateiName = Utils.getUTF8Encoded(dateiName);
        this.format = FilenameUtils.getExtension((String)this.dateiName);
    }

    public String getInhaltsdaten() {
        return this.inhaltsdaten == null ? this.dateiName : this.inhaltsdaten;
    }

    @XmlElement(name="DateiName")
    public String getAnzeigename() {
        return Dokument.addWhiteSpaces(this.getInhaltsdaten(), this.istInnereDokument ? 120 : 131, true);
    }

    @XmlElement(name="Signatur")
    public List<Signatur> getSignaturList() {
        ArrayList<Signatur> result = new ArrayList<Signatur>();
        for (Signatur signatur : this.signaturList) {
            if (!signatur.isQualifiziert()) continue;
            if ("Containersignatur".equals(signatur.getQualifiziertNachERVB())) {
                Signatur s = new Signatur();
                s.setQualifiziertNachERVB("Containersignatur");
                result.add(s);
                return result;
            }
            Pruefergebnis pruefergebnis = signatur.getPruefergebnis();
            pruefergebnis.setAenderungNachSignaturanbringung(this.aenderungNachSignaturanbringung);
            if (this.pruefergebnisCode != null) {
                pruefergebnis.setGueltigkeitspruefung(this.pruefergebnisCode);
                pruefergebnis.setIntegritaetspruefung(this.pruefergebnisCode);
            }
            result.add(signatur);
        }
        return result;
    }

    public String getFormat() {
        return this.format == null ? "" : this.format;
    }

    public void setPruefergebnisCode(PruefergebnisCode pruefergebnisCode) {
        this.pruefergebnisCode = pruefergebnisCode;
    }

    public void setAenderungNachSignaturanbringung(boolean aenderungNachSignaturanbringung) {
        this.aenderungNachSignaturanbringung = aenderungNachSignaturanbringung;
    }

    public void addSigner(Signatur signer) {
        this.signaturList.add(signer);
    }

    public void addDokument(Dokument dokument) {
        if (this.checkDuplicate(dokument)) {
            dokument.istInnereDokument = true;
            this.innereDokumentList.add(dokument);
            Collections.sort(this.innereDokumentList);
        }
    }

    public List<Dokument> getInnereDokumentList() {
        return this.innereDokumentList;
    }

    public void setInnereDokumentList(List<Dokument> innereDokumentList) {
        this.innereDokumentList = innereDokumentList;
    }

    public void setSignaturformat(Signaturformat signaturformat) {
        this.signaturformat = signaturformat;
    }

    public String getDateiName() {
        return this.dateiName == null ? "" : this.dateiName;
    }

    public void setDateiName(String dateiName) {
        this.inhaltsdaten = this.dateiName = Utils.getUTF8Encoded(dateiName);
        this.format = FilenameUtils.getExtension((String)this.dateiName);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setInhaltsdaten(File file) {
        this.inhaltsdaten = file.getName();
        this.format = FilenameUtils.getExtension((String)file.getName());
    }

    @XmlTransient
    public boolean isQualifiziertNachERVB() {
        if (this.signaturformat == Signaturformat.PADES) {
            return true;
        }
        if (this.signaturformat == Signaturformat.CADES) {
            return !this.dateiName.equals(this.inhaltsdaten);
        }
        return false;
    }

    protected void update(Dokument d) {
        this.dateiName = d.dateiName;
        this.inhaltsdaten = d.inhaltsdaten;
        this.format = d.format;
        this.signaturformat = d.signaturformat;
        this.signaturList = d.signaturList;
    }

    public static String addWhiteSpaces(String str, int length, boolean unsichtbar) {
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        StringBuilder result = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String s;
            String token = tokenizer.nextToken();
            if (Dokument.getTextWidth(token) <= length) {
                result.append(token).append(" ");
                continue;
            }
            StringBuilder subs = new StringBuilder();
            for (int index = 0; index < token.length(); index += s.length()) {
                s = "";
                int count = 0;
                while (Dokument.getTextWidth(s) < length && index + count < token.length()) {
                    s = token.substring(index, index + ++count);
                }
                subs.append(s).append(unsichtbar ? "\u200b" : " ");
            }
            result.append((CharSequence)subs).append(unsichtbar ? " " : "");
        }
        return Utils.getUTF8Encoded(result.toString().trim());
    }

    public static int getTextWidth(String text) {
        return (int)font.getStringBounds(text, frc).getWidth();
    }

    private boolean checkDuplicate(Dokument dok) {
        for (Dokument d : this.innereDokumentList) {
            if (!d.getDateiName().equals(dok.getDateiName())) continue;
            return false;
        }
        return true;
    }

    public void setNichtImVHN(Boolean nichtImVHN) {
        this.nichtImVHN = nichtImVHN;
    }

    @Override
    public int compareTo(Dokument o) {
        return this.getDateiName().toLowerCase().compareTo(o.getDateiName().toLowerCase());
    }
}

