/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.nachricht;

import de.governikus.gcf.csl.html.HtmlStringFilter;
import de.governikus.gcf.csl.nachricht.Nachricht;
import de.governikus.gcf.csl.pruefvermerk.JARResourceResolver;
import de.governikus.gcf.csl.pruefvermerk.PruefvermerkReport;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.type.AbstractField;
import org.apache.xmpbox.xml.XmpSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NachrichtReport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NachrichtReport.class);
    private static final ResourceBundle res = ResourceBundle.getBundle(NachrichtReport.class.getName());

    private NachrichtReport() {
    }

    public static String getString(String value) {
        return value == null ? "" : res.getString(value);
    }

    public static void setPdf(Nachricht nachricht, File file) {
        log.info("");
        String source = "/de/governikus/gcf/csl/nachricht/nachricht_pdf.xsl";
        try (InputStream xsltFile = Nachricht.class.getResourceAsStream(source);){
            String str = Nachricht.getXML(nachricht);
            StreamSource xmlSource = new StreamSource(new StringReader(str));
            FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
            String fopBaseConfig = "fop_conf.xml";
            try (InputStream cfgStream = PruefvermerkReport.class.getResourceAsStream(fopBaseConfig);){
                FopConfParser fopConfParser = new FopConfParser(cfgStream, new URI("jarprotocol:/"), (ResourceResolver)new JARResourceResolver());
                FopFactoryBuilder fopFactoryBuilder = fopConfParser.getFopFactoryBuilder();
                fopFactory = fopFactoryBuilder.build();
            }
            catch (Exception ex) {
                throw new Exception("Cannot load or parse FOP configuration from '" + fopBaseConfig + "'!", ex);
            }
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            foUserAgent.setAccessibility(true);
            try (FileOutputStream out = new FileOutputStream(file);){
                Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
                TransformerFactory factory = TransformerFactory.newInstance();
                SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)factory);
                Transformer transformer = factory.newTransformer(new StreamSource(xsltFile));
                SAXResult r = new SAXResult(fop.getDefaultHandler());
                transformer.transform(xmlSource, r);
            }
            NachrichtReport.setXMPMetadata(file, nachricht);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public static void setHtml(Nachricht nachricht, File htmlFile) {
        log.info("");
        try {
            String str = Nachricht.getXML(nachricht);
            StreamSource xmlSource = new StreamSource(new StringReader(str));
            InputStream xslStream = NachrichtReport.class.getResourceAsStream("/de/governikus/gcf/csl/nachricht/nachricht_html.xsl");
            StringWriter htmlOut = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)tf);
            Transformer transformer = tf.newTransformer(new StreamSource(xslStream));
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlSource, new StreamResult(htmlOut));
            htmlOut.close();
            String html = HtmlStringFilter.doFilter(htmlOut.toString());
            try (BufferedWriter bw = Files.newBufferedWriter(htmlFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bw.write(html);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    private static void setXMPMetadata(File file, Nachricht nachricht) {
        try (PDDocument doc = PDDocument.load((File)file);){
            XMPMetadata xmp = XMPMetadata.createXMPMetadata();
            PDDocumentCatalog catalog = doc.getDocumentCatalog();
            catalog.setLanguage("German");
            catalog.setViewerPreferences(new PDViewerPreferences(new COSDictionary()));
            catalog.getViewerPreferences().setDisplayDocTitle(true);
            catalog.getCOSObject().setString(COSName.LANG, "DE");
            String pdfaSchema = "pdfaSchema";
            String pdfaProperty = "pdfaProperty";
            String pdfuaid = "pdfuaid";
            String pdfaid = "pdfaid";
            xmp.createAndAddPDFAExtensionSchemaWithDefaultNS();
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/schema#", "pdfaSchema");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/property#", "pdfaProperty");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfa/ns/id/", "pdfaid");
            xmp.getPDFExtensionSchema().addNamespace("http://www.aiim.org/pdfua/ns/id/", "pdfuaid");
            XMPSchema uaSchema = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaSchema", "pdfaSchema", "pdfaSchema");
            uaSchema.setTextPropertyValue("schema", "PDF/UA UA ID Schema");
            uaSchema.setTextPropertyValue("namespaceURI", "http://www.aiim.org/pdfua/ns/id/");
            uaSchema.setTextPropertyValue("prefix", "pdfuaid");
            XMPSchema uaProp = new XMPSchema(XMPMetadata.createXMPMetadata(), "pdfaProperty", "pdfaProperty", "pdfaProperty");
            uaProp.setTextPropertyValue("name", "part");
            uaProp.setTextPropertyValue("valueType", "Integer");
            uaProp.setTextPropertyValue("category", "internal");
            uaProp.setTextPropertyValue("description", "Part of PDF/UA standard");
            uaSchema.addUnqualifiedSequenceValue("property", (AbstractField)uaProp);
            xmp.getPDFExtensionSchema().addBagValue("schemas", (AbstractField)uaSchema);
            PDFAIdentificationSchema id = xmp.createAndAddPDFAIdentificationSchema();
            id.setPart(Integer.valueOf(2));
            id.setConformance("A");
            xmp.getPDFExtensionSchema().setPrefix("pdfuaid");
            xmp.getPDFExtensionSchema().setTextPropertyValue("part", "1");
            String title = res.getString("title");
            DublinCoreSchema dc = xmp.createAndAddDublinCoreSchema();
            dc.setTitle(title);
            dc.addCreator(res.getString("creator"));
            dc.addDate(Calendar.getInstance());
            Calendar cal = Calendar.getInstance();
            PDDocumentInformation info = doc.getDocumentInformation();
            info.setCreationDate(cal);
            info.setModificationDate(cal);
            info.setAuthor(res.getString("creator"));
            info.setProducer(res.getString("creator"));
            info.setCreator(res.getString("creator"));
            info.setTitle(title);
            info.setSubject(title);
            info.setCustomMetadataValue("Betreff", nachricht.getBetreff());
            info.setCustomMetadataValue("Text", nachricht.getText());
            XmpSerializer serializer = new XmpSerializer();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                serializer.serialize(xmp, (OutputStream)baos, true);
                PDMetadata metadata = new PDMetadata(doc);
                metadata.importXMPMetadata(baos.toByteArray());
                catalog.setMetadata(metadata);
                doc.save(file);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }
}

