/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl.html;

import java.util.regex.Pattern;

public final class HtmlStringFilter {
    private static final Pattern[] HTML_PATTERNS = new Pattern[]{Pattern.compile("<script>(.*?)</script>", 2), Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42), Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42), Pattern.compile("</script>", 2), Pattern.compile("<script(.*?)>", 42), Pattern.compile("eval\\((.*?)\\)", 42), Pattern.compile("expression\\((.*?)\\)", 42), Pattern.compile("javascript:", 2), Pattern.compile("vbscript:", 2), Pattern.compile("base64", 2), Pattern.compile("onload(.*?)=", 42)};

    private HtmlStringFilter() {
    }

    public static String doFilter(String value) {
        if (value == null) {
            return null;
        }
        value = value.replaceAll("\u0000", "");
        for (Pattern scriptPattern : HTML_PATTERNS) {
            value = scriptPattern.matcher(value).replaceAll("");
        }
        return value;
    }
}

