/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl;

import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.validate.svp.OSCIContainerData;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.OSCIMessage;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String[] FILE_EXTENSION_PKCS7 = new String[]{"p7", "p7s", "p7m", "pkcs7"};

    private Utils() {
    }

    public static boolean isCMSFile(String value) {
        if (value == null || "".equals(value)) {
            return false;
        }
        value = value.toLowerCase(Locale.getDefault());
        int index = value.lastIndexOf(46) + 1;
        CharSequence suffix = value.subSequence(index, value.length());
        for (String s : FILE_EXTENSION_PKCS7) {
            if (!s.contentEquals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPDFFile(String name) {
        return name.toLowerCase().endsWith(".pdf");
    }

    public static OSCIMessage getOSCIMessage(ValidateResponse response) {
        de.governikus.csl.uom.validate.ObjectValidationResult obj = response.getDocumentValidationResult();
        if (!(obj instanceof OSCIDocumentValidationResult)) {
            return null;
        }
        OSCIDocumentValidationResult messageResultDoc = (OSCIDocumentValidationResult)obj;
        OSCIContainerData containerData = messageResultDoc.getOSCIContainerData();
        if (!(containerData instanceof OSCIMessage)) {
            return null;
        }
        return (OSCIMessage)containerData;
    }

    public static List<OSCIDocumentValidationResult> getOSCIDocumentValidationResult(ValidateResponse response) {
        ArrayList<OSCIDocumentValidationResult> result = new ArrayList<OSCIDocumentValidationResult>();
        de.governikus.csl.uom.validate.ObjectValidationResult obj = response.getDocumentValidationResult();
        if (!(obj instanceof OSCIDocumentValidationResult)) {
            return result;
        }
        OSCIDocumentValidationResult messageResultDoc = (OSCIDocumentValidationResult)obj;
        for (ObjectValidationResult ovr : messageResultDoc.getResultsForContainedObjects()) {
            result.add((OSCIDocumentValidationResult)ovr);
        }
        return result;
    }

    public static MajorTotalResult getOSCIDocumentMajorTotalResult(ValidateResponse response) {
        MajorTotalResult totalResult = MajorTotalResult.TOTAL_PASSED;
        OSCIDocumentValidationResult messageResultDoc = (OSCIDocumentValidationResult)response.getDocumentValidationResult();
        CumulatedValidationResult overallResult = messageResultDoc.getOverallResult(true);
        if (overallResult != null) {
            log.info("MajorTotalResult for osci: {}", (Object)overallResult.getMajor());
            totalResult = overallResult.getMajor();
        }
        List<OSCIDocumentValidationResult> list = Utils.getOSCIDocumentValidationResult(response);
        for (OSCIDocumentValidationResult coco : list) {
            List objectValidationResult = coco.getIncludedFileValidationResults();
            if (objectValidationResult == null) continue;
            log.debug("parsing coco {}", (Object)coco.getObjectName());
            totalResult = Utils.checkObjectValidationResults(totalResult, objectValidationResult);
        }
        return totalResult;
    }

    public static List<X509CertificateImpl> getSignatureCertificate(OSCIDocumentValidationResult docResult) {
        ArrayList<X509CertificateImpl> result = new ArrayList<X509CertificateImpl>();
        List objectValidationResult = docResult.getIncludedFileValidationResults();
        if (objectValidationResult == null) {
            return result;
        }
        for (ObjectValidationResult ovr : objectValidationResult) {
            if (ovr.getSignatureValidationResults().isEmpty()) continue;
            log.info("file: {} -> is signed", (Object)ovr.getObjectName());
            List svr = ovr.getSignatureValidationResults();
            for (SignatureValidationResult signatureValidationResult : svr) {
                PublicKeyCertificateValidationResult scvr = signatureValidationResult.getSigningCertificateValidationResult();
                if (scvr == null) continue;
                result.add(scvr.getCert());
            }
        }
        return result;
    }

    public static File certificateToFile(FlatCertificate cert, File folder) {
        File tmp = new File(folder.getPath(), "tmpCert.cer");
        try (FileOutputStream fos = new FileOutputStream(tmp);){
            fos.write(cert.getEncoded());
            fos.flush();
        }
        catch (IOException e) {
            log.error("Unable to write certificate to file", (Throwable)e);
        }
        return tmp;
    }

    private static MajorTotalResult checkObjectValidationResults(MajorTotalResult totalResult, List<ObjectValidationResult> objectValidationResult) {
        for (ObjectValidationResult content : objectValidationResult) {
            log.debug("parsing content {}", (Object)content.getObjectName());
            List files = content.getIncludedFileValidationResults();
            if (files != null && !files.isEmpty()) {
                for (ObjectValidationResult file : files) {
                    log.debug("parsing file {}", (Object)file.getObjectName());
                    if (file.getOverallResult(true) == null) continue;
                    MajorTotalResult state = file.getOverallResult(true).getMajor();
                    log.info("signed file: {} -> state: {}", (Object)file.getObjectName(), (Object)state);
                    totalResult = MajorTotalResult.max((MajorTotalResult)totalResult, (MajorTotalResult)state);
                }
            }
            if (content.getOverallResult(true) == null) continue;
            MajorTotalResult state = content.getOverallResult(true).getMajor();
            log.info("signed content: {} -> state: {}", (Object)content.getObjectName(), (Object)state);
            totalResult = MajorTotalResult.max((MajorTotalResult)totalResult, (MajorTotalResult)content.getOverallResult(true).getMajor());
        }
        return totalResult;
    }

    public static String getUTF8Encoded(String input) {
        if (input == null) {
            return "";
        }
        CharBuffer cb = CharBuffer.wrap(input);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(cb);
        cb = StandardCharsets.UTF_8.decode(bb);
        return cb.toString();
    }
}

