/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.SignatureValidationResult;
import de.governikus.gcf.csl.Utils;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningCertificateValidationUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigningCertificateValidationUtil.class);

    private SigningCertificateValidationUtil() {
    }

    public static List<Certificate> getSignCertFromSignedAttachments(ValidateResponse response) throws CertificateEncodingException, ParseException {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        List<OSCIDocumentValidationResult> list = Utils.getOSCIDocumentValidationResult(response);
        for (OSCIDocumentValidationResult coco : list) {
            List objectValidationResult = coco.getIncludedFileValidationResults();
            if (objectValidationResult == null) continue;
            log.debug("parsing coco {}", (Object)coco.getObjectName());
            for (ObjectValidationResult attachment : objectValidationResult) {
                List files;
                log.debug("dateiname:  {} - dateityp:  {}", (Object)attachment.getObjectName(), (Object)attachment.getObjectTypeID());
                if (attachment instanceof PAdESDocumentValidationResult) {
                    PAdESDocumentValidationResult validationResult = (PAdESDocumentValidationResult)attachment;
                    SigningCertificateValidationUtil.getCertsFromPAdES(validationResult, result);
                    continue;
                }
                List signatureValidationResults = attachment.getSignatureValidationResults();
                if (signatureValidationResults != null && !signatureValidationResults.isEmpty()) {
                    for (SignatureValidationResult signatureValidationResult : signatureValidationResults) {
                        PublicKeyCertificateValidationResult vr = signatureValidationResult.getSigningCertificateValidationResult();
                        if (vr == null) continue;
                        X509CertificateImpl c = vr.getCert();
                        result.add(new Certificate((Source)new BSource(c.getEncoded())));
                    }
                }
                if ((files = attachment.getIncludedFileValidationResults()) == null) continue;
                for (ObjectValidationResult file : files) {
                    log.debug("dateiname: {} - dateityp:  {}", (Object)file.getObjectName(), (Object)file.getObjectTypeID());
                    if (file instanceof PAdESDocumentValidationResult) {
                        PAdESDocumentValidationResult validationResult = (PAdESDocumentValidationResult)file;
                        SigningCertificateValidationUtil.getCertsFromPAdES(validationResult, result);
                        continue;
                    }
                    signatureValidationResults = file.getSignatureValidationResults();
                    if (signatureValidationResults == null || signatureValidationResults.isEmpty()) continue;
                    for (SignatureValidationResult signatureValidationResult : signatureValidationResults) {
                        PublicKeyCertificateValidationResult scvr = signatureValidationResult.getSigningCertificateValidationResult();
                        if (scvr == null) continue;
                        X509CertificateImpl c = scvr.getCert();
                        result.add(new Certificate((Source)new BSource(c.getEncoded())));
                    }
                }
            }
        }
        return result;
    }

    private static void getCertsFromPAdES(PAdESDocumentValidationResult pvr, List<Certificate> result) {
        List signatureValidationResults = pvr.getSignatureValidationResults();
        if (signatureValidationResults != null) {
            for (SignatureValidationResult svr : signatureValidationResults) {
                PublicKeyCertificateValidationResult scvr = svr.getSigningCertificateValidationResult();
                if (scvr == null || scvr.getCert() == null) continue;
                X509CertificateImpl c = scvr.getCert();
                try {
                    result.add(new Certificate((Source)new BSource(c.getEncoded())));
                }
                catch (ParseException | CertificateEncodingException e) {
                    log.error(e.getMessage());
                }
            }
        }
        List objectValidationResults = pvr.getResultsForContainedObjects();
        for (ObjectValidationResult objectValidationResult : objectValidationResults) {
            log.debug("ObjectName: {}", (Object)objectValidationResult.getObjectName());
            if (!(objectValidationResult instanceof PAdESDocumentValidationResult)) continue;
            PAdESDocumentValidationResult pAdESValidationResult = (PAdESDocumentValidationResult)objectValidationResult;
            SigningCertificateValidationUtil.getCertsFromPAdES(pAdESValidationResult, result);
        }
    }
}

