/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl;

import de.governikus.csl.uom.validate.commons.MajorTotalResult;

public enum MessageResult {
    UNKNOWN("unknown"),
    VALID("valid_gueltig"),
    UNDEFINED("undefined_undefiniert"),
    INVALID("invalid_ungueltig");

    public final String state;

    private MessageResult(String state) {
        this.state = state;
    }

    public String toString() {
        return this.state;
    }

    public static MessageResult keyForName(String name) {
        if (name == null) {
            return UNDEFINED;
        }
        for (MessageResult m : MessageResult.values()) {
            if (!m.state.equals(name)) continue;
            return m;
        }
        return UNKNOWN;
    }

    public static MessageResult getState(MajorTotalResult majorTotalResult) {
        if (majorTotalResult == MajorTotalResult.TOTAL_PASSED) {
            return VALID;
        }
        if (majorTotalResult == MajorTotalResult.TOTAL_FAILED) {
            return INVALID;
        }
        return UNDEFINED;
    }
}

