/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.gcf.csl;

import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.JX509Certificate;
import de.bos_bremen.ci.asn1.x509.Name;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateQualificationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateQualificationUtils.class);
    static final Set<Name> issuers = new HashSet<Name>();

    private CertificateQualificationUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isQualified(Certificate cert) {
        try {
            JX509Certificate c = new JX509Certificate(cert);
            byte[] qcStatementBytes = c.getExtensionValue(Extension.qCStatements.getId());
            if (null == qcStatementBytes) {
                return false;
            }
            DEROctetString oct = (DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(qcStatementBytes)).readObject();
            try (ASN1InputStream is = new ASN1InputStream(oct.getOctets());){
                ASN1Sequence qcStatements = (ASN1Sequence)is.readObject();
                Enumeration qcStatementEnum = qcStatements.getObjects();
                while (qcStatementEnum.hasMoreElements()) {
                    QCStatement qcStatement = QCStatement.getInstance(qcStatementEnum.nextElement());
                    ASN1ObjectIdentifier statementId = qcStatement.getStatementId();
                    log.info("statement Id: {}", (Object)statementId.getId());
                    if (QCStatement.id_etsi_qcs_QcCompliance.equals((ASN1Primitive)statementId)) {
                        log.info("ETSI Statement that the certificate is a Qualified Certificate = true");
                        boolean bl = true;
                        return bl;
                    }
                    if (!QCStatement.id_etsi_qcs_QcSSCD.equals((ASN1Primitive)statementId)) continue;
                    log.info("ETSI Statement claiming that the private key resides in a Signature Creation Device = true");
                }
                return false;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return false;
    }
}

