/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cvp.xml;

import de.governikus.csl.cvp.xml.TrackingResourceResolver;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CVPSignatureHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CVPSignatureHelper.class);
    private static final String XMLNS = "http://www.w3.org/2000/09/xmldsig#";
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private CVPSignatureHelper() {
        throw new IllegalStateException("Static utility class - no public contructor available!");
    }

    private static DocumentBuilder getDocumentBuilder() throws SAXException {
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            try {
                return dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException(ex);
            }
        }
    }

    public static boolean verify(byte[] sig, X509Certificate certificate) throws XMLSecurityException, SAXException, IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(sig);){
            boolean bl = CVPSignatureHelper.verify(is, certificate);
            return bl;
        }
    }

    public static boolean verifySilently(byte[] sig, X509Certificate certificate) {
        try {
            return CVPSignatureHelper.verify(sig, certificate);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean verify(InputStream is, X509Certificate certificate) throws XMLSecurityException, SAXException, IOException {
        Document document = CVPSignatureHelper.getDocumentBuilder().parse(is);
        return CVPSignatureHelper.verify(document, certificate);
    }

    public static boolean verify(Document document, X509Certificate certificate) throws XMLSecurityException, SAXException, IOException {
        log.debug("Verifying signature with signing certificate {}", (Object)certificate.getSubjectX500Principal().getName());
        Node signature = document.getElementsByTagNameNS(XMLNS, "Signature").item(0);
        XMLSignature xmlSignature = new XMLSignature((Element)signature, null);
        xmlSignature.addResourceResolver((ResourceResolverSpi)new TrackingResourceResolver());
        return xmlSignature.checkSignatureValue(certificate);
    }

    public static boolean verifySilently(InputStream is, X509Certificate certificate) {
        try {
            return CVPSignatureHelper.verify(is, certificate);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean verifySilently(Document document, X509Certificate certificate) {
        try {
            return CVPSignatureHelper.verify(document, certificate);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] sign(byte[] data, PrivateKey key, X509Certificate certificate) throws XMLSecurityException, SAXException, IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            byte[] byArray = CVPSignatureHelper.sign(is, key, certificate);
            return byArray;
        }
    }

    public static byte[] signSilently(byte[] data, PrivateKey key, X509Certificate certificate) throws XMLSecurityException, SAXException, IOException {
        try {
            return CVPSignatureHelper.sign(data, key, certificate);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] signSilently(Document document, PrivateKey key, X509Certificate certificate) {
        try {
            return CVPSignatureHelper.sign(document, key, certificate);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] sign(Document document, PrivateKey key, X509Certificate certificate) throws XMLSecurityException, SAXException, IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            log.debug("Sign data with signing certificate {}", (Object)certificate.getSubjectX500Principal().getName());
            XMLSignature xmlSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            document.getDocumentElement().insertBefore(xmlSignature.getElement(), document.getDocumentElement().getFirstChild());
            xmlSignature.addResourceResolver((ResourceResolverSpi)new TrackingResourceResolver());
            xmlSignature.addKeyInfo(certificate);
            Transforms transforms = new Transforms(document);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            xmlSignature.addDocument("", transforms);
            xmlSignature.sign((Key)key);
            XMLUtils.outputDOM((Node)document, (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static void sign(Document document, PrivateKey key, X509Certificate certificate, Consumer<byte[]> consumer) throws XMLSecurityException, SAXException, IOException {
        consumer.accept(CVPSignatureHelper.sign(document, key, certificate));
    }

    public static void signSilently(Document document, PrivateKey key, X509Certificate certificate, Consumer<byte[]> consumer) {
        try {
            CVPSignatureHelper.sign(document, key, certificate, consumer);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void sign(byte[] sig, PrivateKey key, X509Certificate certificate, Consumer<byte[]> consumer) throws XMLSecurityException, SAXException, IOException {
        consumer.accept(CVPSignatureHelper.sign(sig, key, certificate));
    }

    public static void signSilently(byte[] sig, PrivateKey key, X509Certificate certificate, Consumer<byte[]> consumer) {
        try {
            CVPSignatureHelper.sign(sig, key, certificate, consumer);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] sign(InputStream is, PrivateKey key, X509Certificate certificate) throws XMLSecurityException, SAXException, IOException {
        Document document = CVPSignatureHelper.getDocumentBuilder().parse(is);
        return CVPSignatureHelper.sign(document, key, certificate);
    }

    public static byte[] signSilenty(InputStream is, PrivateKey key, X509Certificate certificate) {
        try {
            return CVPSignatureHelper.sign(is, key, certificate);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void sign(InputStream is, PrivateKey key, X509Certificate certificate, Consumer<byte[]> consumer) throws XMLSecurityException, SAXException, IOException {
        consumer.accept(CVPSignatureHelper.sign(is, key, certificate));
    }

    public static void signSilently(InputStream is, PrivateKey key, X509Certificate certificate, Consumer<byte[]> consumer) {
        try {
            CVPSignatureHelper.sign(is, key, certificate, consumer);
        }
        catch (IOException | XMLSecurityException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
        dbf.setNamespaceAware(true);
    }
}

