/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.smime;

import de.governikus.csl.ades.AdESDataExtractor;
import de.governikus.csl.cades.CAdESDocument;
import de.governikus.csl.cades.CAdESPlugin;
import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.smime.SMIMEDocument;
import de.governikus.csl.smime.SMIMEParser;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.validate.svp.CAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.SMIMEDocumentValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.AbstractContainerDocumentPlugin;
import de.governikus.csl.validation.IncludedFileValidator;
import de.governikus.csl.validation.ObjectValidator;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.List;

@PluginType(id=Plugin.PluginID.VALIDATE_SMIME, type=ValidatePlugin.class)
public class SMIMEPlugin
extends AbstractContainerDocumentPlugin<SMIMEDocument, CMSSignature, SMIMEDocumentValidationResult, CAdESSignatureValidationResult, SignatureValidationContext> {
    private CAdESPlugin cadesPlugin;
    private static DataExtractor<? super SMIMEDocument, ? super SMIMEDocumentValidationResult> docDataExtractor;

    public SMIMEPlugin() {
        super(CMSSignature.class, SignatureValidationContext.class);
    }

    public SMIMEPlugin(CAdESPlugin cadesPlugin) {
        super(CMSSignature.class, SignatureValidationContext.class);
        this.cadesPlugin = cadesPlugin;
    }

    public SMIMEDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        SMIMEParser parser = new SMIMEParser(this.cadesPlugin, tempDataManager, this.configuration);
        SMIMEDocument docToValidate = null;
        try {
            docToValidate = parser.loadDocument(doc);
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document as S/MIME!", (Throwable)e);
        }
        return docToValidate;
    }

    public ObjectValidator getDocumentValidatorForContainedDocument(ObjectToValidate<?> content, IncludedFileValidator requestProcessor) {
        return this.cadesPlugin.getDocumentValidator((ObjectToValidate)((CAdESDocument)content), requestProcessor);
    }

    protected SMIMEDocumentValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        SMIMEDocumentValidationResult res = new SMIMEDocumentValidationResult();
        res.setObjectTypeID(this.getID());
        return res;
    }

    public SignatureValidationContext createContext(CMSSignature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    protected CAdESSignatureValidationResult createSignatureValidationResultStructure() {
        return new CAdESSignatureValidationResult();
    }

    public synchronized DataExtractor<? super SMIMEDocument, ? super SMIMEDocumentValidationResult> getDocumentDataExtractor() {
        if (docDataExtractor == null) {
            docDataExtractor = new DataExtractor<SMIMEDocument, SMIMEDocumentValidationResult>(){

                public void extractData(SMIMEDocument source, SMIMEDocumentValidationResult destination) {
                    destination.setObjectName(source.getName());
                    List<ValidationResult> validationResultList = source.getValidationResultList();
                    if (validationResultList != null) {
                        destination.getAdditonalValidationResult().addAll(validationResultList);
                    }
                }
            };
        }
        return docDataExtractor;
    }

    public synchronized void initialize(InstanceProvider instanceProvider) throws Exception {
        super.initialize(instanceProvider);
        if (instanceProvider != null) {
            this.cadesPlugin = (CAdESPlugin)instanceProvider.getPlugin(Plugin.PluginID.VALIDATE_CADES, CAdESPlugin.class);
        }
    }

    public DataExtractor<? super CMSSignature, ? super CAdESSignatureValidationResult> getSignatureDataExtractor() {
        return new AdESDataExtractor();
    }
}

