/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.smime;

import com.sun.mail.util.CRLFOutputStream;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.StreamUtil;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.tsp.ContentInfo;
import de.governikus.csl.cades.CAdESDocument;
import de.governikus.csl.cades.CAdESPlugin;
import de.governikus.csl.smime.SMIMEDocument;
import de.governikus.csl.smime.SMIMEFileExtension;
import de.governikus.csl.smime.SMIMEType;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SignedFileAccessor;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.ValidatePluginException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.simplejavamail.outlookmessageparser.OutlookMessageParser;
import org.simplejavamail.outlookmessageparser.model.OutlookAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookFileAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMIMEParser
extends AbstractDocumentParser<SMIMEDocument> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMIMEParser.class);
    private static final String MIME_TYPE = "mime-type";
    private static final String ENCODING = "encoding";
    private static final String CONTENT_SMIME_TYPE = "smime-type";
    private static final String CONTENT_NAME = "name";
    private static final String PROTOCOL = "protocol";
    private static final String CONTENT_DISPOSITION_TYPE = "content-disposition-type";
    private CAdESPlugin cadesPlugin;
    private TempDataManager tempDataManager;

    public SMIMEParser(CAdESPlugin cadesPlugin, TempDataManager tempDataManager, Configuration configuration) {
        this.cadesPlugin = cadesPlugin;
        this.tempDataManager = tempDataManager;
    }

    public SMIMEDocument loadDocument(SignedData sda) throws ValidatePluginException, IOException, MessagingException, ParseException {
        SMIMEDocument docToValidate = null;
        try {
            docToValidate = this.loadSMIMEDocument(sda);
            if (docToValidate == null) {
                docToValidate = this.loadMicrosoftOutlookMessage(sda);
            }
            if (docToValidate == null) {
                docToValidate = this.loadMicrosoftOutlookMessageWithOutlookMessageParser(sda);
            }
        }
        catch (Exception e) {
            docToValidate = this.loadMicrosoftOutlookMessageWithOutlookMessageParser(sda);
        }
        if (docToValidate == null) {
            throw new ParseException("Can not parse document");
        }
        return docToValidate;
    }

    public SMIMEDocument loadSMIMEDocument(SignedData sda) throws Exception {
        SMIMEDocument smimeDocument;
        block21: {
            MimeMessage message = null;
            smimeDocument = null;
            Session session = Session.getDefaultInstance((Properties)System.getProperties());
            try (InputStream is = sda.getSignature().getInputStream();){
                message = new MimeMessage(session, is);
                smimeDocument = new SMIMEDocument(sda.getSignature().getName());
                Map<String, String> headerDataMap = this.extractHeaderData(message, smimeDocument);
                if (this.isMultipartSMIME(headerDataMap)) {
                    if (!this.parseMultiPartMessage(message, smimeDocument)) {
                        de.governikus.csl.uom.validate.commons.ValidationMessageCode formatFailure = smimeDocument.getValidationResultList().stream().map(v -> (ValidationMessageCode)v.getMessages().get(0)).filter(m -> m.getMessageCode().equals("multipart_message_not_two_bodyparts")).findAny().orElse(null);
                        if (formatFailure != null && smimeDocument.getName().endsWith(".msg")) {
                            SMIMEDocument sMIMEDocument = this.loadMicrosoftOutlookMessage(sda);
                            return sMIMEDocument;
                        }
                    }
                    break block21;
                }
                if (this.isPKCS7SMIME(headerDataMap)) {
                    this.parsePKCS7Message(message, smimeDocument);
                    break block21;
                }
                SMIMEDocument sMIMEDocument = null;
                return sMIMEDocument;
            }
        }
        return smimeDocument;
    }

    public SMIMEDocument loadMicrosoftOutlookMessage(SignedData sda) throws IOException, ParseException, MessagingException, ValidatePluginException {
        SMIMEDocument smimeDocument = null;
        Session session = Session.getDefaultInstance((Properties)System.getProperties());
        try (BufferedInputStream is = new BufferedInputStream(sda.getSignature().getInputStream());){
            MAPIMessage mapiMessage = new MAPIMessage((InputStream)is);
            smimeDocument = new SMIMEDocument(sda.getSignature().getName());
            if (!this.isMAPIMessageProcessible(mapiMessage, smimeDocument)) {
                SMIMEDocument sMIMEDocument = smimeDocument;
                return sMIMEDocument;
            }
            this.parseAttachments(smimeDocument, session, mapiMessage);
        }
        return smimeDocument;
    }

    private void parseAttachments(SMIMEDocument smimeDocument, Session session, MAPIMessage mapiMessage) throws MessagingException, IOException, ValidatePluginException, ParseException {
        AttachmentChunks[] attachmentFiles;
        MimeMessage message = null;
        for (AttachmentChunks attachmentChunks : attachmentFiles = mapiMessage.getAttachmentFiles()) {
            String signatureFileName = attachmentChunks.getAttachFileName().toString();
            if (signatureFileName == null || !signatureFileName.startsWith("smime.p7")) continue;
            byte[] attachment = attachmentChunks.getEmbeddedAttachmentObject();
            message = new MimeMessage(session, (InputStream)new ByteArrayInputStream(attachment));
            Map<String, String> headerDataMap = this.extractHeaderData(message, smimeDocument);
            if (headerDataMap.get(MIME_TYPE) == null) {
                String mimeType = attachmentChunks.getChunks().length >= 3 ? attachmentChunks.getChunks()[2].toString() : "";
                headerDataMap.put(MIME_TYPE, mimeType);
            }
            if (this.isMultipartSMIME(headerDataMap)) {
                this.parseMultiPartMessage(message, smimeDocument);
                continue;
            }
            if (this.isPKCS7SMIME(headerDataMap)) {
                this.parsePKCS7Message(message, smimeDocument);
                continue;
            }
            throw new ParseException("Not a valid attachment");
        }
    }

    public SMIMEDocument loadMicrosoftOutlookMessageWithOutlookMessageParser(SignedData sda) throws IOException, ValidatePluginException, MessagingException, ParseException {
        OutlookMessageParser outlookMessageParser = new OutlookMessageParser();
        OutlookMessage outlookMsg = null;
        SMIMEDocument smimeDocument = null;
        try (InputStream is = sda.getSignature().getInputStream();){
            outlookMsg = outlookMessageParser.parseMsg(is);
            smimeDocument = new SMIMEDocument(sda.getSignature().getName());
            this.parsePKCS7OutlookMessage(outlookMsg, smimeDocument);
        }
        return smimeDocument;
    }

    private boolean isMAPIMessageProcessible(MAPIMessage mapiMessage, SMIMEDocument smimeDocument) {
        try {
            mapiMessage.getMessageClassEnum();
        }
        catch (ChunkNotFoundException e) {
            return false;
        }
        if (mapiMessage.getAttachmentFiles().length != 1) {
            smimeDocument.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)SVPFactory.createMessageCode((String)"mapi_not_one_message_file", (Object[])new Object[]{smimeDocument.getName()})));
            return false;
        }
        Chunk[] chunks = mapiMessage.getMainChunks().getChunks();
        String smimeType = Arrays.stream(chunks).map(Object::toString).filter(s -> s.contains(CONTENT_SMIME_TYPE)).findAny().orElse(null);
        if (smimeType != null) {
            String[] split = smimeType.split(";");
            if ((smimeType = (String)Arrays.stream(split).filter(s -> s.contains(CONTENT_SMIME_TYPE)).map(x -> x.replaceAll("\\s+", "")).findAny().orElse(null)) != null) {
                int pos = smimeType.indexOf("smime-type=") + CONTENT_SMIME_TYPE.length() + 1;
                String type = smimeType.substring(pos, smimeType.length());
                smimeDocument.setSMIMEType(SMIMEType.fromTypeName(type));
            }
            return this.isSMIMETypeProcessible(smimeDocument);
        }
        return true;
    }

    private boolean isMultipartSMIME(Map<String, String> headerDataMap) {
        String mimeType = headerDataMap.get(MIME_TYPE);
        String protocol = headerDataMap.get(PROTOCOL);
        if (mimeType != null && protocol != null && mimeType.equals("multipart/signed") && (protocol.equals("application/pkcs7-signature") || protocol.equals("application/x-pkcs7-signature"))) {
            return true;
        }
        LOGGER.debug("Not a multipart MIME message or bad protocol '{}' / '{}'!", (Object)mimeType, (Object)protocol);
        return false;
    }

    private boolean checkBodyParts(MimeMessage message, SMIMEDocument smimeDocument) {
        try {
            MimeMultipart content = (MimeMultipart)message.getContent();
            if (content.getCount() == 2 && content.getBodyPart(0).getSize() > 0 && content.getBodyPart(1).getSize() > 0) {
                return true;
            }
        }
        catch (IOException | ClassCastException | MessagingException e) {
            LOGGER.error("Error parsing MIME message body parts!", e);
            return false;
        }
        smimeDocument.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (ValidationMessageCode)SVPFactory.createMessageCode((String)"multipart_message_not_two_bodyparts", (Object[])new Object[]{smimeDocument.getName()})));
        return false;
    }

    private boolean isPKCS7SMIME(Map<String, String> headerDataMap) {
        String[] allowedMimeTypes = new String[]{"application/pkcs7-mime", "application/x-pkcs7-mime"};
        return Arrays.asList(allowedMimeTypes).contains(headerDataMap.get(MIME_TYPE));
    }

    private boolean isSMIMETypeProcessible(SMIMEDocument smimeDocument) {
        if (SMIMEType.ENVELOPED_DATA.equals((Object)smimeDocument.getSMIMEType())) {
            smimeDocument.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (ValidationMessageCode)SVPFactory.createMessageCode((String)"smime_contains_encrypted_data", (Object[])new Object[]{smimeDocument.getName()})));
            return false;
        }
        if (SMIMEType.CERTS_ONLY.equals((Object)smimeDocument.getSMIMEType()) || SMIMEFileExtension.CERTS_ONLY.equals((Object)smimeDocument.getSMIMEFileExtension())) {
            smimeDocument.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (ValidationMessageCode)SVPFactory.createMessageCode((String)"smime_contains_only_certificates", (Object[])new Object[]{smimeDocument.getName()})));
            return false;
        }
        return true;
    }

    private boolean parseMultiPartMessage(MimeMessage message, SMIMEDocument smimeDocument) throws IOException, MessagingException, ValidatePluginException, ParseException {
        String sigFilename;
        if (!this.isSMIMETypeProcessible(smimeDocument)) {
            return false;
        }
        if (!this.checkBodyParts(message, smimeDocument)) {
            return false;
        }
        MimeMultipart content = (MimeMultipart)message.getContent();
        BodyPart bodyPartSig = content.getBodyPart(1);
        File signatureFile = this.tempDataManager.createTempFile("", ".signature");
        try (FileOutputStream os = new FileOutputStream(signatureFile);
             InputStream ris = bodyPartSig.getInputStream();){
            StreamUtil.read((InputStream)ris, (OutputStream)os);
        }
        try {
            sigFilename = bodyPartSig.getFileName();
        }
        catch (MessagingException ex) {
            sigFilename = signatureFile.getName();
        }
        File contentFile = this.tempDataManager.createTempFile("", ".content");
        BodyPart bodyPart0 = content.getBodyPart(0);
        try (CRLFOutputStream os = new CRLFOutputStream((OutputStream)new FileOutputStream(contentFile));){
            bodyPart0.writeTo((OutputStream)os);
        }
        SignedFileAccessor signedData = new SignedFileAccessor(signatureFile, sigFilename, contentFile, smimeDocument.getName());
        this.parseSignature(bodyPartSig, smimeDocument, signatureFile, (SignedData)signedData);
        return true;
    }

    private boolean parsePKCS7Message(MimeMessage message, SMIMEDocument smimeDocument) throws MessagingException, IOException, ValidatePluginException, ParseException {
        String sigFilename;
        if (!this.isSMIMETypeProcessible(smimeDocument)) {
            return false;
        }
        File signatureFile = this.tempDataManager.createTempFile("", ".smime");
        try (InputStream mis = message.getInputStream();
             FileOutputStream os = new FileOutputStream(signatureFile);){
            StreamUtil.read((InputStream)mis, (OutputStream)os);
        }
        try {
            sigFilename = message.getFileName();
        }
        catch (MessagingException ex) {
            sigFilename = signatureFile.getName();
        }
        SignedFileAccessor signedData = new SignedFileAccessor(signatureFile, sigFilename, null, null);
        this.parseSignature(message, smimeDocument, signatureFile, (SignedData)signedData);
        return true;
    }

    private void parsePKCS7OutlookMessage(OutlookMessage message, SMIMEDocument smimeDocument) throws MessagingException, IOException, ValidatePluginException, ParseException {
        File signatureFile = this.tempDataManager.createTempFile("", ".smime");
        List outlookAttachments = message.getOutlookAttachments();
        for (OutlookAttachment outlookAttachment : outlookAttachments) {
            String sigFilename = null;
            if (outlookAttachment instanceof OutlookFileAttachment) {
                byte[] attachmentData = ((OutlookFileAttachment)outlookAttachment).getData();
                try (ByteArrayInputStream mis = new ByteArrayInputStream(attachmentData);
                     FileOutputStream os = new FileOutputStream(signatureFile);){
                    StreamUtil.read((InputStream)mis, (OutputStream)os);
                }
                sigFilename = ((OutlookFileAttachment)outlookAttachment).getFilename();
            }
            if (sigFilename == null) {
                sigFilename = smimeDocument.getName();
            }
            SignedFileAccessor signedData = new SignedFileAccessor(signatureFile, sigFilename, null, null);
            Session session = Session.getDefaultInstance((Properties)System.getProperties());
            InputStream is = signedData.getSignature().getInputStream();
            Throwable throwable = null;
            try {
                MimeMessage mimeMessage = new MimeMessage(session, is);
                this.parseSignature(mimeMessage, smimeDocument, signatureFile, (SignedData)signedData);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private <T extends Part> void parseSignature(T message, SMIMEDocument smimeDocument, File signatureFile, SignedData signedData) throws ParseException, IOException, ValidatePluginException, MessagingException {
        CAdESDocument parsedCAdESDocument = null;
        try {
            parsedCAdESDocument = this.cadesPlugin.parseDocument(signedData, this.tempDataManager);
        }
        catch (ValidatePluginException pe) {
            Throwable throwable = null;
            try (FileOutputStream os = new FileOutputStream(signatureFile);){
                Throwable throwable2;
                InputStream ris;
                block28: {
                    block29: {
                        block30: {
                            ris = message.getInputStream();
                            throwable2 = null;
                            ContentInfo info = this.getContentInfo(ris);
                            if (!ContentType.id_pkcs7_enveloped_data.equals((Object)info.getContentType())) break block28;
                            smimeDocument.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC, (ValidationMessageCode)SVPFactory.createMessageCode((String)"smime_contains_encrypted_data", (Object[])new Object[]{smimeDocument.getName()})));
                            if (ris == null) break block29;
                            if (throwable2 == null) break block30;
                            try {
                                ris.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block29;
                        }
                        ris.close();
                    }
                    return;
                }
                try {
                    try {
                        try {
                            throw pe;
                        }
                        catch (Throwable throwable4) {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (ris != null) {
                            if (throwable2 != null) {
                                try {
                                    ris.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                ris.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
            }
        }
        ArrayList<CAdESDocument> containedDocumentList = smimeDocument.getContainedObjectsToValidate();
        if (containedDocumentList == null) {
            containedDocumentList = new ArrayList<CAdESDocument>();
            smimeDocument.setContainedObjectsToValidate(containedDocumentList);
        }
        containedDocumentList.add(parsedCAdESDocument);
    }

    private ContentInfo getContentInfo(InputStream is) throws ParseException, IOException {
        return new ContentInfo(Run.create((Source)new BSource(is))){

            protected ANY generateContent(ContentType contentType2, Run run) throws ParseException {
                return null;
            }
        };
    }

    private Map<String, String> extractHeaderData(MimeMessage message, SMIMEDocument smimeDocument) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        this.extractMimeType(message, dataMap);
        this.extractContentDispositionType(message, dataMap);
        this.extractEncoding(message, dataMap);
        try {
            smimeDocument.setSubject(message.getSubject());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            smimeDocument.setMessageId(message.getMessageID());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            smimeDocument.setSentDate(message.getSentDate());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            smimeDocument.setSize(message.getSize());
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            smimeDocument.setSMIMEType(SMIMEType.fromTypeName((String)dataMap.get(CONTENT_SMIME_TYPE)));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            String name = (String)dataMap.get(CONTENT_NAME);
            int pos = name.lastIndexOf(46);
            smimeDocument.setSMIMEFileExtension(SMIMEFileExtension.fromExtension(name.substring(pos + 1)));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return dataMap;
    }

    private void extractEncoding(MimeMessage message, Map<String, String> dataMap) {
        try {
            String encoding = message.getEncoding();
            dataMap.put(ENCODING, encoding == null ? "7bit" : encoding);
        }
        catch (MessagingException me) {
            dataMap.put(ENCODING, "7bit");
        }
    }

    private void extractContentDispositionType(MimeMessage message, Map<String, String> dataMap) {
        try {
            String[] types;
            for (String type : types = message.getDisposition().split(";")) {
                int pos = type.indexOf(61);
                if (pos > 0) {
                    dataMap.put(type.substring(0, pos).trim(), type.substring(pos + 1).trim().replaceAll("\"", ""));
                    continue;
                }
                dataMap.put(CONTENT_DISPOSITION_TYPE, type.trim());
            }
        }
        catch (NullPointerException | MessagingException throwable) {
            // empty catch block
        }
    }

    private void extractMimeType(MimeMessage message, Map<String, String> dataMap) {
        try {
            String[] types;
            String contentType = message.getContentType();
            for (String type : types = contentType.split(";")) {
                int pos = type.indexOf(61);
                if (pos > 0) {
                    dataMap.put(type.substring(0, pos).trim(), type.substring(pos + 1).trim().replaceAll("\"", ""));
                    continue;
                }
                if (!(type = type.trim()).matches("^[\\p{IsAlphabetic}-]{3,}/[\\p{IsAlphabetic}\\p{Digit}-.]{3,}$")) continue;
                dataMap.put(MIME_TYPE, type);
            }
        }
        catch (NullPointerException | MessagingException throwable) {
            // empty catch block
        }
    }
}

